/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.ensembl;

import java.io.IOException;
import java.util.HashMap;
import umcg.genetica.containers.Chromosome;
import umcg.genetica.containers.Exon;
import umcg.genetica.containers.Gene;
import umcg.genetica.containers.Transcript;
import umcg.genetica.io.text.TextFile;

public class Features {
    private HashMap<String, Chromosome> chromosomeHash = new HashMap();
    private HashMap<String, Gene> geneHash = new HashMap();
    private HashMap<String, Transcript> transcriptHash = new HashMap();
    private HashMap<String, Exon> exonHash = new HashMap();

    public HashMap<String, Chromosome> getChromosomeHash() {
        return this.chromosomeHash;
    }

    public void setChromosomeHash(HashMap<String, Chromosome> chromosomeHash) {
        this.chromosomeHash = chromosomeHash;
    }

    public HashMap<String, Gene> getGeneHash() {
        return this.geneHash;
    }

    public void setGeneHash(HashMap<String, Gene> geneHash) {
        this.geneHash = geneHash;
    }

    public HashMap<String, Transcript> getTranscriptHash() {
        return this.transcriptHash;
    }

    public void setTranscriptHash(HashMap<String, Transcript> transcriptHash) {
        this.transcriptHash = transcriptHash;
    }

    public HashMap<String, Exon> getExonHash() {
        return this.exonHash;
    }

    public void setExonHash(HashMap<String, Exon> exonHash) {
        this.exonHash = exonHash;
    }

    public void loadAnnotation(String fileName) throws IOException {
        System.out.println("Loading sequence feature annotation from: " + fileName);
        TextFile in = new TextFile(fileName, false);
        String[] linesplit = in.readLineElems(TextFile.tab);
        HashMap<String, Integer> elementToColId = new HashMap<String, Integer>();
        for (int i = 0; i < linesplit.length; ++i) {
            System.out.println(linesplit[i] + "\t" + i);
            elementToColId.put(linesplit[i], i);
        }
        int lnCounter = 0;
        String[] elems = in.readLineElems(TextFile.tab);
        while (elems != null) {
            if (elems.length > 1) {
                String gene = elems[(Integer)elementToColId.get("Ensembl Gene ID")];
                String transcript = elems[(Integer)elementToColId.get("Ensembl Transcript ID")];
                String protein = elems[(Integer)elementToColId.get("Ensembl Protein ID")];
                String chromosome = elems[(Integer)elementToColId.get("Chromosome Name")];
                Integer genestart = Integer.parseInt(elems[(Integer)elementToColId.get("Gene Start (bp)")]);
                Integer genestop = Integer.parseInt(elems[(Integer)elementToColId.get("Gene End (bp)")]);
                Integer transcriptstart = Integer.parseInt(elems[(Integer)elementToColId.get("Transcript Start (bp)")]);
                Integer transcriptstop = Integer.parseInt(elems[(Integer)elementToColId.get("Transcript End (bp)")]);
                Integer strand = Integer.parseInt(elems[(Integer)elementToColId.get("Strand")]);
                String hgnc = elems[(Integer)elementToColId.get("Associated Gene Name")];
                String exon = elems[(Integer)elementToColId.get("Ensembl Exon ID")];
                Integer exonstart = Integer.parseInt(elems[(Integer)elementToColId.get("Exon Chr Start (bp)")]);
                Integer exonend = Integer.parseInt(elems[(Integer)elementToColId.get("Exon Chr End (bp)")]);
                Integer exonrankintranscript = Integer.parseInt(elems[(Integer)elementToColId.get("Exon Rank in Transcript")]);
                Chromosome currChr = null;
                Gene currGen = null;
                Transcript currTra = null;
                Exon currExo = null;
                if (chromosome.trim().length() > 0) {
                    if (this.chromosomeHash.get(chromosome) == null) {
                        Chromosome tmpChr = new Chromosome(chromosome);
                        tmpChr.setName(chromosome);
                        this.chromosomeHash.put(chromosome, tmpChr);
                        System.out.println("Adding chromosome: " + chromosome);
                    }
                    currChr = this.chromosomeHash.get(chromosome);
                }
                if (gene.trim().length() > 0) {
                    if (this.geneHash.get(gene) == null) {
                        Gene tmpGen = new Gene();
                        tmpGen.setName(gene);
                        tmpGen.setStart(genestart);
                        tmpGen.setEnd(genestop);
                        tmpGen.setStrand(strand);
                        tmpGen.setAnnotation(hgnc);
                        this.geneHash.put(gene, tmpGen);
                    }
                    currGen = this.geneHash.get(gene);
                }
                if (transcript.trim().length() > 0) {
                    if (this.transcriptHash.get(transcript) == null) {
                        Transcript tmpTra = new Transcript();
                        tmpTra.setName(transcript);
                        tmpTra.setStart(transcriptstart);
                        tmpTra.setEnd(transcriptstop);
                        tmpTra.setStrand(strand);
                        tmpTra.setProtein(protein);
                        this.transcriptHash.put(transcript, tmpTra);
                    }
                    currTra = this.transcriptHash.get(transcript);
                }
                if (exon.trim().length() > 0) {
                    if (this.exonHash.get(exon) == null) {
                        Exon tmpExo = new Exon();
                        tmpExo.setName(exon);
                        tmpExo.setStart(exonstart);
                        tmpExo.setEnd(exonend);
                        tmpExo.setStrand(strand);
                        this.exonHash.put(exon, tmpExo);
                    }
                    currExo = this.exonHash.get(exon);
                }
                if (currGen != null) {
                    currChr.addGene(currGen);
                    currGen.setParentChromosome(currChr);
                }
                if (currGen != null && currTra != null) {
                    currGen.addTranscript(currTra);
                    currTra.setParentGene(currGen);
                    currTra.setParentChromosome(currChr);
                }
                if (currTra != null && currExo != null) {
                    currTra.addExon(currExo);
                    currExo.setParentTranscript(currTra);
                    currExo.setParentChromosome(currChr);
                    currTra.setExonRank(currExo, exonrankintranscript);
                }
            }
            if (lnCounter % 100000 == 0) {
                System.out.print(".");
            }
            elems = in.readLineElems(TextFile.tab);
            ++lnCounter;
        }
        System.out.println("\tDone.");
        in.close();
        System.out.println("Loaded " + this.chromosomeHash.size() + " chromosomes, " + this.geneHash.size() + " genes, " + this.transcriptHash.size() + " transcripts, " + this.exonHash.size() + " exons.");
    }

    public Exon getExon(String match) {
        return this.exonHash.get(match);
    }

    public Transcript getTranscript(String match) {
        return this.transcriptHash.get(match);
    }
}

