/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.console;

import umcg.genetica.util.RunTimer;

public class ProgressBar {
    private RunTimer timer;
    private long iterations = 0L;
    private long maxIterations = 0L;
    private int printEvery = 0;
    private int width = 25;
    private int maxwidth = 0;
    private boolean isLong = false;

    public ProgressBar(long length) {
        this.isLong = true;
        this.maxIterations = length;
        this.printEvery = (int)Math.ceil((double)length / (double)this.width);
        this.timer = new RunTimer();
        System.out.println("\nProgress:");
        String out = "|";
        for (int i = 0; i < this.width - 1; ++i) {
            out = out + "-";
        }
        out = out + "| Waiting for update...\r";
        this.maxwidth = out.length();
        System.out.print(out);
    }

    public ProgressBar(long length, String title) {
        this.maxIterations = length;
        this.printEvery = (int)Math.ceil((double)length / (double)this.width);
        this.timer = new RunTimer();
        System.out.println("\n" + title);
        String out = "|";
        for (int i = 0; i < this.width - 1; ++i) {
            out = out + "-";
        }
        out = out + "| Waiting for update...\r";
        this.maxwidth = out.length();
        System.out.print(out);
    }

    public void iterate() {
        ++this.iterations;
        if (this.iterations % (long)this.printEvery == 0L) {
            this.print();
        }
    }

    public void set(long num) {
        this.iterations = num;
        this.print();
    }

    public void print() {
        if (this.printEvery > 0) {
            int i;
            StringBuilder out = new StringBuilder(this.maxwidth);
            int numToPrint = (int)Math.ceil((double)this.iterations / (double)this.printEvery);
            if (numToPrint > this.width) {
                numToPrint = this.width;
            }
            out.append("|");
            for (i = 0; i < numToPrint; ++i) {
                out.append("#");
            }
            for (i = 0; i < this.width - numToPrint - 1; ++i) {
                out.append("-");
            }
            out.append("| ");
            int perc = (int)Math.ceil((double)this.iterations / (double)this.maxIterations * 100.0);
            out.append(perc).append("% - T: ").append(this.timer.getTimeDesc());
            long diff = this.timer.getTimeDiff() / 1000000000L;
            double timePerIter = (double)diff / (double)this.iterations;
            double timeLeft = timePerIter * (double)(this.maxIterations - this.iterations);
            String strTimeLeft = this.timer.getTimeDesc((long)timeLeft * 1000000000L);
            out.append(" T-: ").append(strTimeLeft);
            out.append(" #: ").append(this.iterations).append("/").append(this.maxIterations);
            int length = out.toString().length();
            if (length < this.maxwidth) {
                int difflen = this.maxwidth - out.length();
                if (difflen > 0) {
                    for (int i2 = 0; i2 < difflen; ++i2) {
                        out.append(" ");
                    }
                }
            } else {
                this.maxwidth = length;
            }
            out.append("\r");
            System.out.print(out.toString());
        }
    }

    public void close() {
        this.iterations = this.maxIterations;
        this.print();
        System.out.println("");
    }
}

