/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.analysis;

import JSci.maths.analysis.Power;
import JSci.maths.analysis.RealFunction;

public class Exponential
extends RealFunction {
    private final double A;
    private final double w;
    private final double n;
    private final double k;

    public Exponential() {
        this(1.0, 1.0, 0.0, 1.0);
    }

    public Exponential(double d, double d2, double d3) {
        this(d, d2, d3, 1.0);
    }

    public Exponential(double d, double d2, double d3, double d4) {
        this.A = d;
        this.w = d2;
        this.k = d3;
        this.n = d4;
    }

    public double map(double d) {
        d += this.k;
        if (this.n != 1.0) {
            d = this.n == 2.0 ? (d *= d) : Math.pow(d, this.n);
        }
        return this.A * Math.exp(this.w * d);
    }

    public RealFunction differentiate() {
        RealFunction realFunction = new Exponential(this.A * this.w, this.w, this.k, this.n);
        if (this.n != 1.0) {
            realFunction = new Power(this.n, this.k, this.n - 1.0).multiply(realFunction);
        }
        return realFunction;
    }
}

