/*
 * Decompiled with CFR 0.152.
 */
package JSci.chemistry;

import JSci.chemistry.Element;
import JSci.chemistry.periodictable.AlkaliEarthMetal;
import JSci.chemistry.periodictable.AlkaliMetal;
import JSci.chemistry.periodictable.Halogen;
import JSci.chemistry.periodictable.Metal;
import JSci.chemistry.periodictable.NobleGas;
import JSci.chemistry.periodictable.NonMetal;
import JSci.chemistry.periodictable.RareEarthMetal;
import JSci.chemistry.periodictable.TransitionMetal;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class PeriodicTable {
    private static final Map table = new HashMap();
    private static Map symbols;
    static /* synthetic */ Class class$JSci$chemistry$PeriodicTable;

    private PeriodicTable() {
    }

    public static String getName(String string) {
        if (symbols == null) {
            symbols = PeriodicTable.loadIndex();
        }
        return (String)symbols.get(string);
    }

    public static Element getElement(String string) {
        Element element = (Element)table.get(string = string.toLowerCase());
        if (element == null && (element = PeriodicTable.loadElement("periodictable/" + string + ".xml")) != null) {
            table.put(string, element);
        }
        return element;
    }

    private static Map loadIndex() {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse((class$JSci$chemistry$PeriodicTable == null ? (class$JSci$chemistry$PeriodicTable = PeriodicTable.class$("JSci.chemistry.PeriodicTable")) : class$JSci$chemistry$PeriodicTable).getResource("periodictable/index.xml").toString());
            org.w3c.dom.Element element = document.getDocumentElement();
            NodeList nodeList = element.getChildNodes();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!node.getNodeName().equals("element")) continue;
                NamedNodeMap namedNodeMap = node.getAttributes();
                hashMap.put(namedNodeMap.getNamedItem("symbol").getNodeValue(), namedNodeMap.getNamedItem("name").getNodeValue());
            }
            return hashMap;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            return Collections.EMPTY_MAP;
        }
        catch (IOException iOException) {
            return Collections.EMPTY_MAP;
        }
        catch (SAXException sAXException) {
            return Collections.EMPTY_MAP;
        }
    }

    private static Element loadElement(String string) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse((class$JSci$chemistry$PeriodicTable == null ? (class$JSci$chemistry$PeriodicTable = PeriodicTable.class$("JSci.chemistry.PeriodicTable")) : class$JSci$chemistry$PeriodicTable).getResource(string).toString());
            org.w3c.dom.Element element = document.getDocumentElement();
            String string2 = element.getAttributes().getNamedItem("series").getNodeValue();
            NodeList nodeList = element.getChildNodes();
            String string3 = PeriodicTable.findStringValue(nodeList, "name");
            String string4 = PeriodicTable.findStringValue(nodeList, "symbol");
            Element element2 = string2.equals("non-metal") ? new NonMetal(string3, string4) : (string2.equals("halogen") ? new Halogen(string3, string4) : (string2.equals("noble-gas") ? new NobleGas(string3, string4) : (string2.equals("metal") ? new Metal(string3, string4) : (string2.equals("alkali-metal") ? new AlkaliMetal(string3, string4) : (string2.equals("alkali-earth-metal") ? new AlkaliEarthMetal(string3, string4) : (string2.equals("rare-earth-metal") ? new RareEarthMetal(string3, string4) : (string2.equals("transition-metal") ? new TransitionMetal(string3, string4) : new Element(string3, string4))))))));
            element2.setAtomicNumber(Integer.parseInt(PeriodicTable.findStringValue(nodeList, "atomic-number")));
            element2.setMassNumber(Integer.parseInt(PeriodicTable.findStringValue(nodeList, "mass-number")));
            element2.setElectronegativity(PeriodicTable.findDoubleValue(nodeList, "electronegativity"));
            element2.setCovalentRadius(PeriodicTable.findDoubleValue(nodeList, "covalent-radius"));
            element2.setAtomicRadius(PeriodicTable.findDoubleValue(nodeList, "atomic-radius"));
            element2.setMeltingPoint(PeriodicTable.findDoubleValue(nodeList, "melting-point"));
            element2.setBoilingPoint(PeriodicTable.findDoubleValue(nodeList, "boiling-point"));
            element2.setDensity(PeriodicTable.findDoubleValue(nodeList, "density"));
            element2.setSpecificHeat(PeriodicTable.findDoubleValue(nodeList, "specific-heat"));
            element2.setElectricalConductivity(PeriodicTable.findDoubleValue(nodeList, "electrical-conductivity"));
            element2.setThermalConductivity(PeriodicTable.findDoubleValue(nodeList, "thermal-conductivity"));
            return element2;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
        catch (SAXException sAXException) {
            return null;
        }
    }

    private static String findStringValue(NodeList nodeList, String string) {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!node.getNodeName().equals(string)) continue;
            return node.getFirstChild().getNodeValue();
        }
        return "";
    }

    private static double findDoubleValue(NodeList nodeList, String string) {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!node.getNodeName().equals(string)) continue;
            return Double.parseDouble(node.getFirstChild().getNodeValue());
        }
        return Double.NaN;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

