/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.jstats.distributions;

import nl.tudelft.simulation.jstats.distributions.DistContinuous;
import nl.tudelft.simulation.jstats.streams.StreamInterface;

public class DistTriangular
extends DistContinuous {
    private double a;
    private double b;
    private double c;

    public DistTriangular(StreamInterface stream, double a, double b, double c) {
        super(stream);
        if (!(a < b) || !(b < c)) {
            throw new IllegalArgumentException("Error condition for tria: a<b<c");
        }
        this.a = a;
        this.b = b;
        this.c = c;
    }

    public double draw() {
        double u = this.stream.nextDouble();
        if (u <= (this.b - this.a) / (this.c - this.a)) {
            return this.a + Math.sqrt((this.b - this.a) * (this.c - this.a) * u);
        }
        return this.c - Math.sqrt((this.c - this.a) * (this.c - this.b) * (1.0 - u));
    }

    public double probDensity(double observation) {
        if (observation >= this.a && observation <= this.b) {
            return 2.0 * (observation - this.a) / ((this.c - this.a) * (this.b - this.a));
        }
        if (observation >= this.b && observation <= this.c) {
            return 2.0 * (this.c - observation) / ((this.c - this.a) * (this.c - this.b));
        }
        return 0.0;
    }

    public String toString() {
        return "Triangular(" + this.a + "," + this.b + "," + this.c + ")";
    }
}

