/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.jstats.distributions;

import cern.jet.stat.Gamma;
import nl.tudelft.simulation.jstats.distributions.DistContinuous;
import nl.tudelft.simulation.jstats.distributions.DistGamma;
import nl.tudelft.simulation.jstats.streams.StreamInterface;

public class DistBeta
extends DistContinuous {
    private DistGamma dist1;
    private DistGamma dist2;
    private double alpha1;
    private double alpha2;

    public DistBeta(StreamInterface stream, double alpha1, double alpha2) {
        super(stream);
        if (!(alpha1 > 0.0) || !(alpha2 > 0.0)) {
            throw new IllegalArgumentException("Error alpha1 <= 0.0 or alpha2 <= 0.0");
        }
        this.alpha1 = alpha1;
        this.alpha2 = alpha2;
        this.dist1 = new DistGamma(stream, this.alpha1, 1.0);
        this.dist2 = new DistGamma(stream, this.alpha2, 1.0);
    }

    public double draw() {
        double y1 = this.dist1.draw();
        double y2 = this.dist2.draw();
        return y1 / (y1 + y2);
    }

    public double probDensity(double observation) {
        if (observation > 0.0 && observation < 1.0) {
            return Math.pow(observation, this.alpha1 - 1.0) * Math.pow(1.0 - observation, this.alpha2 - 1.0) / Gamma.beta((double)this.alpha1, (double)this.alpha2);
        }
        return 0.0;
    }

    public String toString() {
        return "Beta(" + this.alpha1 + "," + this.alpha2 + ")";
    }
}

