/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.target;

import java.util.HashSet;
import java.util.Set;
import org.springframework.aop.IntroductionAdvisor;
import org.springframework.aop.support.DefaultIntroductionAdvisor;
import org.springframework.aop.support.DelegatingIntroductionInterceptor;
import org.springframework.aop.target.AbstractPrototypeBasedTargetSource;
import org.springframework.aop.target.ThreadLocalTargetSourceStats;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.core.NamedThreadLocal;

public class ThreadLocalTargetSource
extends AbstractPrototypeBasedTargetSource
implements ThreadLocalTargetSourceStats,
DisposableBean {
    private static final long serialVersionUID = 1L;
    private final ThreadLocal<Object> targetInThread = new NamedThreadLocal("Thread-local instance of bean '" + this.getTargetBeanName() + "'");
    private final Set<Object> targetSet = new HashSet<Object>();
    private int invocationCount;
    private int hitCount;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getTarget() throws BeansException {
        ++this.invocationCount;
        Object target = this.targetInThread.get();
        if (target == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("No target for prototype '" + this.getTargetBeanName() + "' bound to thread: " + "creating one and binding it to thread '" + Thread.currentThread().getName() + "'"));
            }
            target = this.newPrototypeInstance();
            this.targetInThread.set(target);
            Set<Object> set = this.targetSet;
            synchronized (set) {
                this.targetSet.add(target);
            }
        } else {
            ++this.hitCount;
        }
        return target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        this.logger.debug((Object)"Destroying ThreadLocalTargetSource bindings");
        Set<Object> set = this.targetSet;
        synchronized (set) {
            for (Object target : this.targetSet) {
                this.destroyPrototypeInstance(target);
            }
            this.targetSet.clear();
        }
        this.targetInThread.remove();
    }

    public int getInvocationCount() {
        return this.invocationCount;
    }

    public int getHitCount() {
        return this.hitCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getObjectCount() {
        Set<Object> set = this.targetSet;
        synchronized (set) {
            return this.targetSet.size();
        }
    }

    public IntroductionAdvisor getStatsMixin() {
        DelegatingIntroductionInterceptor dii = new DelegatingIntroductionInterceptor(this);
        return new DefaultIntroductionAdvisor(dii, ThreadLocalTargetSourceStats.class);
    }
}

