/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.simulators;

import nl.tudelft.simulation.dsol.formalisms.devs.SimEventInterface;
import nl.tudelft.simulation.dsol.simulators.DESSSimulatorInterface;
import nl.tudelft.simulation.dsol.simulators.DEVDESSSimulatorInterface;
import nl.tudelft.simulation.dsol.simulators.DEVSSimulator;
import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;
import nl.tudelft.simulation.logger.Logger;

public class DEVDESSSimulator
extends DEVSSimulator
implements DEVDESSSimulatorInterface {
    protected double timeStep = 0.1;

    public double getTimeStep() {
        return this.timeStep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimeStep(double timeStep) {
        Object object = this.semaphore;
        synchronized (object) {
            if (timeStep < 0.0) {
                throw new IllegalArgumentException("timeStep < 0 ?");
            }
            this.timeStep = timeStep;
            this.fireEvent(DESSSimulatorInterface.TIME_STEP_CHANGED_EVENT, timeStep);
            Logger.finer((Object)this, (String)"setTimeStep", (String)(timeStep + ""));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.isRunning() && !this.eventList.isEmpty() && this.simulatorTime <= this.replication.getRunControl().getRunLength()) {
            Object object = this.semaphore;
            synchronized (object) {
                double runUntil = this.simulatorTime + this.timeStep;
                while (!this.eventList.isEmpty() && this.running && runUntil >= this.eventList.first().getAbsoluteExecutionTime()) {
                    SimEventInterface event = this.eventList.removeFirst();
                    this.simulatorTime = event.getAbsoluteExecutionTime();
                    this.fireEvent(SimulatorInterface.TIME_CHANGED_EVENT, this.simulatorTime, this.simulatorTime);
                    try {
                        event.execute();
                    }
                    catch (Exception exception) {
                        Logger.severe((Object)this, (String)"run", (Throwable)exception);
                    }
                }
                if (this.running) {
                    this.simulatorTime = runUntil;
                }
                this.fireEvent(SimulatorInterface.TIME_CHANGED_EVENT, this.simulatorTime, this.simulatorTime);
            }
        }
    }
}

