/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.animation.interpolation;

import java.awt.Color;

public class ColorInterpolation {
    private Color origin = null;
    private Color destination = null;
    private int[] calculatedRGBValues = new int[]{0, 0, 0};
    private int[] originalStartingRGBValues = new int[]{0, 0, 0};
    private int[] originalDestinationRGBValues = new int[]{0, 0, 0};
    private double startTime = Double.NaN;
    private double endTime = Double.NaN;

    public ColorInterpolation(Color originalStartingColor, Color originalDestinationColor, double startTime, double endTime) {
        if (endTime < startTime) {
            throw new IllegalArgumentException("endTime < startTime");
        }
        this.origin = originalStartingColor;
        this.destination = originalDestinationColor;
        this.startTime = startTime;
        this.endTime = endTime;
        this.originalStartingRGBValues[0] = originalStartingColor.getRed();
        this.originalStartingRGBValues[1] = originalStartingColor.getGreen();
        this.originalStartingRGBValues[2] = originalStartingColor.getBlue();
        this.originalDestinationRGBValues[0] = originalDestinationColor.getRed();
        this.originalDestinationRGBValues[1] = originalDestinationColor.getGreen();
        this.originalDestinationRGBValues[2] = originalDestinationColor.getBlue();
        for (int i = 0; i < this.calculatedRGBValues.length; ++i) {
            if (this.originalStartingRGBValues[i] != this.originalDestinationRGBValues[i]) continue;
            this.calculatedRGBValues[i] = this.originalStartingRGBValues[i];
        }
    }

    public Color getColor(double time) {
        if (time <= this.startTime) {
            return this.origin;
        }
        if (time >= this.endTime) {
            return this.destination;
        }
        double fraction = (time - this.startTime) / (this.endTime - this.startTime);
        for (int i = 0; i < this.calculatedRGBValues.length; ++i) {
            if (this.originalStartingRGBValues[i] < this.originalDestinationRGBValues[i]) {
                this.calculatedRGBValues[i] = this.originalStartingRGBValues[i] + (int)((double)(this.originalDestinationRGBValues[i] - this.originalStartingRGBValues[0]) * fraction);
            }
            if (this.originalStartingRGBValues[i] <= this.originalDestinationRGBValues[i]) continue;
            this.calculatedRGBValues[i] = this.originalStartingRGBValues[i] - (int)((double)(this.originalStartingRGBValues[i] - this.originalDestinationRGBValues[i]) * fraction);
        }
        int alpha = this.origin.getAlpha();
        if (this.origin.getAlpha() != this.destination.getAlpha()) {
            if (this.origin.getAlpha() < this.destination.getAlpha()) {
                alpha = this.origin.getAlpha() + (int)((double)(this.destination.getAlpha() - this.origin.getAlpha()) * fraction);
            }
            if (this.origin.getAlpha() > this.destination.getAlpha()) {
                alpha = this.origin.getAlpha() - (int)((double)(this.origin.getAlpha() - this.destination.getAlpha()) * fraction);
            }
        }
        return new Color(this.calculatedRGBValues[0], this.calculatedRGBValues[1], this.calculatedRGBValues[2], alpha);
    }
}

