/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.util;

import org.jfree.xml.attributehandlers.BooleanAttributeHandler;
import org.jfree.xml.attributehandlers.ByteAttributeHandler;
import org.jfree.xml.attributehandlers.DoubleAttributeHandler;
import org.jfree.xml.attributehandlers.FloatAttributeHandler;
import org.jfree.xml.attributehandlers.IntegerAttributeHandler;
import org.jfree.xml.attributehandlers.LongAttributeHandler;
import org.jfree.xml.attributehandlers.ShortAttributeHandler;
import org.jfree.xml.attributehandlers.StringAttributeHandler;

public class BasicTypeSupport {
    private BasicTypeSupport() {
    }

    public static String getHandlerClass(Class c) {
        if (c.equals(Integer.class) || c.equals(Integer.TYPE)) {
            return IntegerAttributeHandler.class.getName();
        }
        if (c.equals(Short.class) || c.equals(Short.TYPE)) {
            return ShortAttributeHandler.class.getName();
        }
        if (c.equals(Long.class) || c.equals(Long.TYPE)) {
            return LongAttributeHandler.class.getName();
        }
        if (c.equals(Boolean.class) || c.equals(Boolean.TYPE)) {
            return BooleanAttributeHandler.class.getName();
        }
        if (c.equals(Float.class) || c.equals(Float.TYPE)) {
            return FloatAttributeHandler.class.getName();
        }
        if (c.equals(Double.class) || c.equals(Double.TYPE)) {
            return DoubleAttributeHandler.class.getName();
        }
        if (c.equals(Byte.class) || c.equals(Byte.TYPE)) {
            return ByteAttributeHandler.class.getName();
        }
        if (c.equals(String.class)) {
            return StringAttributeHandler.class.getName();
        }
        throw new IllegalArgumentException("BasicTypeSupport.getHandlerClass(Class): this is no attribute type.");
    }

    public static boolean isBasicDataType(Class c) {
        if (c.equals(Integer.class) || c.equals(Integer.TYPE)) {
            return true;
        }
        if (c.equals(Short.class) || c.equals(Short.TYPE)) {
            return true;
        }
        if (c.equals(Long.class) || c.equals(Long.TYPE)) {
            return true;
        }
        if (c.equals(Boolean.class) || c.equals(Boolean.TYPE)) {
            return true;
        }
        if (c.equals(Float.class) || c.equals(Float.TYPE)) {
            return true;
        }
        if (c.equals(Double.class) || c.equals(Double.TYPE)) {
            return true;
        }
        if (c.equals(Byte.class) || c.equals(Byte.TYPE)) {
            return true;
        }
        return c.equals(String.class);
    }

    public static Class getClassRepresentation(String className) {
        if (className.equals("::double")) {
            return Double.TYPE;
        }
        if (className.equals("::boolean")) {
            return Boolean.TYPE;
        }
        if (className.equals("::int")) {
            return Integer.TYPE;
        }
        if (className.equals("::short")) {
            return Short.TYPE;
        }
        if (className.equals("::long")) {
            return Long.TYPE;
        }
        if (className.equals("::byte")) {
            return Byte.TYPE;
        }
        throw new IllegalArgumentException("This is none of my primitives.");
    }
}

