/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.genotype.vcf;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.molgenis.genotype.vcf.VcfSampleGenotype;
import org.molgenis.genotype.vcf.VcfSampleGenotypeParser;
import org.molgenis.genotype.vcf.VcfUtils;
import org.molgenis.util.tuple.KeyValueTuple;
import org.molgenis.util.tuple.Tuple;
import org.molgenis.util.tuple.WritableTuple;

public class VcfRecord {
    public static final String GENOTYPE_FORMAT = "GT";
    private final Tuple record;
    private static final Pattern TAB_PATTERN = Pattern.compile("\\t");
    private static final Pattern COMMA_PATTERN = Pattern.compile(",");
    private Map<String, List<String>> infoMap = null;

    public VcfRecord(Tuple record) {
        this.record = record;
    }

    public VcfRecord(String line, List<String> columnNames) {
        String[] values = TAB_PATTERN.split(line);
        if (values.length != columnNames.size()) {
            throw new IllegalArgumentException("The number of columns does not match the number of columnnames");
        }
        this.record = new KeyValueTuple();
        for (int i = 0; i < values.length; ++i) {
            ((WritableTuple)this.record).set(columnNames.get(i), (Object)new String(values[i]));
        }
    }

    public String getChrom() {
        return this.record.getString("#CHROM");
    }

    public Integer getPos() {
        return this.record.getInt("POS");
    }

    public List<String> getId() {
        String id = VcfUtils.checkNullValue(this.record.getString("ID"));
        if (id == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(Arrays.asList(id.split(";")));
    }

    public String getRef() {
        return this.record.getString("REF");
    }

    public List<String> getAlt() {
        String alt = VcfUtils.checkNullValue(this.record.getString("ALT"));
        if (alt == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(Arrays.asList(COMMA_PATTERN.split(alt)));
    }

    public List<String> getAlleles() {
        ArrayList<String> alleles = new ArrayList<String>();
        alleles.add(this.getRef());
        alleles.addAll(this.getAlt());
        return alleles;
    }

    public Double getQual() {
        String qual = VcfUtils.checkNullValue(this.record.getString("QUAL"));
        if (qual == null) {
            return null;
        }
        return this.record.getDouble("QUAL");
    }

    public List<String> getFilter() {
        String filter = VcfUtils.checkNullValue(this.record.getString("FILTER"));
        if (filter == null) {
            return null;
        }
        return Collections.unmodifiableList(Arrays.asList(filter.split(";")));
    }

    public String getInfo() {
        return VcfUtils.checkNullValue(this.record.getString("INFO"));
    }

    public List<String> getFormat() {
        String format = VcfUtils.checkNullValue(this.record.getString("FORMAT"));
        if (format == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(Arrays.asList(format.split(":")));
    }

    public String getSampleValue(String sampleName, String key) {
        String[] values;
        int index = this.getFormat().indexOf(key);
        if (index == -1) {
            return null;
        }
        String sampleRecord = this.record.getString(sampleName);
        if (sampleRecord != null && index < (values = sampleRecord.split(":")).length) {
            return values[index];
        }
        return null;
    }

    public VcfSampleGenotype getSampleGenotype(String sampleName) {
        String value = this.getSampleValue(sampleName, GENOTYPE_FORMAT);
        if (value == null) {
            return null;
        }
        return new VcfSampleGenotypeParser(value).parse();
    }

    public List<String> getInfo(String key) {
        if (this.infoMap == null) {
            this.infoMap = new LinkedHashMap<String, List<String>>();
            String infoString = this.getInfo();
            if (infoString != null) {
                String[] keyvalues;
                for (String keyvalue : keyvalues = infoString.split(";")) {
                    String[] kv = keyvalue.split("=");
                    if (kv.length == 1) {
                        this.infoMap.put(kv[0], Arrays.asList("TRUE"));
                        continue;
                    }
                    if (VcfUtils.checkNullValue(kv[1]) == null) continue;
                    this.infoMap.put(kv[0], Arrays.asList(COMMA_PATTERN.split(kv[1])));
                }
            }
        }
        if (!this.infoMap.keySet().contains(key)) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.infoMap.get(key));
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

