/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.genotype.variant.id;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.molgenis.genotype.variant.id.GeneticVariantId;

public class ListGeneticVariantId
extends GeneticVariantId {
    private final List<String> variantIds;

    protected ListGeneticVariantId(List<String> variantIds) {
        if (variantIds.size() < 2) {
            throw new IllegalArgumentException("Use SingleGeneticVariantId in case of single variant ID");
        }
        this.variantIds = variantIds;
    }

    protected ListGeneticVariantId(String primairyId, List<String> alternativeIds) {
        if (alternativeIds == null) {
            throw new IllegalArgumentException("Alternative IDs list is null");
        }
        if (alternativeIds.isEmpty()) {
            throw new IllegalArgumentException("Alternative IDs list is empty");
        }
        ArrayList<String> variantIdsBuilder = new ArrayList<String>(alternativeIds.size() + 1);
        variantIdsBuilder.add(primairyId);
        variantIdsBuilder.addAll(alternativeIds);
        this.variantIds = variantIdsBuilder;
    }

    @Override
    public String getPrimairyId() {
        return this.variantIds.get(0);
    }

    @Override
    public List<String> getVariantIds() {
        return Collections.unmodifiableList(this.variantIds);
    }

    @Override
    public String getConcatenatedId() {
        return this.getConcatenatedId(";");
    }

    @Override
    public String getConcatenatedId(String separator) {
        StringBuilder concatenatedIds = new StringBuilder();
        boolean notFirst = false;
        for (String variantId : this.variantIds) {
            if (notFirst) {
                concatenatedIds.append(separator);
            }
            concatenatedIds.append(variantId);
        }
        return concatenatedIds.toString();
    }

    @Override
    public boolean isIdInVariantIds(String queryId) {
        for (String variantId : this) {
            if (!variantId.equals(queryId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean onlyPrimairyId() {
        return false;
    }

    @Override
    public Iterator<String> iterator() {
        return this.getVariantIds().iterator();
    }

    @Override
    public List<String> getAlternativeIds() {
        return Collections.unmodifiableList(this.variantIds.subList(1, this.variantIds.size()));
    }

    @Override
    public boolean containsId() {
        return true;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.variantIds == null ? 0 : ((Object)this.variantIds).hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ListGeneticVariantId other = (ListGeneticVariantId)obj;
        return !(this.variantIds == null ? other.variantIds != null : !((Object)this.variantIds).equals(other.variantIds));
    }
}

