/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.genotype.oxford;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.molgenis.genotype.AbstractRandomAccessGenotypeData;
import org.molgenis.genotype.Alleles;
import org.molgenis.genotype.GenotypeDataException;
import org.molgenis.genotype.Sample;
import org.molgenis.genotype.Sequence;
import org.molgenis.genotype.SimpleSequence;
import org.molgenis.genotype.annotation.Annotation;
import org.molgenis.genotype.annotation.SampleAnnotation;
import org.molgenis.genotype.oxford.HapsGenotypeData;
import org.molgenis.genotype.oxford.OxfordSampleFile;
import org.molgenis.genotype.util.CalledDosageConvertor;
import org.molgenis.genotype.util.GeneticVariantTreeSet;
import org.molgenis.genotype.util.ProbabilitiesConvertor;
import org.molgenis.genotype.variant.GeneticVariant;
import org.molgenis.genotype.variant.ReadOnlyGeneticVariant;
import org.molgenis.genotype.variant.sampleProvider.CachedSampleVariantProvider;
import org.molgenis.genotype.variant.sampleProvider.SampleVariantUniqueIdProvider;
import org.molgenis.genotype.variant.sampleProvider.SampleVariantsProvider;

public class GenGenotypeData
extends AbstractRandomAccessGenotypeData
implements SampleVariantsProvider {
    private final RandomAccessFile hapsFileReader;
    private Map<String, SampleAnnotation> sampleAnnotations;
    private final int sampleVariantProviderUniqueId;
    private final SampleVariantsProvider sampleVariantProvider;
    private final GeneticVariantTreeSet<GeneticVariant> variants;
    private final LinkedHashMap<GeneticVariant, Long> variantSampleAllelesIndex;
    private final List<Sample> samples;
    private final HashSet<String> sequenceNames;
    private final int byteToReadForSampleAlleles;
    private static final Logger LOGGER = Logger.getLogger(HapsGenotypeData.class);
    private final double minimumPosteriorProbabilityToCall;
    private final List<Boolean> phasing;
    private static final double DEFAULT_MINIMUM_POSTERIOR_PROBABILITY_TO_CALL = (double)0.4f;

    public GenGenotypeData(String path) throws IOException {
        this(new File(path + ".gen"), new File(path + ".sample"));
    }

    public GenGenotypeData(String path, double minimumPosteriorProbabilityToCall) throws IOException {
        this(new File(path + ".gen"), new File(path + ".sample"), minimumPosteriorProbabilityToCall);
    }

    public GenGenotypeData(File genFile, File sampleFile) throws IOException {
        this(genFile, sampleFile, 1000);
    }

    public GenGenotypeData(File genFile, File sampleFile, double minimumPosteriorProbabilityToCall) throws IOException {
        this(genFile, sampleFile, 1000, minimumPosteriorProbabilityToCall);
    }

    public GenGenotypeData(File genFile, File sampleFile, int cacheSize) throws IOException {
        this(genFile, sampleFile, cacheSize, null, 0.4f);
    }

    public GenGenotypeData(File genFile, File sampleFile, int cacheSize, double minimumPosteriorProbabilityToCall) throws IOException {
        this(genFile, sampleFile, cacheSize, null, minimumPosteriorProbabilityToCall);
    }

    public GenGenotypeData(File genFile, File sampleFile, String forceSeqName) throws IOException {
        this(genFile, sampleFile, 1000, forceSeqName, 0.4f);
    }

    public GenGenotypeData(File genFile, File sampleFile, int cacheSize, String forceSeqName, double minimumPosteriorProbabilityToCall) throws IOException {
        if (genFile == null) {
            throw new IllegalArgumentException("genFile is null");
        }
        if (!genFile.isFile()) {
            throw new FileNotFoundException("gen file file not found at " + genFile.getAbsolutePath());
        }
        if (!genFile.canRead()) {
            throw new IOException("cannot read gen file at " + genFile.getAbsolutePath());
        }
        this.minimumPosteriorProbabilityToCall = minimumPosteriorProbabilityToCall;
        this.sampleVariantProviderUniqueId = SampleVariantUniqueIdProvider.getNextUniqueId();
        this.sampleVariantProvider = cacheSize > 0 ? new CachedSampleVariantProvider(this, cacheSize) : this;
        OxfordSampleFile oxfordSampleFile = new OxfordSampleFile(sampleFile);
        this.sampleAnnotations = oxfordSampleFile.getSampleAnnotations();
        this.samples = oxfordSampleFile.getSamples();
        this.phasing = Collections.unmodifiableList(Collections.nCopies(this.samples.size(), false));
        this.variants = new GeneticVariantTreeSet();
        this.variantSampleAllelesIndex = new LinkedHashMap();
        this.sequenceNames = new HashSet();
        this.hapsFileReader = new RandomAccessFile(genFile, "r");
        this.byteToReadForSampleAlleles = this.loadVariants(forceSeqName);
    }

    public List<Sequence> getSequences() {
        ArrayList<Sequence> sequences = new ArrayList<Sequence>();
        for (String seqName : this.getSeqNames()) {
            sequences.add(new SimpleSequence(seqName, null, this));
        }
        return sequences;
    }

    @Override
    public List<Sample> getSamples() {
        return Collections.unmodifiableList(this.samples);
    }

    @Override
    public Map<String, Annotation> getVariantAnnotationsMap() {
        return Collections.emptyMap();
    }

    @Override
    public Map<String, SampleAnnotation> getSampleAnnotationsMap() {
        return this.sampleAnnotations;
    }

    @Override
    public List<Alleles> getSampleVariants(GeneticVariant variant) {
        return ProbabilitiesConvertor.convertProbabilitiesToAlleles(variant.getSampleGenotypeProbilities(), variant.getVariantAlleles(), this.minimumPosteriorProbabilityToCall);
    }

    @Override
    public List<Boolean> getSamplePhasing(GeneticVariant variant) {
        return this.phasing;
    }

    @Override
    public int cacheSize() {
        return 0;
    }

    @Override
    public int getSampleVariantProviderUniqueId() {
        return this.sampleVariantProviderUniqueId;
    }

    @Override
    public byte[] getSampleCalledDosage(GeneticVariant variant) {
        return CalledDosageConvertor.convertCalledAllelesToCalledDosage(variant.getSampleVariants(), variant.getVariantAlleles(), null);
    }

    @Override
    public float[] getSampleDosage(GeneticVariant variant) {
        return ProbabilitiesConvertor.convertProbabilitiesToDosage(variant.getSampleGenotypeProbilities(), this.minimumPosteriorProbabilityToCall);
    }

    @Override
    public void close() throws IOException {
        this.hapsFileReader.close();
    }

    @Override
    public Iterator<GeneticVariant> iterator() {
        return this.variants.iterator();
    }

    @Override
    public List<String> getSeqNames() {
        return new ArrayList<String>(this.sequenceNames);
    }

    @Override
    public Iterable<GeneticVariant> getVariantsByPos(String seqName, int startPos) {
        return this.variants.getSequencePosVariants(seqName, startPos);
    }

    @Override
    public Iterable<GeneticVariant> getSequenceGeneticVariants(String seqName) {
        return this.variants.getSequenceVariants(seqName);
    }

    @Override
    public Iterable<GeneticVariant> getVariantsByRange(String seqName, int rangeStart, int rangeEnd) {
        return this.variants.getSequenceRangeVariants(seqName, rangeStart, rangeEnd);
    }

    private int loadVariants(String forceSeqName) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        byte[] buffer = new byte[8192];
        boolean eol = false;
        String seqName = null;
        String variantId = null;
        int position = 0;
        String allele1 = null;
        int longestedChunk = 0;
        int currentChunk = 0;
        int column = 0;
        while (!eol) {
            long posBeforeBufferRead = this.hapsFileReader.getFilePointer();
            int bytesRead = this.hapsFileReader.read(buffer);
            if (bytesRead == -1) {
                eol = true;
                continue;
            }
            block14: for (int i = 0; i < bytesRead; ++i) {
                block1 : switch (buffer[i]) {
                    case 10: 
                    case 13: {
                        if (currentChunk == 0) {
                            currentChunk = -1;
                            continue block14;
                        }
                        if (column != 5) {
                            LOGGER.fatal((Object)("Error reading haps file, did not detect first 5 columns with variant information \ncurrent column is:" + column + "\n" + "content in current column: " + stringBuilder.toString()));
                            throw new GenotypeDataException("Error reading haps file, did not detect first 5 columns with variant information. Note gen files must be space separted");
                        }
                        longestedChunk = longestedChunk < currentChunk ? currentChunk : longestedChunk;
                        column = 0;
                        currentChunk = -1;
                        break;
                    }
                    case 32: {
                        switch (column) {
                            case 0: {
                                seqName = forceSeqName == null ? stringBuilder.toString().intern() : forceSeqName;
                                this.sequenceNames.add(seqName);
                                ++column;
                                stringBuilder = new StringBuilder();
                                break block1;
                            }
                            case 1: {
                                variantId = stringBuilder.toString();
                                ++column;
                                stringBuilder = new StringBuilder();
                                break block1;
                            }
                            case 2: {
                                try {
                                    position = Integer.parseInt(stringBuilder.toString());
                                }
                                catch (NumberFormatException ex) {
                                    throw new GenotypeDataException("Error parsing \"" + stringBuilder.toString() + "\" as position in haps file");
                                }
                                ++column;
                                stringBuilder = new StringBuilder();
                                break block1;
                            }
                            case 3: {
                                allele1 = stringBuilder.toString();
                                ++column;
                                stringBuilder = new StringBuilder();
                                break block1;
                            }
                            case 4: {
                                String allele2 = stringBuilder.toString();
                                GeneticVariant variant = ReadOnlyGeneticVariant.createVariant(variantId, position, seqName, this.sampleVariantProvider, allele1, allele2);
                                this.variants.add(variant);
                                this.variantSampleAllelesIndex.put(variant, posBeforeBufferRead + (long)i + 1L);
                                ++column;
                                stringBuilder = new StringBuilder();
                                currentChunk = -1;
                                break block1;
                            }
                        }
                        break;
                    }
                    default: {
                        if (column >= 5) break;
                        stringBuilder.append((char)buffer[i]);
                    }
                }
                ++currentChunk;
            }
        }
        return longestedChunk;
    }

    @Override
    public boolean isOnlyContaingSaveProbabilityGenotypes() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float[][] getSampleProbilities(GeneticVariant variant) {
        int bytesRead;
        float[][] probs = new float[this.getSamples().size()][3];
        long start = this.variantSampleAllelesIndex.get(variant);
        byte[] buffer = new byte[this.byteToReadForSampleAlleles];
        try {
            RandomAccessFile randomAccessFile = this.hapsFileReader;
            synchronized (randomAccessFile) {
                this.hapsFileReader.seek(start);
                bytesRead = this.hapsFileReader.read(buffer);
            }
        }
        catch (IOException ex) {
            throw new GenotypeDataException("Error loading alleles for variant: " + variant.getPrimaryVariantId() + " from haps file");
        }
        if (bytesRead == -1) {
            throw new GenotypeDataException("Error loading alleles for variant: " + variant.getPrimaryVariantId() + " from haps file");
        }
        try {
            int i = 0;
            for (int s = 0; s < this.samples.size(); ++s) {
                float[] sampleProbs = new float[3];
                int currentProbIndex = 0;
                StringBuilder currentProb = new StringBuilder();
                while (currentProbIndex < 3) {
                    if (i == bytesRead) {
                        sampleProbs[currentProbIndex] = Float.parseFloat(currentProb.toString());
                        ++currentProbIndex;
                        break;
                    }
                    switch ((char)buffer[i]) {
                        case '\n': 
                        case '\r': 
                        case ' ': {
                            sampleProbs[currentProbIndex] = Float.parseFloat(currentProb.toString());
                            currentProb = new StringBuilder();
                            ++currentProbIndex;
                            break;
                        }
                        default: {
                            currentProb.append((char)buffer[i]);
                        }
                    }
                    ++i;
                }
                probs[s] = sampleProbs;
            }
        }
        catch (NumberFormatException e) {
            throw new GenotypeDataException("Error parsing probability value in gen file. " + e.getMessage());
        }
        return probs;
    }
}

