/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.labels;

import java.io.Serializable;
import java.text.MessageFormat;
import java.text.NumberFormat;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.PieToolTipGenerator;
import org.jfree.data.DatasetUtilities;
import org.jfree.data.PieDataset;

public class StandardPieItemLabelGenerator
implements PieToolTipGenerator,
PieSectionLabelGenerator,
Cloneable,
Serializable {
    public static final String DEFAULT_TOOLTIP_FORMAT = "{0}: ({1}, {2})";
    public static final String DEFAULT_SECTION_LABEL_FORMAT = "{0} = {1}";
    private String labelFormat;
    private NumberFormat numberFormat;
    private NumberFormat percentFormat;

    public StandardPieItemLabelGenerator() {
        this(DEFAULT_SECTION_LABEL_FORMAT, NumberFormat.getNumberInstance(), NumberFormat.getPercentInstance());
    }

    public StandardPieItemLabelGenerator(String labelFormat) {
        this(labelFormat, NumberFormat.getNumberInstance(), NumberFormat.getPercentInstance());
    }

    public StandardPieItemLabelGenerator(String labelFormat, NumberFormat numberFormat, NumberFormat percentFormat) {
        if (labelFormat == null) {
            throw new IllegalArgumentException("Null 'itemLabelFormat' argument.");
        }
        if (numberFormat == null) {
            throw new IllegalArgumentException("Null 'numberFormat' argument.");
        }
        if (percentFormat == null) {
            throw new IllegalArgumentException("Null 'percentFormat' argument.");
        }
        this.labelFormat = labelFormat;
        this.numberFormat = numberFormat;
        this.percentFormat = percentFormat;
    }

    public NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    public NumberFormat getPercentFormat() {
        return this.percentFormat;
    }

    public String generateSectionLabel(PieDataset dataset, Comparable key) {
        String result = null;
        if (dataset != null) {
            Object[] items = this.createItemArray(dataset, key);
            result = MessageFormat.format(this.labelFormat, items);
        }
        return result;
    }

    public String generateToolTip(PieDataset dataset, Comparable key) {
        return this.generateSectionLabel(dataset, key);
    }

    protected Object[] createItemArray(PieDataset dataset, Comparable key) {
        double v;
        Object[] result = new Object[3];
        result[0] = key.toString();
        Number value = dataset.getValue(key);
        result[1] = this.numberFormat.format(value);
        double percent = 0.0;
        if (value != null && (v = value.doubleValue()) > 0.0) {
            percent = v / DatasetUtilities.calculatePieDatasetTotal(dataset);
        }
        result[2] = this.percentFormat.format(percent);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof StandardPieItemLabelGenerator) {
            StandardPieItemLabelGenerator generator = (StandardPieItemLabelGenerator)obj;
            if (!this.labelFormat.equals(generator.labelFormat)) {
                return false;
            }
            if (!this.numberFormat.equals(generator.numberFormat)) {
                return false;
            }
            return this.percentFormat.equals(generator.percentFormat);
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        StandardPieItemLabelGenerator clone = (StandardPieItemLabelGenerator)super.clone();
        if (this.numberFormat != null) {
            clone.numberFormat = (NumberFormat)this.numberFormat.clone();
        }
        return clone;
    }
}

