/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.util.trityper.reader;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.nio.charset.Charset;

@SuppressWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"}, justification="Not accessed by untrusted code")
public class SNP {
    private byte chr;
    private int chrPos;
    private int id;
    private String name;
    private byte[] dosage;
    private byte[] alleles1;
    private byte[] alleles2;
    private Double HWEP;
    private Double MAF;
    private Double CR;
    private short[] genotypes;
    private double[] alleleFreq;
    private Byte minorAllele;
    private boolean passesQC;
    private byte[] alleles;
    public int nrCalled;
    private int[] genotypeFreq;

    public void setChr(byte chr) {
        this.chr = chr;
    }

    public void setChrPos(int chrPos) {
        this.chrPos = chrPos;
    }

    public byte getChr() {
        return this.chr;
    }

    public int getChrPos() {
        return this.chrPos;
    }

    public void setId(int snpId) {
        this.id = snpId;
    }

    public int getId() {
        return this.id;
    }

    public void setName(String snp) {
        this.name = snp;
    }

    public String getName() {
        return this.name;
    }

    public void setAlleles(byte[] allele1, byte[] allele2, Boolean[] indIncluded, Boolean[] indIsFemale) {
        this.alleles1 = allele1;
        this.alleles2 = allele2;
        this.genotypes = new short[allele1.length];
        this.alleles = new byte[3];
        int alleleItr = 0;
        int missingGenotypes = 0;
        this.genotypeFreq = new int[3];
        int nrTotal = 0;
        this.nrCalled = 0;
        for (int ind = 0; ind < this.alleles1.length; ++ind) {
            Boolean inc = indIncluded[ind];
            if (inc != null && inc.booleanValue() && (this.chr != 23 || indIsFemale[ind].booleanValue())) {
                ++nrTotal;
            }
            if (allele1[ind] != 0 && allele2[ind] != 0 && inc != null && inc.booleanValue()) {
                short genotypeCode;
                int i;
                if (this.chr != 23 || indIsFemale[ind].booleanValue()) {
                    ++this.nrCalled;
                }
                int allelecode1 = -1;
                int allelecode2 = -1;
                for (i = 0; i < 2; i = (int)((short)(i + 1))) {
                    if (this.alleles[i] != allele1[ind]) continue;
                    allelecode1 = i;
                }
                if (allelecode1 == -1) {
                    this.alleles[alleleItr] = allele1[ind];
                    allelecode1 = alleleItr;
                    if ((alleleItr = (int)((short)(alleleItr + 1))) > 2) {
                        System.out.println("ERROR!!!: Number of different alleles for SNP\t" + this.name + "\t is more than two!");
                        System.out.println("Allele 1:\t" + this.alleles[0] + " / " + new String(new byte[]{this.alleles[0]}, Charset.forName("UTF-8")));
                        System.out.println("Allele 2:\t" + this.alleles[1] + " / " + new String(new byte[]{this.alleles[1]}, Charset.forName("UTF-8")));
                        System.out.println("Allele 3:\t" + this.alleles[2] + " / " + new String(new byte[]{this.alleles[2]}, Charset.forName("UTF-8")));
                        break;
                    }
                }
                for (i = 0; i < 2; i = (int)((short)(i + 1))) {
                    if (this.alleles[i] != allele2[ind]) continue;
                    allelecode2 = i;
                }
                if (allelecode2 == -1) {
                    this.alleles[alleleItr] = allele2[ind];
                    allelecode2 = alleleItr;
                    if ((alleleItr = (int)((short)(alleleItr + 1))) > 2) {
                        System.out.println("ERROR!!!: Number of different alleles for SNP\t" + this.name + "\t is more than two!");
                        System.out.println("Allele 1:\t" + this.alleles[0] + " / " + new String(new byte[]{this.alleles[0]}, Charset.forName("UTF-8")));
                        System.out.println("Allele 2:\t" + this.alleles[1] + " / " + new String(new byte[]{this.alleles[1]}, Charset.forName("UTF-8")));
                        System.out.println("Allele 3:\t" + this.alleles[2] + " / " + new String(new byte[]{this.alleles[2]}, Charset.forName("UTF-8")));
                        break;
                    }
                }
                this.genotypes[ind] = genotypeCode = (short)(allelecode1 + allelecode2);
                if (this.chr == 23 && !indIsFemale[ind].booleanValue()) continue;
                short s = genotypeCode;
                this.genotypeFreq[s] = this.genotypeFreq[s] + 1;
                continue;
            }
            if (inc != null && inc.booleanValue()) {
                ++missingGenotypes;
            }
            this.genotypes[ind] = -1;
        }
        this.alleleFreq = new double[2];
        this.alleleFreq[0] = 2 * this.genotypeFreq[0] + this.genotypeFreq[1];
        this.alleleFreq[1] = 2 * this.genotypeFreq[2] + this.genotypeFreq[1];
        this.MAF = this.alleleFreq[0] / ((double)this.nrCalled * 2.0);
        this.minorAllele = this.alleles[0];
        if (this.alleleFreq[0] > this.alleleFreq[1]) {
            this.minorAllele = this.alleles[1];
            this.MAF = 1.0 - this.MAF;
        }
        this.HWEP = this.getExactHWEPValue(this.genotypeFreq[1], this.genotypeFreq[0], this.genotypeFreq[2]);
        this.passesQC = false;
        this.CR = (double)this.nrCalled / (double)nrTotal;
        if (this.genotypeFreq[0] > 0 && this.genotypeFreq[1] > 0 || this.genotypeFreq[1] > 0 && this.genotypeFreq[2] > 0 || this.genotypeFreq[0] > 0 && this.genotypeFreq[2] > 0) {
            this.passesQC = true;
        }
    }

    public void setPassesQC(boolean b) {
        this.passesQC = b;
    }

    public boolean passesQC() {
        return this.passesQC;
    }

    private double getExactHWEPValue(int obs_hets, int obs_hom1, int obs_hom2) {
        int i;
        int obs_homc = obs_hom1 < obs_hom2 ? obs_hom2 : obs_hom1;
        int obs_homr = obs_hom1 < obs_hom2 ? obs_hom1 : obs_hom2;
        int rare_copies = 2 * obs_homr + obs_hets;
        int genotypes = obs_hets + obs_homc + obs_homr;
        if (genotypes == 0) {
            return -1.0;
        }
        double[] het_probs = new double[rare_copies + 1];
        for (i = 0; i <= rare_copies; ++i) {
            het_probs[i] = 0.0;
        }
        int mid = rare_copies * (2 * genotypes - rare_copies) / (2 * genotypes);
        if (mid % 2 != rare_copies % 2) {
            ++mid;
        }
        int curr_hets = mid;
        int curr_homr = (rare_copies - mid) / 2;
        int curr_homc = genotypes - curr_hets - curr_homr;
        het_probs[mid] = 1.0;
        double sum = het_probs[mid];
        for (curr_hets = mid; curr_hets > 1; curr_hets -= 2) {
            het_probs[curr_hets - 2] = het_probs[curr_hets] * (double)curr_hets * ((double)curr_hets - 1.0) / (4.0 * ((double)curr_homr + 1.0) * ((double)curr_homc + 1.0));
            sum += het_probs[curr_hets - 2];
            ++curr_homr;
            ++curr_homc;
        }
        curr_hets = mid;
        curr_homr = (rare_copies - mid) / 2;
        curr_homc = genotypes - curr_hets - curr_homr;
        for (curr_hets = mid; curr_hets <= rare_copies - 2; curr_hets += 2) {
            het_probs[curr_hets + 2] = het_probs[curr_hets] * 4.0 * (double)curr_homr * (double)curr_homc / (((double)curr_hets + 2.0) * ((double)curr_hets + 1.0));
            sum += het_probs[curr_hets + 2];
            --curr_homr;
            --curr_homc;
        }
        i = 0;
        while (i <= rare_copies) {
            int n = i++;
            het_probs[n] = het_probs[n] / sum;
        }
        double p_hwe = 0.0;
        for (i = 0; i <= rare_copies; ++i) {
            if (!(het_probs[i] <= het_probs[obs_hets])) continue;
            p_hwe += het_probs[i];
        }
        p_hwe = p_hwe > 1.0 ? 1.0 : p_hwe;
        return p_hwe;
    }

    public Double getHWEP() {
        return this.HWEP;
    }

    public void setHWEP(Double HWEP) {
        this.HWEP = HWEP;
    }

    public Double getMAF() {
        return this.MAF;
    }

    public void setMAF(Double MAF) {
        this.MAF = MAF;
    }

    public Double getCR() {
        return this.CR;
    }

    public void setCR(Double CR) {
        this.CR = CR;
    }

    public void setAlleles(byte[] allele1, byte[] allele2) {
        this.alleles1 = allele1;
        this.alleles2 = allele2;
    }

    public void clearGenotypes() {
        this.alleles1 = null;
        this.alleles2 = null;
        this.genotypes = null;
        this.alleleFreq = null;
        this.dosage = null;
    }

    public byte[] getAllele1() {
        return this.alleles1;
    }

    public byte[] getAllele2() {
        return this.alleles2;
    }

    public short[] getGenotypes() {
        return this.genotypes;
    }

    public void setDosage(byte[] dosageValues) {
        this.dosage = dosageValues;
    }

    public double[] getDosageValues() {
        if (this.dosage != null) {
            double[] dosagevalues = new double[this.dosage.length];
            for (int i = 0; i < this.dosage.length; ++i) {
                dosagevalues[i] = (double)(128 + this.dosage[i]) / 100.0;
            }
            return dosagevalues;
        }
        return null;
    }

    public boolean hasDosageInformation() {
        return this.dosage != null;
    }

    public double[] selectGenotypes(int[] ids) {
        return this.selectGenotypes(ids, false);
    }

    public double[] selectGenotypes(int[] ids, boolean includeMissingGenotypes) {
        int i;
        int numReq = ids.length;
        int numAvail = 0;
        for (i = 0; i < numReq; ++i) {
            int id = ids[i];
            if (!includeMissingGenotypes && this.genotypes[ids[i]] == -1 || ids[i] == -1) continue;
            ++numAvail;
        }
        double[] gtypes = new double[numAvail];
        int q = 0;
        for (i = 0; i < numReq; ++i) {
            double dosagevalue;
            int id = ids[i];
            if (id == -1 || !includeMissingGenotypes && this.genotypes[id] == -1) continue;
            gtypes[q] = this.dosage != null ? (dosagevalue = (double)(128 + this.dosage[id]) / 100.0) : (double)this.genotypes[id];
            ++q;
        }
        return gtypes;
    }

    public byte[] getAlleles() {
        return this.alleles;
    }

    public Byte getMinorAllele() {
        return this.minorAllele;
    }

    public double[] getAlleleFreq() {
        return this.alleleFreq;
    }

    public int[] getGenotypeFreq() {
        return this.genotypeFreq;
    }

    public void setGenotypeFreq(int[] genotypeFreq) {
        this.genotypeFreq = genotypeFreq;
    }
}

