/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.model.elements;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.molgenis.MolgenisFieldTypes;
import org.molgenis.fieldtypes.FieldType;
import org.molgenis.fieldtypes.IntField;
import org.molgenis.fieldtypes.MrefField;
import org.molgenis.fieldtypes.XrefField;
import org.molgenis.model.MolgenisModelException;
import org.molgenis.model.elements.DBSchema;
import org.molgenis.model.elements.Field;
import org.molgenis.model.elements.Index;
import org.molgenis.model.elements.Model;
import org.molgenis.model.elements.Module;
import org.molgenis.model.elements.Record;
import org.molgenis.model.elements.Unique;

public class Entity
extends DBSchema
implements Record {
    public static final int PRIMARY_KEY = 0;
    private static final Logger logger = Logger.getLogger((String)Entity.class.getSimpleName());
    private String namespace;
    private String description;
    private String label;
    private boolean system;
    private Vector<Field> fields;
    private Vector<String> parents;
    private Vector<String> implements_parents = new Vector();
    private Vector<Index> indices;
    private Vector<Unique> unique_fields = new Vector();
    private Vector<Field> references = new Vector();
    private boolean abstract_type;
    private boolean association_type;
    private static final long serialVersionUID = 3863969722351309896L;
    private String decorator;
    private List<String> xrefLabels;
    private boolean imported;
    private Module module;
    private Integer allocationSize = null;

    public Entity(String name, DBSchema parent) {
        this(name, name, parent);
    }

    public Entity(String name, String label, DBSchema parent) {
        super(name, parent, parent.getModel());
        this.label = label;
        this.fields = new Vector();
        this.indices = new Vector();
        this.unique_fields = new Vector();
        this.parents = new Vector();
        this.description = "";
        this.system = false;
    }

    public Entity(String name, String label, DBSchema parent, boolean system) {
        super(name, parent, parent.getModel());
        this.label = label;
        this.fields = new Vector();
        this.indices = new Vector();
        this.unique_fields = new Vector();
        this.parents = new Vector();
        this.description = "";
        this.system = system;
    }

    public boolean isImported() {
        return this.imported;
    }

    public void setImported(boolean imported) {
        this.imported = imported;
    }

    @Override
    public String getLabel() {
        if (this.label == null) {
            return this.getName();
        }
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public boolean isSystem() {
        return this.system;
    }

    public boolean isRootAncestor() {
        return this.getParents().size() == 0 && this.getDescendants().size() > 0;
    }

    public boolean isAbstract() {
        return this.abstract_type;
    }

    public void setAbstract(boolean is_abstract) {
        this.abstract_type = is_abstract;
    }

    public boolean isAssociation() {
        return this.association_type;
    }

    public void setAssociation(boolean association_type) {
        this.association_type = association_type;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public boolean hasXRefs() {
        for (Field f : this.fields) {
            if (!(f.getType() instanceof MrefField) && !(f.getType() instanceof XrefField)) continue;
            return true;
        }
        return false;
    }

    public void setParents(Vector<String> parents) {
        this.parents = parents;
    }

    @Override
    public Vector<String> getParents() {
        return this.parents;
    }

    public Entity getRootAncestor() {
        if (this.getAncestor() != null) {
            return this.getAncestor().getRootAncestor();
        }
        return this;
    }

    public boolean isParent(String parent) {
        return this.parents.contains(parent);
    }

    public boolean hasAncestor() {
        return this.parents.size() > 0;
    }

    public boolean isAncestor(String entity) {
        return this.getAllAncestors().contains(this.get(entity));
    }

    public Entity getAncestor() {
        if (this.parents.size() > 0) {
            return (Entity)((DBSchema)this.getRoot()).getChild(this.parents.firstElement());
        }
        return null;
    }

    public Vector<Entity> getAllAncestors() {
        Vector<Entity> ancestors = new Vector<Entity>();
        if (this.getAncestor() != null) {
            ancestors.addAll(this.getAncestor().getAllAncestors());
            ancestors.add(this.getAncestor());
        }
        return ancestors;
    }

    public Vector<Entity> getDescendants() {
        Vector<Entity> descendants = new Vector<Entity>();
        for (DBSchema element : ((DBSchema)this.getRoot()).getAllChildren()) {
            if (!element.getClass().equals(Entity.class) || !((Entity)element).hasAncestor() || !((Entity)element).getAncestor().getName().equals(this.getName())) continue;
            descendants.add((Entity)element);
        }
        return descendants;
    }

    public Vector<Entity> getAllDescendants() {
        Vector<Entity> all_descendants = new Vector<Entity>();
        for (Entity descendant : this.getDescendants()) {
            all_descendants.addAll(descendant.getAllDescendants());
            all_descendants.add(descendant);
        }
        return all_descendants;
    }

    public boolean hasDescendants() {
        return this.getDescendants().size() > 0;
    }

    public boolean hasImplements() {
        return this.implements_parents.size() > 0;
    }

    public Vector<String> getImplementsNames() {
        return this.implements_parents;
    }

    public Vector<Entity> getImplements() throws MolgenisModelException {
        Vector<Entity> implements_entities = new Vector<Entity>();
        for (String iface : this.implements_parents) {
            Entity iface_entity = (Entity)((DBSchema)this.getParent()).get(iface);
            if (iface_entity == null) {
                throw new MolgenisModelException("interface '" + iface + "' is undefined for entity " + this.getName());
            }
            implements_entities.add(iface_entity);
        }
        return implements_entities;
    }

    public Vector<Entity> getAllImplements() throws MolgenisModelException {
        Vector<Entity> implements_entities = new Vector<Entity>();
        for (String iface : this.implements_parents) {
            Entity iface_entity = (Entity)((DBSchema)this.getParent()).get(iface);
            if (iface_entity == null) {
                throw new MolgenisModelException("interface " + iface + " is undefined in entity " + this.getName());
            }
            implements_entities.addAll(iface_entity.getAllImplements());
            implements_entities.add(iface_entity);
        }
        return implements_entities;
    }

    public void setImplements(String ... implements_parents) {
        this.setImplements(new Vector<String>(Arrays.asList(implements_parents)));
    }

    public void setImplements(Vector<String> implements_parents) {
        this.implements_parents = implements_parents;
    }

    public void addReference(Field f) {
        this.references.add(f);
    }

    public Vector<Field> getReferences() {
        return this.references;
    }

    public void addField(Field field) throws MolgenisModelException {
        this.addField(null, field);
    }

    public void addField(Integer pos, Field field) throws MolgenisModelException {
        if (this.fields.contains(field)) {
            throw new MolgenisModelException("Duplicate Field with name " + field.getName() + "  in entity " + this.getName());
        }
        if (pos != null) {
            this.fields.add(pos, field);
        } else {
            this.fields.add(field);
        }
    }

    public void removeField(Field field) {
        this.fields.remove(field);
    }

    @Override
    public List<Field> getFields() throws MolgenisModelException {
        return this.getFields(false, false, true);
    }

    public List<Field> getFields(boolean required, boolean recursive, boolean systemField, boolean implementing) throws MolgenisModelException {
        LinkedHashMap<String, Field> result = new LinkedHashMap<String, Field>();
        for (Field f : this.fields) {
            if (f.isSystem()) {
                if (!systemField) continue;
                result.put(f.getName(), f);
                continue;
            }
            if (f.isNillable()) {
                if (required) continue;
                result.put(f.getName(), f);
                continue;
            }
            result.put(f.getName(), f);
        }
        if (implementing) {
            for (Entity implEntity : this.getImplements()) {
                for (Field f : implEntity.getFields(required, recursive, systemField, implementing)) {
                    if (result.containsKey(f.getName())) continue;
                    result.put(f.getName(), f);
                }
            }
        }
        if (recursive && this.hasAncestor()) {
            for (Field f : this.getAncestor().getFields(required, recursive, systemField, implementing)) {
                if (result.containsKey(f.getName())) continue;
                result.put(f.getName(), f);
            }
        }
        return new ArrayList<Field>(result.values());
    }

    public List<Field> getFields(boolean required, boolean recursive, boolean systemField) throws MolgenisModelException {
        return this.getFields(required, recursive, systemField, true);
    }

    public Vector<Field> getImplementedFields() throws MolgenisModelException {
        LinkedHashMap<String, Field> all_fields = new LinkedHashMap<String, Field>();
        for (Entity entity : this.getAllImplements()) {
            Vector<Field> ifaceFields = new Vector<Field>(entity.getAllFields());
            for (Field ifaceField : ifaceFields) {
                all_fields.put(ifaceField.getName().toLowerCase(), ifaceField);
            }
        }
        for (Field field : this.getFields()) {
            all_fields.put(field.getName().toLowerCase(), field);
        }
        if (!this.isAbstract()) {
            for (Map.Entry entry : all_fields.entrySet()) {
                if (!((Field)entry.getValue()).getEntity().isAbstract()) continue;
                Field value = new Field((Field)entry.getValue());
                value.setEntity(this);
                entry.setValue(value);
            }
        }
        return new Vector<Field>(all_fields.values());
    }

    public boolean hasSuperclassField(String fieldname) throws MolgenisModelException {
        Vector<Field> fields = this.getAncestor().getAllFields();
        for (Field f : fields) {
            if (!f.getName().equals(fieldname)) continue;
            return true;
        }
        return false;
    }

    public Vector<Field> getInheritedFields() throws MolgenisModelException {
        LinkedHashMap<String, Field> all_fields = new LinkedHashMap<String, Field>();
        for (Entity entity : this.getImplements()) {
            Vector<Field> ifaceFields = new Vector<Field>(entity.getAllFields());
            for (Field ifaceField : ifaceFields) {
                all_fields.put(ifaceField.getName().toLowerCase(), ifaceField);
            }
        }
        if (this.getAncestor() != null) {
            for (Field field : this.getAncestor().getAllFields()) {
                all_fields.put(field.getName().toLowerCase(), field);
            }
        }
        if (!this.isAbstract()) {
            for (Map.Entry entry : all_fields.entrySet()) {
                if (!((Field)entry.getValue()).getEntity().isAbstract()) continue;
                Field value = new Field((Field)entry.getValue());
                value.setEntity(this);
                entry.setValue(value);
            }
        }
        return new Vector<Field>(all_fields.values());
    }

    public Vector<Field> getAllFields() throws MolgenisModelException {
        LinkedHashMap<String, Field> all_fields = new LinkedHashMap<String, Field>();
        if (this.getAncestor() != null) {
            for (Field field : this.getAncestor().getAllFields()) {
                all_fields.put(field.getName().toLowerCase(), field);
            }
        }
        for (Entity entity : this.getImplements()) {
            Vector<Field> ifaceFields = entity.getAllFields();
            for (Field ifaceField : ifaceFields) {
                all_fields.put(ifaceField.getName().toLowerCase(), ifaceField);
            }
        }
        for (Field field : this.getFields()) {
            all_fields.put(field.getName().toLowerCase(), field);
        }
        if (!this.isAbstract()) {
            for (Map.Entry entry : all_fields.entrySet()) {
                if (!((Field)entry.getValue()).getEntity().isAbstract()) continue;
                Field value = new Field((Field)entry.getValue());
                value.setEntity(this);
                entry.setValue(value);
            }
        }
        return new Vector<Field>(all_fields.values());
    }

    public Vector<Field> getAllUpdateFields() throws MolgenisModelException {
        Vector<Field> all_fields = this.getAllFields();
        Vector<Field> all_update_fields = new Vector<Field>();
        for (Field f : all_fields) {
            if (f.getType() instanceof MrefField) continue;
            all_update_fields.add(f);
        }
        return all_update_fields;
    }

    public Vector<Field> getLocalFields() throws MolgenisModelException {
        Vector<Field> local_fields = new Vector<Field>();
        for (Field f : this.getFields()) {
            if (f.getType() instanceof MrefField) continue;
            local_fields.add(f);
        }
        return local_fields;
    }

    public Vector<Field> getAllLocalFields() throws MolgenisModelException {
        Vector<Field> local_fields = new Vector<Field>();
        for (Field f : this.getAllFields()) {
            if (f.getType() instanceof MrefField) continue;
            local_fields.add(f);
        }
        return local_fields;
    }

    public Vector<Field> getRemoteFields() throws MolgenisModelException {
        Vector<Field> local_fields = new Vector<Field>();
        for (Field f : this.getFields()) {
            if (!(f.getType() instanceof MrefField)) continue;
            local_fields.add(f);
        }
        return local_fields;
    }

    public List<Field> getSystemFields(boolean all) throws MolgenisModelException {
        ArrayList<Field> system_fields = new ArrayList<Field>();
        List<Field> the_fields = !all ? this.getFields() : this.getAllFields();
        for (Field f : the_fields) {
            if (!f.isSystem()) continue;
            system_fields.add(f);
        }
        return system_fields;
    }

    public List<Field> getNonSystemFields(boolean all) throws MolgenisModelException {
        ArrayList<Field> nonsystem_fields = new ArrayList<Field>();
        List<Field> the_fields = !all ? this.getFields() : this.getAllFields();
        for (Field f : the_fields) {
            if (f.isSystem()) continue;
            nonsystem_fields.add(f);
        }
        return nonsystem_fields;
    }

    public Vector<Field> getAllAddFields() throws MolgenisModelException {
        Vector<Field> local_fields = new Vector<Field>();
        for (Field f : this.getAllFields()) {
            if (f.getType() instanceof XrefField || f.getType() instanceof IntField && f.isAuto() && f.getEntity() == this) continue;
            local_fields.add(f);
        }
        return local_fields;
    }

    public Vector<Field> getAddFields() throws MolgenisModelException {
        Vector<Field> local_fields = new Vector<Field>();
        for (Field f : this.getFields()) {
            if (f.getType() instanceof MrefField || f.getType() instanceof IntField && f.isAuto()) continue;
            local_fields.add(f);
        }
        return local_fields;
    }

    public Vector<Field> getFieldsOf(FieldType type) throws MolgenisModelException {
        Vector<Field> results = new Vector<Field>();
        for (Field field : this.getFields()) {
            if (field.getType().getClass() != type.getClass()) continue;
            results.add(field);
        }
        return results;
    }

    public Vector<Field> getAllFieldsOf(FieldType type) throws MolgenisModelException {
        Vector<Field> results = new Vector<Field>();
        for (Field field : this.getAllFields()) {
            if (!field.getType().getClass().equals(type.getClass())) continue;
            results.add(field);
        }
        return results;
    }

    public Vector<Field> getAllFieldsOf(String typeName) throws MolgenisModelException {
        return this.getAllFieldsOf(MolgenisFieldTypes.getType(typeName));
    }

    public Vector<Field> getImplementedFieldsOf(FieldType type) throws MolgenisModelException {
        Vector<Field> results = new Vector<Field>();
        for (Field field : this.getImplementedFields()) {
            if (!field.getType().getClass().equals(type.getClass())) continue;
            results.add(field);
        }
        return results;
    }

    public Vector<Field> getImplementedFieldsOf(String typeName) throws MolgenisModelException {
        return this.getImplementedFieldsOf(MolgenisFieldTypes.getType(typeName));
    }

    public List<Field> getXRefFields() throws MolgenisModelException {
        Vector<Field> xref_fields = new Vector<Field>();
        for (Field field : this.getImplementedFields()) {
            if (field.isSystem() || !(field.getType() instanceof XrefField) && !(field.getType() instanceof MrefField)) continue;
            xref_fields.add(field);
        }
        return xref_fields;
    }

    public List<Field> getUserFields() throws MolgenisModelException {
        Vector<Field> xref_fields = new Vector<Field>();
        for (Field field : this.getFields()) {
            if (!field.isSystem()) continue;
        }
        return xref_fields;
    }

    public Field getField(String name, boolean required, boolean recursive, boolean systemFields) throws MolgenisModelException {
        for (Field field : this.getFields(required, recursive, systemFields)) {
            if (!name.equals(field.getName())) continue;
            return field;
        }
        return null;
    }

    public Field getFieldRecusive(String name) throws MolgenisModelException {
        return this.getField(name, false, true, true);
    }

    public Field getField(String name) throws MolgenisModelException {
        return this.getField(name, false, false, true);
    }

    public Field getAllField(String name) throws MolgenisModelException {
        for (Field field : this.getAllFields()) {
            if (!name.equalsIgnoreCase(field.getName())) continue;
            return field;
        }
        logger.debug((Object)("couldn't find " + this.getName() + "." + name));
        return null;
    }

    public void addIndex(Index index) {
        this.indices.add(index);
    }

    public Vector<Index> getIndices() throws MolgenisModelException {
        Vector<Index> i = new Vector<Index>();
        i.addAll(this.indices);
        for (Entity iface : this.getImplements()) {
            i.addAll(iface.getIndices());
        }
        return i;
    }

    public Vector<Index> getAllIndices() throws MolgenisModelException {
        Vector<Index> all_indices = new Vector<Index>();
        if (this.parents.size() == 1) {
            Entity parent_entity = (Entity)((DBSchema)this.getParent()).get(this.parents.get(0));
            all_indices = parent_entity.getAllIndices();
        }
        for (Index i : this.getIndices()) {
            if (all_indices.contains(i)) continue;
            all_indices.add(i);
        }
        return all_indices;
    }

    public Index getIndex(String name) throws MolgenisModelException {
        for (Index index : this.getIndices()) {
            if (!index.getName().equals(name)) continue;
            return index;
        }
        return null;
    }

    public void addKey(String key, String description) {
        this.unique_fields.add(new Unique(this, key, false, description));
    }

    public void addKey(List<String> keys, boolean subclass, String description) throws MolgenisModelException {
        this.unique_fields.add(new Unique(this, keys, subclass, description));
    }

    public Vector<Unique> getAllKeys() throws MolgenisModelException {
        Vector<Unique> all_keys = new Vector<Unique>();
        if (this.getAncestor() != null) {
            all_keys.addAll(this.getAncestor().getAllKeys());
        }
        for (Unique u : this.getKeys()) {
            if (all_keys.contains(u)) continue;
            all_keys.add(u);
        }
        return all_keys;
    }

    public Vector<Unique> getKeys() throws MolgenisModelException {
        Vector<Unique> result = new Vector<Unique>();
        if (this.hasAncestor()) {
            Entity parent_entity = (Entity)((DBSchema)this.getParent()).get(this.parents.lastElement());
            if (parent_entity == null) {
                throw new MolgenisModelException("Superclass " + this.parents.lastElement() + " unknown for entity " + this.getName());
            }
            if (parent_entity.getKeys().size() == 0) {
                throw new MolgenisModelException(this.parents.lastElement() + " or the interface it implements doesn't define primary key (unique,int,not null)");
            }
            result.add(parent_entity.getKeys().firstElement());
        }
        if (this.hasImplements()) {
            for (Entity e : this.getImplements()) {
                for (Unique u : e.getKeys()) {
                    Unique copy = new Unique(u);
                    u.setEntity(this);
                    if (result.contains(copy)) continue;
                    result.add(copy);
                }
            }
        }
        for (Unique u : this.unique_fields) {
            if (result.contains(u)) continue;
            result.add(u);
        }
        return result;
    }

    public Unique getKey(int index) throws IndexOutOfBoundsException, MolgenisModelException {
        if (index < 0 || index >= this.unique_fields.size()) {
            throw new IndexOutOfBoundsException("No key was found for entity " + this.getName() + " at the given index " + index + ".");
        }
        return this.getKeys().get(index);
    }

    public Vector<Field> getKeyFields(int index) throws MolgenisModelException {
        Vector<Field> fields = new Vector();
        if (this.getKeys().size() > index) {
            fields = this.getKeys().get(index).getFields();
        } else {
            logger.warn((Object)("[WARNING]: missing key " + index + " for entity " + this.getName()));
        }
        return fields;
    }

    public List<Unique> getUniqueKeysWithoutPk() throws MolgenisModelException {
        ArrayList<Unique> result = new ArrayList<Unique>();
        if (this.hasImplements()) {
            for (Entity e : this.getImplements()) {
                for (Unique u : e.getKeys()) {
                    if (u.getFields().get(0).isAuto()) continue;
                    Unique copy = new Unique(u);
                    u.setEntity(this);
                    if (result.contains(copy)) continue;
                    result.add(copy);
                }
            }
        }
        for (Unique u : this.unique_fields) {
            if (u.getFields().get(0).isAuto()) continue;
            result.add(u);
        }
        return result;
    }

    @Override
    public String toString() {
        StringBuilder strBuilder = new StringBuilder("Entity(");
        strBuilder.append(this.getNamespace()).append('.').append(this.getName()).append(")\n(\n");
        for (Field field : this.fields) {
            strBuilder.append(' ').append(field.toString()).append('\n');
        }
        for (Unique unique : this.unique_fields) {
            strBuilder.append(' ').append(unique.toString()).append('\n');
        }
        for (Index index : this.indices) {
            strBuilder.append(' ').append(index.toString()).append('\n');
        }
        strBuilder.append(");");
        return strBuilder.toString();
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof Entity) {
            return this.getName().equals(((Entity)obj).getName());
        }
        return false;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String getDecorator() {
        return this.decorator;
    }

    public void setDecorator(String decorator) {
        this.decorator = decorator;
    }

    public Module getModule() {
        return this.module;
    }

    public void setModule(Module module) {
        this.module = module;
    }

    public void setSystem(boolean isSystem) {
        this.system = isSystem;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public Field getPrimaryKey() throws MolgenisModelException {
        if (this.hasAncestor()) {
            return this.getAncestor().getPrimaryKey();
        }
        return this.getAllKeys().get(0).getFields().get(0);
    }

    public void setParents(String[] parents) {
        Vector<String> result = new Vector<String>();
        for (String parent : parents) {
            result.add(parent);
        }
        this.setParents(result);
    }

    public int getNumberOfReferencesTo(Entity e) throws MolgenisModelException {
        int count = 0;
        for (Field field : this.getXRefFields()) {
            String xrefEntity = field.getXrefEntityName();
            if (xrefEntity == null || !xrefEntity.equals(e.getName())) continue;
            ++count;
        }
        return count;
    }

    public int getNumberOfReferencesTo(Entity e, Field f) throws MolgenisModelException {
        int count = 0;
        for (Field field : this.getXRefFields()) {
            String xrefEntity = field.getXrefEntityName();
            if (xrefEntity == null || !xrefEntity.equals(e.getName()) || !field.getName().equals(f.getName())) continue;
            ++count;
        }
        return count;
    }

    public int getNumberOfMrefTo(Entity e) throws MolgenisModelException {
        int count = 0;
        for (Field field : this.getFields()) {
            String xrefEntity;
            if (!field.isMRef() || (xrefEntity = field.getXrefEntityName()) == null || !xrefEntity.equals(e.getName())) continue;
            ++count;
        }
        return count;
    }

    public int getNumberOfMrefTo(Entity e, Field f) throws MolgenisModelException {
        int count = 0;
        for (Field field : this.getFields()) {
            String xrefEntity;
            if (!field.isMRef() || (xrefEntity = field.getXrefEntityName()) == null || !xrefEntity.equals(e.getName()) || !field.getName().equals(f.getName())) continue;
            ++count;
        }
        return count;
    }

    public List<String> getXrefLabels() throws MolgenisModelException {
        if (this.xrefLabels == null) {
            if (this.hasAncestor() && this.getAncestor().getXrefLabels() != null) {
                return this.getAncestor().getXrefLabels();
            }
            ArrayList<Entity> ifaces = new ArrayList<Entity>(this.getImplements());
            Collections.reverse(ifaces);
            for (Entity iface : ifaces) {
                if (iface.getXrefLabels() == null) continue;
                return iface.getXrefLabels();
            }
            ArrayList<String> result = new ArrayList<String>();
            if (this.getKeys().size() > 0) {
                Vector<Field> keyFields = null;
                keyFields = this.getKeys().size() > 1 ? this.getKeyFields(1) : this.getKeyFields(0);
                for (Field f : keyFields) {
                    result.add(f.getName());
                }
                return result;
            }
        }
        return this.xrefLabels;
    }

    public void setXrefLabels(List<String> xrefLabels) {
        this.xrefLabels = xrefLabels;
    }

    @Override
    public Model getModel() {
        return ((DBSchema)this.getRoot()).getModel();
    }

    public List<Entity> getDependencies() throws MolgenisModelException {
        ArrayList<Entity> result = new ArrayList<Entity>();
        for (Field f : this.getAllFields()) {
            if (!(f.getType() instanceof XrefField) || f.getXrefEntityName().equals(this.getName())) continue;
            result.add(f.getXrefEntity());
        }
        return result;
    }

    public void setAllocationSize(Integer allocationSize) {
        this.allocationSize = allocationSize;
    }

    public Integer getAllocationSize() {
        return this.allocationSize;
    }
}

