/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.io.processor;

import java.util.List;
import org.molgenis.io.processor.CellProcessor;

public abstract class AbstractCellProcessor
implements CellProcessor {
    private static final long serialVersionUID = 1L;
    private final boolean processHeader;
    private final boolean processData;

    public AbstractCellProcessor() {
        this(true, true);
    }

    public AbstractCellProcessor(boolean processHeader, boolean processData) {
        this.processHeader = processHeader;
        this.processData = processData;
    }

    @Override
    public boolean processHeader() {
        return this.processHeader;
    }

    @Override
    public boolean processData() {
        return this.processData;
    }

    public static String processCell(String value, boolean isHeader, List<CellProcessor> cellProcessors) {
        if (cellProcessors != null) {
            for (CellProcessor cellProcessor : cellProcessors) {
                boolean process = isHeader && cellProcessor.processHeader() || !isHeader && cellProcessor.processData();
                if (!process) continue;
                value = cellProcessor.process(value);
            }
        }
        return value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.processData ? 1231 : 1237);
        result = 31 * result + (this.processHeader ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractCellProcessor other = (AbstractCellProcessor)obj;
        if (this.processData != other.processData) {
            return false;
        }
        return this.processHeader == other.processHeader;
    }
}

