/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.io.excel;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.molgenis.io.TupleWriter;
import org.molgenis.io.processor.AbstractCellProcessor;
import org.molgenis.io.processor.CellProcessor;
import org.molgenis.util.ListEscapeUtils;
import org.molgenis.util.tuple.Tuple;

public class ExcelSheetWriter
implements TupleWriter {
    private final Sheet sheet;
    private int row;
    private List<CellProcessor> cellProcessors;
    private List<String> cachedColNames;

    ExcelSheetWriter(Sheet sheet, List<CellProcessor> cellProcessors) {
        if (sheet == null) {
            throw new IllegalArgumentException("sheet is null");
        }
        this.sheet = sheet;
        this.cellProcessors = cellProcessors;
        this.row = 0;
    }

    @Override
    public void writeColNames(Iterable<String> colNames) throws IOException {
        if (this.cachedColNames == null) {
            Row poiRow = this.sheet.createRow(this.row++);
            int i = 0;
            ArrayList<String> processedColNames = new ArrayList<String>();
            for (String colName : colNames) {
                Cell cell = poiRow.createCell(i++, 1);
                cell.setCellValue(AbstractCellProcessor.processCell(colName, true, this.cellProcessors));
                processedColNames.add(colName);
            }
            this.cachedColNames = processedColNames;
        }
    }

    @Override
    public void write(Tuple tuple) throws IOException {
        Row poiRow = this.sheet.createRow(this.row++);
        if (this.cachedColNames != null) {
            if (!tuple.hasColNames()) {
                throw new IllegalArgumentException("tuple has no column names");
            }
            int i = 0;
            for (String colName : this.cachedColNames) {
                Cell cell = poiRow.createCell(i++, 1);
                cell.setCellValue(this.toValue(tuple.get(colName)));
            }
        } else {
            int cols = tuple.getNrCols();
            for (int i = 0; i < cols; ++i) {
                Cell cell = poiRow.createCell(i, 1);
                cell.setCellValue(this.toValue(tuple.get(i)));
            }
        }
    }

    @Override
    public void addCellProcessor(CellProcessor cellProcessor) {
        if (this.cellProcessors == null) {
            this.cellProcessors = new ArrayList<CellProcessor>();
        }
        this.cellProcessors.add(cellProcessor);
    }

    @Override
    public void close() throws IOException {
    }

    private String toValue(Object obj) {
        String value = obj == null ? null : (obj instanceof List ? ListEscapeUtils.toString((List)obj) : obj.toString());
        return AbstractCellProcessor.processCell(value, false, this.cellProcessors);
    }
}

