/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.generators.ui;

import freemarker.template.Template;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Map;
import org.apache.log4j.Logger;
import org.molgenis.MolgenisOptions;
import org.molgenis.generators.Generator;
import org.molgenis.generators.GeneratorHelper;
import org.molgenis.model.elements.Menu;
import org.molgenis.model.elements.Model;
import org.molgenis.model.elements.UISchema;

public class MenuControllerGen
extends Generator {
    private static final Logger logger = Logger.getLogger(MenuControllerGen.class);

    @Override
    public String getDescription() {
        return "Generates menu screens.";
    }

    @Override
    public void generate(Model model, MolgenisOptions options) throws Exception {
        this.generateForm(model, options, model.getUserinterface());
    }

    private void generateForm(Model model, MolgenisOptions options, UISchema schema) throws Exception {
        if (!options.generate_tests) {
            Template template = this.createTemplate("/" + this.getClass().getSimpleName() + ".java.ftl");
            Map<String, Object> templateArgs = this.createTemplateArguments(options);
            for (UISchema screen : schema.getChildren()) {
                if (screen.getClass() == Menu.class) {
                    templateArgs.put("menu", screen);
                    templateArgs.put("model", model);
                    templateArgs.put("package", "org/molgenis".replace('/', '.') + ".ui");
                    File targetDir = new File(this.getSourcePath(options) + "org/molgenis" + "/ui/");
                    boolean created = targetDir.mkdirs();
                    if (!created && !targetDir.exists()) {
                        throw new IOException("could not create " + targetDir);
                    }
                    File targetFile = new File(targetDir + "/" + GeneratorHelper.firstToUpper(screen.getClassName()) + "Menu.java");
                    FileOutputStream targetOut = new FileOutputStream(targetFile);
                    template.process(templateArgs, (Writer)new OutputStreamWriter((OutputStream)targetOut, Charset.forName("UTF-8")));
                    ((OutputStream)targetOut).close();
                    logger.info((Object)("generated " + targetFile));
                }
                this.generateForm(model, options, screen);
            }
        }
    }
}

