/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.generators.server;

import freemarker.template.Template;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.molgenis.MolgenisOptions;
import org.molgenis.generators.Generator;
import org.molgenis.generators.GeneratorHelper;
import org.molgenis.model.elements.Entity;
import org.molgenis.model.elements.Method;
import org.molgenis.model.elements.Model;

public class RdfApiGen
extends Generator {
    private static final Logger logger = Logger.getLogger(RdfApiGen.class);

    @Override
    public String getDescription() {
        return "Generates soap service interfaces for each entity.";
    }

    @Override
    public void generate(Model model, MolgenisOptions options) throws Exception {
        if (!options.generate_tests) {
            Template template = this.createTemplate("/" + this.getClass().getSimpleName() + ".n3.ftl");
            Map<String, Object> templateArgs = this.createTemplateArguments(options);
            Vector<Entity> entityList = model.getEntities();
            Vector<Method> methodList = model.getMethods();
            File target = new File(this.getWebserverPath(options) + "/WEB-INF/molgenis-rdf-mapping.n3");
            boolean created = target.getParentFile().mkdirs();
            if (!created && !target.getParentFile().exists()) {
                throw new IOException("could not create " + target.getParentFile());
            }
            templateArgs.put("model", model);
            templateArgs.put("methods", methodList);
            templateArgs.put("entities", entityList);
            templateArgs.put("helper", new GeneratorHelper(null));
            templateArgs.put("package", "org/molgenis".replace('/', '.') + ".servlet");
            templateArgs.put("db_filepath", options.db_filepath);
            templateArgs.put("db_user", options.db_user);
            templateArgs.put("db_password", options.db_password);
            templateArgs.put("db_uri", options.db_uri);
            templateArgs.put("db_driver", options.db_driver);
            templateArgs.put("db_jndiname", options.db_jndiname);
            FileOutputStream targetOut = new FileOutputStream(target);
            template.process(templateArgs, (Writer)new OutputStreamWriter((OutputStream)targetOut, Charset.forName("UTF-8")));
            ((OutputStream)targetOut).close();
            logger.info((Object)("generated " + target));
        }
    }
}

