/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.framework.ui.html;

import java.lang.reflect.Array;
import org.apache.log4j.Logger;
import org.molgenis.framework.ui.html.CustomHtml;
import org.molgenis.framework.ui.html.HtmlElement;
import org.molgenis.framework.ui.html.TableCell;

public class TableBlock {
    Logger logger = Logger.getLogger(TableBlock.class);
    int rowSize = 0;
    int colSize = 0;
    TableCell[][] values = new TableCell[0][];

    public TableCell get(int row, int col) {
        if (row < this.values.length && col < this.values[row].length) {
            return this.values[row][col];
        }
        return null;
    }

    public void set(TableCell value) {
        int j;
        int i;
        int col = value.getCol();
        int row = value.getRow();
        if (row + value.getRowspan() >= this.rowSize || col + value.getColspan() >= this.colSize) {
            this.resize(Math.max(row + value.getRowspan(), this.rowSize), Math.max(col + value.getColspan(), this.colSize));
        }
        for (i = row; i < row + value.getRowspan(); ++i) {
            for (j = col; j < col + value.getColspan(); ++j) {
                TableCell oldValue = this.get(row, col);
                if (oldValue == null) continue;
                this.logger.warn((Object)("removing table cell because overwriting: row = " + oldValue.getCol() + ", col=" + oldValue.getRow()));
                this.remove(oldValue);
            }
        }
        for (i = row; i < row + value.getRowspan(); ++i) {
            for (j = col; j < col + value.getColspan(); ++j) {
                this.values[i][j] = value;
            }
        }
    }

    public void remove(TableCell cell) {
        TableCell oldValue = this.values[cell.getRow()][cell.getCol()];
        if (oldValue != null) {
            for (int rowIndex = oldValue.getRow(); rowIndex < oldValue.getRow() + oldValue.getRowspan(); ++rowIndex) {
                for (int colIndex = oldValue.getCol(); colIndex < oldValue.getCol() + oldValue.getColspan(); ++colIndex) {
                    this.values[rowIndex][colIndex] = new TableCell(rowIndex, colIndex, new CustomHtml(""));
                }
            }
        }
    }

    public String renderRows() {
        StringBuilder strBuilder = new StringBuilder();
        for (int row = 0; row < this.values.length; ++row) {
            boolean tr = false;
            if (this.values[row] != null) {
                for (int col = 0; col < this.values[row].length; ++col) {
                    TableCell td = this.get(row, col);
                    if (td == null || row != td.getRow() || col != td.getCol()) continue;
                    if (!tr) {
                        strBuilder.append("\t\n<tr>");
                        tr = true;
                    }
                    String colspan = td.getColspan() > 1 ? " colspan=" + td.getColspan() : "";
                    String rowspan = td.getRowspan() > 1 ? " rowspan=" + td.getRowspan() : "";
                    String value = td.getValue() != null ? td.getValue().render() : "";
                    strBuilder.append("<td").append(colspan).append(rowspan).append('>');
                    strBuilder.append(value).append("</td>");
                }
            }
            if (!tr) continue;
            strBuilder.append("</tr>");
        }
        return strBuilder.toString();
    }

    private void resize(int rows, int cols) {
        this.values = (TableCell[][])this.resizeArray(this.values, rows);
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = this.values[i] == null ? new TableCell[cols] : (TableCell[])this.resizeArray(this.values[i], cols);
            for (int j = 0; j < this.values[i].length; ++j) {
                if (this.values[i][j] != null) continue;
                this.values[i][j] = new TableCell(i, j, new CustomHtml(""), 1, 1);
            }
        }
        this.rowSize = rows;
        this.colSize = cols;
    }

    private Object resizeArray(Object oldArray, int newSize) {
        int oldSize = Array.getLength(oldArray);
        Class<?> elementType = oldArray.getClass().getComponentType();
        Object newArray = Array.newInstance(elementType, newSize);
        int preserveLength = Math.min(oldSize, newSize);
        if (preserveLength > 0) {
            System.arraycopy(oldArray, 0, newArray, 0, preserveLength);
        }
        return newArray;
    }

    public void set(int row, int col, HtmlElement value, int rowspan, int colspan) {
        this.set(new TableCell(row, col, value, rowspan, colspan));
    }
}

