/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.framework.ui.html;

import java.util.Map;
import org.molgenis.framework.ui.html.HtmlElement;
import org.molgenis.framework.ui.html.HyperlinkInput;
import org.molgenis.framework.ui.html.MultipanelLayout;

public class TabbedLayout
extends MultipanelLayout {
    public TabbedLayout(String id) {
        super(id);
    }

    public void addHyperlink(String name, String hyperlink) {
        super.add(new HyperlinkInput(name, hyperlink));
    }

    @Override
    public String render() {
        Map<String, HtmlElement> elements = this.getElements();
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("<div id=\"").append(this.getId()).append("\">");
        strBuilder.append("<ul>");
        int i = 0;
        for (Map.Entry<String, HtmlElement> entry : elements.entrySet()) {
            HtmlElement htmlElement = entry.getValue();
            if (htmlElement instanceof HyperlinkInput) {
                strBuilder.append("<li><a href=\"").append(((HyperlinkInput)htmlElement).getValue());
                strBuilder.append("\">").append("</a></li>");
                continue;
            }
            strBuilder.append("<li><a href=\"#").append(this.getId()).append('-').append(i++).append("\">");
            strBuilder.append(entry.getKey()).append("</a></li>");
        }
        strBuilder.append("</ul>");
        i = 0;
        for (String label : elements.keySet()) {
            strBuilder.append("<div id=\"").append(this.getId()).append('-').append(i++).append("\">");
            strBuilder.append(elements.get(label).render()).append("</div>");
        }
        strBuilder.append("</div>");
        strBuilder.append("</div><script>$(\"#").append(this.getId()).append("\").tabs();</script>");
        return strBuilder.toString();
    }

    public static enum Position {
        TOPLEFT,
        TOPRIGHT,
        LEFTTOP;

    }
}

