/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.framework.ui.html;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.molgenis.framework.ui.html.HtmlElement;
import org.molgenis.framework.ui.html.HtmlInputException;
import org.molgenis.framework.ui.html.OptionInput;
import org.molgenis.framework.ui.html.StringInput;
import org.molgenis.util.Entity;
import org.molgenis.util.ValueLabel;
import org.molgenis.util.tuple.Tuple;

public class SelectMultipleInput
extends OptionInput<List<String>> {
    public static final String VALUES = "values";
    private boolean useJqueryMultiplePlugin = false;

    public SelectMultipleInput(String name) {
        super(name, null);
    }

    public SelectMultipleInput(String name, List<String> objects) {
        super(name, objects);
    }

    public SelectMultipleInput(String name, String label, List<String> values, Boolean nillable, Boolean readonly, String description, List<String> options, List<String> option_labels) throws HtmlInputException {
        super(name, label, values, nillable, readonly, description, options, option_labels);
    }

    public SelectMultipleInput(Tuple t) throws HtmlInputException {
        super(t);
        this.setValue(t.getList(VALUES));
    }

    @Override
    public String toHtml() {
        String readonly;
        String string = readonly = this.isReadonly() ? "readonly " : "";
        if (this.isHidden()) {
            StringInput input = new StringInput(this.getName(), this.getValue());
            input.setLabel(this.getLabel());
            input.setDescription(this.getDescription());
            input.setHidden(true);
            return input.toHtml();
        }
        StringBuffer optionsHtml = new StringBuffer();
        ArrayList values = (ArrayList)super.getObject();
        if (values == null) {
            values = new ArrayList();
        }
        ArrayList<String> stringValues = new ArrayList<String>();
        for (Object v : values) {
            stringValues.add(v.toString());
        }
        if (!this.isReadonly() || super.getValue().toString().equals("")) {
            optionsHtml.append("\t<option value=\"\"></option>\n");
        }
        for (ValueLabel choice : this.getOptions()) {
            if (stringValues.contains(choice.getValue().toString())) {
                optionsHtml.append("\t<option selected value=\"" + choice.getValue() + "\">" + choice.getLabel() + "</option>\n");
                continue;
            }
            if (this.isReadonly()) continue;
            optionsHtml.append("\t<option value=\"" + choice.getValue() + "\">" + choice.getLabel() + "</option>\n");
        }
        if (this.uiToolkit == HtmlElement.UiToolkit.ORIGINAL) {
            return "<select id=\"" + this.getId() + "\" multiple name=\"" + this.getName() + "\" " + readonly + " style=\"" + this.getStyle() + "\">\n" + optionsHtml.toString() + "</select>\n";
        }
        if (this.uiToolkit == HtmlElement.UiToolkit.JQUERY) {
            if (this.useJqueryMultiplePlugin) {
                return "<select multiple=\"multiple\" class=\"multiselect\"\" id=\"" + this.getId() + "\" name=\"" + this.getName() + "\" " + readonly + ">\n" + optionsHtml.toString() + "</select><script>$(\"#" + this.getId() + "\").multiselect();</script>\n";
            }
            return "<select multiple=\"multiple\" class=\"ui-widget-content ui-corner-all\" id=\"" + this.getId() + "\" name=\"" + this.getName() + "\" " + readonly + " style=\"width:350px;\"" + ">\n" + optionsHtml.toString() + "</select><script>$(\"#" + this.getId() + "\").chosen();</script>\n";
        }
        return (Object)((Object)this.uiToolkit) + " NOT IMPLEMENTED";
    }

    @Override
    public String getValue() {
        StringBuffer result = new StringBuffer();
        ArrayList values = (ArrayList)super.getObject();
        if (values == null) {
            values = new ArrayList();
        }
        ArrayList<String> stringValues = new ArrayList<String>();
        for (Object v : values) {
            stringValues.add(v.toString());
        }
        for (ValueLabel choice : this.getOptions()) {
            if (!stringValues.contains(choice.getValue().toString())) continue;
            result.append(choice.getLabel() + ", ");
        }
        String optionstring = result.toString();
        if (result != null && result.length() > 0 && optionstring.lastIndexOf(",") >= 0) {
            return optionstring.substring(0, optionstring.lastIndexOf(","));
        }
        return optionstring;
    }

    public void setOptions(List<Object> entities, String valueField, String labelField) {
        this.getOptions().clear();
        for (Object e : entities) {
            this.addOption(((Entity)e).get(valueField), ((Entity)e).get(labelField));
        }
    }

    public void addOption(Object value, Object label) {
        this.getOptions().add(new ValueLabel(value.toString(), label.toString()));
    }

    @Override
    public void setOptions(String ... choices) {
        ArrayList<ValueLabel> choicePairs = new ArrayList<ValueLabel>();
        for (String choice : choices) {
            choicePairs.add(new ValueLabel(choice, choice));
        }
        this.setOptions(choicePairs);
    }

    @Override
    public String toHtml(Tuple params) throws ParseException, HtmlInputException {
        return new SelectMultipleInput(params).render();
    }

    public boolean isUseJqueryMultiplePlugin() {
        return this.useJqueryMultiplePlugin;
    }

    public void setUseJqueryMultiplePlugin(boolean useJqueryMultiplePlugin) {
        this.useJqueryMultiplePlugin = useJqueryMultiplePlugin;
    }
}

