/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.framework.ui.html;

import java.text.ParseException;
import org.molgenis.framework.ui.html.HtmlInput;
import org.molgenis.framework.ui.html.StringInput;
import org.molgenis.util.tuple.Tuple;

public class HyperlinkInput
extends HtmlInput<String> {
    public HyperlinkInput(String name) {
        this(name, null);
    }

    public HyperlinkInput(String name, String value) {
        super(name, value);
    }

    public HyperlinkInput(String name, String label, String value, boolean nillable, boolean readonly) {
        super(name, value);
        this.setLabel(label);
        this.setNillable(nillable);
        this.setReadonly(readonly);
    }

    public HyperlinkInput(Tuple properties) {
        this(properties.getString("name"), properties.getString("label"), properties.getString("value"), properties.getBoolean("nillable"), properties.getBoolean("readonly"));
    }

    @Override
    public String getValue() {
        return "<a href=\"" + super.getValue() + "\">" + super.getValue() + "</a>";
    }

    @Override
    public String getHtmlValue() {
        return this.getValue();
    }

    @Override
    public String toHtml() {
        StringInput input = new StringInput(this.getName(), super.getValue());
        input.setLabel(this.getLabel());
        input.setDescription(this.getDescription());
        input.setHidden(this.isHidden());
        input.setReadonly(this.isReadonly());
        return input.toHtml() + this.getValue();
    }

    @Override
    public String toHtml(Tuple params) throws ParseException {
        return new HyperlinkInput(params).render();
    }
}

