/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.framework.ui.html;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.molgenis.framework.ui.html.ActionInput;
import org.molgenis.framework.ui.html.HtmlInput;
import org.molgenis.framework.ui.html.HtmlWidget;

public class HtmlForm
extends HtmlWidget {
    private List<String> hiddenColumns = new ArrayList<String>();
    private List<String> compactView = new ArrayList<String>();
    private boolean readonly = false;
    private boolean newRecord = false;
    private List<HtmlInput<?>> inputs = new ArrayList();
    private List<ActionInput> actions = new ArrayList<ActionInput>();

    public HtmlForm() {
        super(UUID.randomUUID().toString());
    }

    public boolean isNewRecord() {
        return this.newRecord;
    }

    public void setNewRecord(boolean newRecord) {
        this.newRecord = newRecord;
    }

    public List<String> getHiddenColumns() {
        return this.hiddenColumns;
    }

    public void setHiddenColumns(List<String> hiddenColumns) {
        if (hiddenColumns != null) {
            this.hiddenColumns = hiddenColumns;
        }
    }

    public List<HtmlInput<?>> getInputs() {
        return this.inputs;
    }

    public void setInputs(List<HtmlInput<?>> inputs) {
        this.inputs = inputs;
    }

    @Override
    public boolean isReadonly() {
        return this.readonly;
    }

    @Override
    public HtmlInput<String> setReadonly(boolean readonly) {
        this.readonly = readonly;
        return this;
    }

    public void addInput(HtmlInput<?> ... inputs) {
        for (HtmlInput<?> input : inputs) {
            this.inputs.add(input);
        }
    }

    public List<ActionInput> getActions() {
        return this.actions;
    }

    public void setActions(List<ActionInput> actions) {
        this.actions = actions;
    }

    public void addAction(ActionInput ... actions) {
        for (ActionInput action : actions) {
            this.getActions().add(action);
        }
    }

    public List<String> getCompactView() {
        return this.compactView;
    }

    public void setCompactView(List<String> compactView) {
        this.compactView = compactView;
    }

    @Override
    public String toHtml() {
        StringBuilder htmlBuilder = new StringBuilder("<table>");
        for (HtmlInput<?> i : this.getInputs()) {
            htmlBuilder.append("<tr><td name=\"").append(i.getLabel()).append("\">");
            htmlBuilder.append(i.getLabel()).append("</td><td>").append(i.getHtml()).append("</td></tr>");
        }
        htmlBuilder.append("</table>");
        return htmlBuilder.toString();
    }
}

