/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.framework.ui.html;

import org.molgenis.framework.ui.html.HtmlElement;
import org.molgenis.framework.ui.html.HtmlInput;
import org.molgenis.framework.ui.html.HtmlInputException;
import org.molgenis.framework.ui.html.StringInput;
import org.molgenis.util.tuple.Tuple;

public class FileInput
extends HtmlInput<Object> {
    public static final String INPUT_CURRENT_DOWNLOAD = "__filename";
    public static final String ACTION_DOWNLOAD = "download";
    private String entityname;

    public FileInput(String name, Object value) {
        super(name, value);
    }

    public FileInput(String name) {
        this(name, (Object)null);
    }

    public FileInput(String name, String label, String value, boolean nillable, boolean readonly) {
        this(name, value);
        this.setLabel(label);
        this.setNillable(nillable);
        this.setReadonly(readonly);
    }

    public FileInput(Tuple t) throws HtmlInputException {
        this.set(t);
    }

    protected FileInput() {
    }

    @Override
    public String toHtml() {
        this.setNillable(true);
        String readonly = this.isReadonly() ? "readonly class=\"readonly\" readonly " : "";
        StringInput hidden = new StringInput(this.getName(), super.getValue());
        hidden.setLabel(this.getLabel());
        hidden.setDescription(this.getDescription());
        hidden.setHidden(true);
        if (this.isHidden()) {
            return hidden.toHtml();
        }
        if (this.uiToolkit == HtmlElement.UiToolkit.ORIGINAL) {
            return hidden.toHtml() + (!this.isReadonly() ? "<input type=\"file\" " + readonly + "name=\"filefor_" + this.getName() + "\" size=\"20\">" : "") + this.getValue();
        }
        if (this.uiToolkit == HtmlElement.UiToolkit.JQUERY) {
            return hidden.toHtml() + (!this.isReadonly() ? "<input class=\"ui-widget-content ui-corner-all\" type=\"file\" " + readonly + "name=\"filefor_" + this.getName() + "\" size=\"20\">" : "") + this.getValue();
        }
        return "ERROR";
    }

    @Override
    public String getValue() {
        if (!super.getValue().isEmpty()) {
            return super.getValue() + "<input class=\"manbutton\" type=\"image\" src=\"img/download.png\" alt=\"download\" onclick=\"this.form.__filename.value = '" + super.getValue() + "';this.form.__action.value='" + ACTION_DOWNLOAD + "'; return true;\"/>";
        }
        return super.getValue();
    }

    public String getEntityname() {
        return this.entityname;
    }

    public void setEntityname(String entityname) {
        this.entityname = entityname;
    }

    @Override
    public String toHtml(Tuple params) throws HtmlInputException {
        return new FileInput(params).render();
    }
}

