/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.framework.ui.html;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;
import org.molgenis.framework.ui.html.HtmlInput;
import org.molgenis.framework.ui.html.HtmlInputException;
import org.molgenis.framework.ui.html.HtmlWidget;
import org.molgenis.framework.ui.html.RepeatingPanel;
import org.molgenis.framework.ui.html.SelectMultipleInput;
import org.molgenis.util.tuple.Tuple;

public class DivPanel
extends HtmlWidget {
    LinkedHashMap<String, HtmlInput<?>> inputs = new LinkedHashMap();
    boolean makeNewDiv = true;

    public DivPanel() {
        this(UUID.randomUUID().toString(), null);
    }

    public DivPanel(String name, String label) {
        super(name, label);
        this.setLabel(label);
    }

    public DivPanel(String name, String label, boolean makeNewDiv) {
        super(name, label);
        this.setLabel(label);
        this.makeNewDiv = makeNewDiv;
    }

    public void add(HtmlInput<?> ... inputs) {
        for (HtmlInput<?> input : inputs) {
            this.inputs.put(input.getName(), input);
        }
    }

    public void remove(HtmlInput<?> ... inputs) {
        for (HtmlInput<?> input : inputs) {
            this.inputs.remove(input.getName());
        }
    }

    public HtmlInput<?> get(String name) {
        return this.inputs.get(name);
    }

    @Override
    public String toHtml() {
        StringBuilder strBuilder = new StringBuilder("<div>");
        for (HtmlInput<?> i : this.inputs.values()) {
            if (this.makeNewDiv) {
                strBuilder.append("<div style=\"clear:both;");
                if (i.isHidden()) {
                    strBuilder.append("display:none\"");
                } else {
                    strBuilder.append("display:block\"");
                }
                if (i.getId() != null) {
                    strBuilder.append(" id=\"div").append(i.getId()).append("\">");
                }
            }
            strBuilder.append("<label style=\"width:16em;float:left;\" for=\"").append(i.getName()).append("\">");
            strBuilder.append(i.getLabel()).append("</label>").append(i.toHtml());
            if (!i.isNillable()) {
                strBuilder.append(" *");
            }
            if (!this.makeNewDiv) continue;
            strBuilder.append("</div>");
        }
        strBuilder.append("</div>");
        return strBuilder.toString();
    }

    public void setValuesFromRequest(Tuple request) {
        ArrayList inputList = new ArrayList();
        this.fillList(inputList, this);
        for (HtmlInput htmlInput : inputList) {
            Object object = request.get(htmlInput.getName());
            if (htmlInput instanceof SelectMultipleInput && object instanceof String) {
                ArrayList<String> stringList = new ArrayList<String>();
                stringList.add((String)object);
                htmlInput.setValue(stringList);
                continue;
            }
            if (object == null) continue;
            htmlInput.setValue(object);
        }
    }

    private void fillList(List<HtmlInput<?>> inputList, DivPanel startInput) {
        for (HtmlInput<?> input : startInput.inputs.values()) {
            if (input instanceof DivPanel || input instanceof RepeatingPanel) {
                this.fillList(inputList, (DivPanel)input);
                continue;
            }
            inputList.add(input);
        }
    }

    @Override
    public String toHtml(Tuple params) throws ParseException, HtmlInputException {
        throw new UnsupportedOperationException();
    }
}

