/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.framework.ui.html;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.framework.server.QueryRuleUtil;
import org.molgenis.framework.server.services.MolgenisGuiService;
import org.molgenis.framework.ui.html.ActionInput;
import org.molgenis.framework.ui.html.HtmlElement;
import org.molgenis.framework.ui.html.HtmlInput;
import org.molgenis.framework.ui.html.HtmlInputException;
import org.molgenis.util.Entity;
import org.molgenis.util.tuple.Tuple;

public abstract class AbstractRefInput<E>
extends HtmlInput<E> {
    private static String DEFAULT_URL = "xref/find";
    public static final String XREF_FIELD = "xrefField";
    public static final String XREF_ENTITY = "xrefEntity";
    public static final String XREF_LABELS = "xrefLabels";
    public static final String FILTERS = "filters";
    public static final String SEARCH_TERM = "searchTerm";
    public static final String ERRROR = "error";
    public static final String INCLUDE_ADD_BUTTON = "includeAddButton";
    protected final Class<? extends Entity> xrefEntity;
    protected List<String> xrefLabels = new ArrayList<String>();
    protected String xrefField;
    protected String url = DEFAULT_URL;
    protected boolean prefill = true;
    private String placeholder = "";
    protected List<QueryRule> filters = new ArrayList<QueryRule>();
    protected String error = null;
    protected boolean includeAddButton = false;

    protected abstract String renderOptions();

    protected abstract String getHtmlRefType();

    protected AbstractRefInput(String name, Class<? extends Entity> xrefClass, String label, E value, boolean nillable, boolean readonly, String description) {
        super(name, label, value, nillable, readonly, description);
        this.xrefEntity = xrefClass;
    }

    protected AbstractRefInput(String name, Class<? extends Entity> xrefClass, E value) {
        super(name, value);
        this.xrefEntity = xrefClass;
    }

    protected AbstractRefInput() {
        this.xrefEntity = null;
    }

    public AbstractRefInput(Tuple t) throws HtmlInputException {
        super(t);
        Class<?> klass = null;
        try {
            klass = Class.forName(t.getString(XREF_ENTITY));
        }
        catch (Exception e) {
            throw new HtmlInputException(e);
        }
        this.xrefEntity = klass;
        this.xrefField = t.getString(XREF_FIELD);
        this.xrefLabels = t.getList(XREF_LABELS);
        if (!t.isNull(FILTERS)) {
            this.filters = (List)t.get(FILTERS);
        }
        if (!t.isNull(ERRROR)) {
            this.error = t.getString(ERRROR);
        }
        if (!t.isNull(INCLUDE_ADD_BUTTON)) {
            this.includeAddButton = t.getBoolean(INCLUDE_ADD_BUTTON);
        }
    }

    protected void setXrefEntity(Class<? extends Entity> xrefEntity) {
        try {
            Entity instance = xrefEntity.newInstance();
            this.xrefField = instance.getIdField();
            this.xrefLabels = instance.getLabelFields();
            this.placeholder = "Choose " + instance.getClass().getSimpleName();
        }
        catch (Exception e) {
            this.error = e.getMessage();
            e.printStackTrace();
        }
    }

    public void setXrefEntity(String xrefClassname) throws HtmlInputException {
        try {
            this.setXrefEntity(Class.forName(xrefClassname));
        }
        catch (ClassNotFoundException e) {
            throw new HtmlInputException(xrefClassname);
        }
    }

    public String getXrefField() {
        return this.xrefField;
    }

    public void setXrefField(String xrefField) {
        this.xrefField = xrefField;
    }

    public Class<? extends Entity> getXrefEntity() {
        return this.xrefEntity;
    }

    public List<String> getXrefLabels() {
        return this.xrefLabels;
    }

    public void setXrefLabel(String xrefLabel) {
        assert (xrefLabel != null);
        this.xrefLabels.clear();
        this.xrefLabels.add(xrefLabel);
    }

    public void setXrefLabels(List<String> xrefLabels) {
        assert (xrefLabels != null);
        this.xrefLabels = xrefLabels;
    }

    public List<QueryRule> getXrefFilters() {
        return this.filters;
    }

    public void setXrefFilters(List<QueryRule> xrefFilter) {
        this.filters = xrefFilter;
    }

    public String getXrefFilterRESTString() {
        return QueryRuleUtil.toRESTstring(this.filters);
    }

    public String getXrefEntitySimpleName() {
        String name = this.xrefEntity.getSimpleName();
        if (name.contains(".")) {
            return name.substring(name.lastIndexOf(".") + 1);
        }
        return name;
    }

    public ActionInput createAddButton() {
        ActionInput addButton = new ActionInput("add", "", "");
        addButton.setId(this.getId() + "_addbutton");
        addButton.setButtonValue("Add new " + this.getXrefEntitySimpleName());
        addButton.setIcon("img/new.png");
        addButton.setJavaScriptAction("if( window.name == '' ){ window.name = 'molgenis_" + MolgenisGuiService.getNewWindowId() + "';}document.getElementById('" + this.getId() + "').form.__action.value='" + this.getId() + "';molgenis_window = window.open('','molgenis_edit_new_xref','height=800,width=600,location=no,status=no,menubar=no,directories=no,toolbar=no,resizable=yes,scrollbars=yes');document.getElementById('" + this.getId() + "').form.target='molgenis_edit_new_xref';document.getElementById('" + this.getId() + "').form.__show.value='popup';document.getElementById('" + this.getId() + "').form.submit();molgenis_window.focus();");
        return addButton;
    }

    public void setIncludeAddButton(boolean includeAddButton) {
        this.includeAddButton = includeAddButton;
    }

    public final String toJquery(String htmlOptions, String xrefLabelString) {
        boolean hasFilters;
        if (this.isHidden()) {
            return this.renderHidden();
        }
        String cssClasses = String.format("%s %s", this.isReadonly() ? "readonly " : "", this.isNillable() ? "" : "required ");
        AjaxChosenData data = new AjaxChosenData();
        data.xrefEntity = this.getXrefEntity().getName();
        data.xrefField = this.getXrefField();
        data.xrefLabels = xrefLabelString;
        data.nillable = this.isNillable();
        boolean bl = hasFilters = this.getXrefFilters() != null && this.getXrefFilters().size() > 0;
        if (hasFilters) {
            data.filters = new Gson().toJson(this.getXrefFilters());
        }
        String preloadScript = "$('#" + this.getId() + "_chzn').find('input[type=text]:first').focus(function(){$(this).keyup()});";
        String selectHtml = "<select id='%1$s' name='%1$s' class='%5$s ui-widget-content ui-corner-all' search='' title='%2$s' style='width: 350px; display: none;' data-placeholder='Choose some %4$s' %3$s>%6$s</select>";
        String select = String.format(selectHtml, this.getId(), this.getDescription(), this.getHtmlRefType(), this.placeholder, cssClasses, htmlOptions);
        AjaxChosenConfig config = new AjaxChosenConfig();
        config.url = this.url;
        config.data = data;
        config.jsonTermKey = SEARCH_TERM;
        Gson gson = new Gson();
        String handleScript = "function (data) {var terms = {}; $.each(data, function (i, val) {terms[i] = val;});return terms;}";
        String ajaxChosenScript = "<script>$('#" + this.getId() + "').ajaxChosen(" + gson.toJson((Object)config) + ", " + handleScript + ");" + preloadScript + "</script>";
        String includeButton = this.includeAddButton && !this.isReadonly() ? this.createAddButton().toString() : "";
        return select + ajaxChosenScript + includeButton;
    }

    public abstract String renderHidden();

    @Override
    public String toHtml() {
        if (this.error != null) {
            return "ERROR: " + this.error;
        }
        if (this.getXrefEntity() == null || "".equals(this.getXrefField()) || this.getXrefLabels() == null || this.getXrefLabels().size() == 0) {
            throw new RuntimeException("XrefInput(" + this.getName() + ") is missing xrefEntity, xrefField and/or xrefLabels settings");
        }
        String xrefLabelString = StringUtils.join(this.getXrefLabels(), (String)",");
        String readonly = this.isReadonly() ? " readonly class=\"readonly\" " : String.format(" onfocus=\"showXrefInput(this,'%s','%s','%s','%s'); return false;\" ", this.getXrefEntity(), this.getXrefField(), xrefLabelString, this.getXrefFilters());
        String optionsHtml = "";
        if (super.getObject() != null) {
            optionsHtml = this.renderOptions();
        }
        if (this.uiToolkit == HtmlElement.UiToolkit.ORIGINAL) {
            String htmlSelect = "<select id=\"" + this.getId() + "\" name=\"" + this.getName() + "\" " + readonly + ">\n" + this.renderOptions() + "</select>\n" + (this.includeAddButton && !this.isReadonly() ? this.createAddButton() : "");
            return htmlSelect;
        }
        if (this.uiToolkit == HtmlElement.UiToolkit.JQUERY) {
            return this.toJquery(optionsHtml, xrefLabelString);
        }
        return "NOT IMPLEMENTED FOR LIBRARY " + (Object)((Object)this.uiToolkit);
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean isPrefill() {
        return this.prefill;
    }

    public void setPrefill(boolean prefill) {
        this.prefill = prefill;
    }

    public String getPlaceholder() {
        return this.placeholder;
    }

    public void setPlaceholder(String placeholder) {
        this.placeholder = placeholder;
    }

    class AjaxChosenConfig {
        public String method = "GET";
        public String url = "";
        public AjaxChosenData data;
        public String dataType = "json";
        public int minTermLength = 0;
        public int afterTypeDelay = 300;
        public String jsonTermKey = "";
        public int test = -100;

        AjaxChosenConfig() {
        }
    }

    class AjaxChosenData {
        public String xrefEntity;
        public String xrefField;
        public String xrefLabels;
        public boolean nillable;
        public String filters;

        AjaxChosenData() {
        }
    }
}

