/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.framework.ui.commands;

import java.io.OutputStream;
import java.util.List;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.server.MolgenisRequest;
import org.molgenis.framework.server.services.MolgenisGuiService;
import org.molgenis.framework.ui.FormModel;
import org.molgenis.framework.ui.FreemarkerView;
import org.molgenis.framework.ui.ScreenController;
import org.molgenis.framework.ui.ScreenModel;
import org.molgenis.framework.ui.SimpleScreenModel;
import org.molgenis.framework.ui.commands.ScreenCommand;
import org.molgenis.framework.ui.html.ActionInput;
import org.molgenis.framework.ui.html.HtmlInput;

public abstract class SimpleCommand
extends SimpleScreenModel
implements ScreenCommand {
    private static final long serialVersionUID = -3289941539731301135L;
    private String name;
    private String label;
    private String icon;
    private String onClickJavascript;
    private ScreenController<? extends ScreenModel> screenController;
    private String targetScreen;
    private boolean showDialog = false;
    private boolean download = false;
    private String menu;
    private boolean showOnToolbar;

    public SimpleCommand(String name, ScreenController<?> parentController) {
        super(parentController);
        this.setName(name);
    }

    @Override
    public String getJavaScriptAction() {
        if (this.onClickJavascript == null) {
            StringBuffer jScript = new StringBuffer();
            jScript.append("if( window.name == '' ){ window.name = 'molgenis_" + MolgenisGuiService.getNewWindowId() + "';}");
            jScript.append("document.forms." + this.getController().getName() + "_form." + "__target" + ".value='" + this.getController().getName() + "';");
            jScript.append("document.forms." + this.getController().getName() + "_form." + "__action" + ".value='" + this.getName() + "';");
            if (this.isDialog()) {
                jScript.append("molgenis_window = window.open('','molgenis_" + this.getName() + "','height=800,width=800,location=no,status=no,menubar=no,directories=no,toolbar=no,resizable=yes,scrollbars=yes');");
                jScript.append("document.forms." + this.getController().getName() + "_form.target='" + "molgenis_" + this.getName() + "';");
                jScript.append("document.forms." + this.getController().getName() + "_form." + "__show" + ".value='" + (Object)((Object)ScreenModel.Show.SHOW_DIALOG) + "';");
            } else if (this.isDownload()) {
                jScript.append("document.forms." + this.getController().getName() + "_form." + "__show" + ".value='" + (Object)((Object)ScreenModel.Show.SHOW_DOWNLOAD) + "';");
            } else {
                jScript.append("document.forms." + this.getController().getName() + "_form.target=window.name;");
                jScript.append("document.forms." + this.getController().getName() + "_form." + "__show" + ".value='" + (Object)((Object)ScreenModel.Show.SHOW_MAIN) + "';");
            }
            jScript.append("document.forms." + this.getController().getName() + "_form.submit();");
            if (this.isDialog()) {
                jScript.append("molgenis_window.focus();");
            }
            return jScript.toString();
        }
        return this.onClickJavascript;
    }

    @Override
    public abstract List<HtmlInput<?>> getInputs() throws DatabaseException;

    @Override
    public String getIcon() {
        return this.icon;
    }

    @Override
    public void setIcon(String icon) {
        this.icon = icon;
    }

    @Override
    public String getLabel() {
        if (this.label != null) {
            return this.label;
        }
        return this.getName();
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public void setJavaScriptAction(String action) {
        this.onClickJavascript = action;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getTarget() {
        return this.targetScreen;
    }

    @Override
    public void setTargetController(String target) {
        this.targetScreen = target;
    }

    @Override
    public ScreenController<? extends ScreenModel> getController() {
        return this.screenController;
    }

    @Override
    public FormModel<?> getFormScreen() {
        return (FormModel)this.screenController.getModel();
    }

    @Override
    public void setController(ScreenController<? extends ScreenModel> controller) {
        this.screenController = controller;
    }

    @Override
    public boolean isDialog() {
        return this.showDialog;
    }

    @Override
    public void setDialog(boolean dialog) {
        this.showDialog = dialog;
    }

    @Override
    public String getMenu() {
        return this.menu;
    }

    @Override
    public void setMenu(String menu) {
        this.menu = menu;
    }

    @Override
    public abstract List<ActionInput> getActions();

    @Override
    public abstract ScreenModel.Show handleRequest(Database var1, MolgenisRequest var2, OutputStream var3) throws Exception;

    @Override
    public boolean isDownload() {
        return this.download;
    }

    @Override
    public void setDownload(boolean download) {
        this.download = download;
    }

    @Override
    public boolean isToolbar() {
        return this.showOnToolbar;
    }

    @Override
    public void setToolbar(boolean toolbar) {
        this.showOnToolbar = toolbar;
    }

    @Override
    public String getMacro() {
        return ScreenCommand.class.getSimpleName();
    }

    @Override
    public String getTemplate() {
        return null;
    }

    @Override
    public boolean isVisible() {
        return Boolean.TRUE;
    }

    @Override
    public String getCustomHtmlHeaders() {
        return "";
    }

    @Override
    public String getCustomHtmlBodyOnLoad() {
        return "";
    }

    @Override
    public String render() {
        return new FreemarkerView("ScreenCommand.ftl", this).render();
    }
}

