/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.framework.ui.commands;

import java.io.OutputStream;
import java.util.List;
import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.framework.server.MolgenisRequest;
import org.molgenis.framework.ui.FormController;
import org.molgenis.framework.ui.FormModel;
import org.molgenis.framework.ui.ScreenController;
import org.molgenis.framework.ui.ScreenModel;
import org.molgenis.framework.ui.commands.SimpleCommand;
import org.molgenis.framework.ui.html.ActionInput;
import org.molgenis.framework.ui.html.HtmlInput;
import org.molgenis.io.TupleWriter;
import org.molgenis.io.csv.CsvWriter;
import org.molgenis.util.Entity;

public class DownloadAllCommand<E extends Entity>
extends SimpleCommand {
    private static final long serialVersionUID = -2682113764135477871L;
    private static final Logger logger = Logger.getLogger(DownloadAllCommand.class);

    public DownloadAllCommand(String name, ScreenController<?> parentScreen) {
        super(name, parentScreen);
        this.setLabel("Download all (.txt)");
        this.setIcon("img/download.png");
        this.setDownload(true);
        this.setMenu("File");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScreenModel.Show handleRequest(Database db, MolgenisRequest request, OutputStream csvDownload) throws Exception {
        logger.debug((Object)this.getName());
        FormModel<?> model = this.getFormScreen();
        FormController controller = (FormController)this.getController();
        List<String> fieldsToExport = controller.getVisibleColumnNames();
        QueryRule[] rules = model.getRulesExclLimitOffset();
        CsvWriter csvWriter = new CsvWriter(csvDownload);
        try {
            db.find(((FormController)model.getController()).getEntityClass(), (TupleWriter)csvWriter, fieldsToExport, rules);
        }
        finally {
            csvWriter.close();
        }
        return ScreenModel.Show.SHOW_MAIN;
    }

    @Override
    public List<ActionInput> getActions() {
        return null;
    }

    @Override
    public List<HtmlInput<?>> getInputs() throws DatabaseException {
        return null;
    }
}

