/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.framework.ui;

import java.io.IOException;
import java.io.OutputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.framework.db.paging.DatabasePager;
import org.molgenis.framework.db.paging.LimitOffsetPager;
import org.molgenis.framework.server.MolgenisRequest;
import org.molgenis.framework.ui.FormModel;
import org.molgenis.framework.ui.FreemarkerView;
import org.molgenis.framework.ui.MenuController;
import org.molgenis.framework.ui.ScreenController;
import org.molgenis.framework.ui.ScreenMessage;
import org.molgenis.framework.ui.ScreenModel;
import org.molgenis.framework.ui.ScreenView;
import org.molgenis.framework.ui.SimpleScreenController;
import org.molgenis.framework.ui.commands.ScreenCommand;
import org.molgenis.framework.ui.commands.SimpleCommand;
import org.molgenis.framework.ui.html.HtmlForm;
import org.molgenis.framework.ui.html.HtmlInput;
import org.molgenis.model.MolgenisModelException;
import org.molgenis.model.elements.Entity;
import org.molgenis.model.elements.Field;
import org.molgenis.util.tuple.KeyValueTuple;
import org.molgenis.util.tuple.Tuple;

public abstract class FormController<E extends org.molgenis.util.Entity>
extends SimpleScreenController<FormModel<E>> {
    private static final Logger logger = Logger.getLogger(FormController.class);
    private static final long serialVersionUID = 7813540700458832850L;
    private static final int MAX_FILTERS = 100;
    private static final String FILTER_ATTRIBUTE_ALL = "all";
    protected DatabasePager<E> pager;

    public FormController(String name, ScreenController<?> parent) {
        super(name, null, parent);
        this.setModel(new FormModel(this));
        FormModel model = (FormModel)this.getModel();
        this.resetSystemHiddenColumns();
        model.resetUserHiddenColumns();
        try {
            this.pager = new LimitOffsetPager<E>(this.getEntityClass(), model.create().getFields().firstElement());
            this.pager.setOrderByField(model.getSort());
            this.pager.setOrderByOperator(model.getSortMode());
            this.pager.setLimit(model.getLimit());
        }
        catch (DatabaseException e) {
            logger.error((Object)e.getMessage());
            e.printStackTrace();
        }
    }

    @Override
    public ScreenModel.Show handleRequest(Database db, MolgenisRequest request, OutputStream out) {
        logger.debug((Object)("handleRequest(" + request + ")"));
        FormModel model = (FormModel)this.getModel();
        model.setMessages(new Vector<ScreenMessage>());
        try {
            String action = request.getString("__action");
            if (request.getString("__command") != null) {
                action = request.getString("__command");
            }
            model.setSelectedIds(request.getList("massUpdate"));
            if (model.getSelectedIds() == null) {
                model.setSelectedIds(new ArrayList());
            }
            ScreenCommand command = model.getCommand(action);
            if (action == null || action.isEmpty()) {
                logger.debug((Object)"action or command does not exist");
                return ScreenModel.Show.SHOW_MAIN;
            }
            if (command != null && command instanceof SimpleCommand) {
                logger.debug((Object)"delegating to PluginCommand");
                model.setCurrentCommand(command);
                return command.handleRequest(db, request, out);
            }
            if (action.equals("filter_add")) {
                this.addFilters(this.pager, db, request);
            } else if (action.equals("filter_remove")) {
                int index = request.getInt("filter_id");
                model.getUserRules().remove(index);
                ArrayList<QueryRule> rules = new ArrayList<QueryRule>();
                rules.addAll(model.getUserRules());
                rules.addAll(model.getSystemRules());
                this.pager.resetFilters(rules);
            } else if (action.equals("filter_set")) {
                model.setUserRules(new ArrayList<QueryRule>());
                this.addFilters(this.pager, db, request);
            } else if (action.equals("update")) {
                this.doUpdate(db, request);
            } else if (action.equals("remove")) {
                this.doRemove(db, request);
            } else if (action.equals("add")) {
                this.doAdd(db, request);
            } else if (action.equals("prev")) {
                this.pager.prev(db);
            } else if (action.equals("next")) {
                this.pager.next(db);
            } else if (action.equals("first")) {
                this.pager.first(db);
            } else if (action.equals("last")) {
                this.pager.last(db);
            } else if (action.equals("sort")) {
                String attribute = this.getSearchField(request.getString("__sortattribute"));
                if (this.pager.getOrderByField().equals(attribute)) {
                    if (this.pager.getOrderByOperator().equals((Object)QueryRule.Operator.SORTASC)) {
                        this.pager.setOrderByOperator(QueryRule.Operator.SORTDESC);
                    } else {
                        this.pager.setOrderByOperator(QueryRule.Operator.SORTASC);
                    }
                } else {
                    this.pager.setOrderByField(attribute);
                    this.pager.setOrderByOperator(QueryRule.Operator.SORTASC);
                }
            } else if (action.equals("xref_select")) {
                this.doXrefselect(request);
            } else if (action.equals("hideColumn")) {
                String attribute;
                List<String> UserHiddencols = model.getUserHiddenColumns();
                if (!UserHiddencols.contains(attribute = request.getString("attribute"))) {
                    UserHiddencols.add(attribute);
                }
                model.setUserHiddenColumns(UserHiddencols);
            } else if (action.equals("showColumn")) {
                String attribute;
                List<String> UserHiddencols = model.getUserHiddenColumns();
                if (UserHiddencols.contains(attribute = request.getString("attribute"))) {
                    UserHiddencols.remove(attribute);
                }
                model.setUserHiddenColumns(UserHiddencols);
            } else {
                logger.debug((Object)("action '" + action + "' unknown"));
            }
            logger.debug((Object)"handleRequest finished.");
        }
        catch (DatabaseException e) {
            logger.warn((Object)e);
        }
        catch (MolgenisModelException e) {
            logger.warn((Object)e);
        }
        catch (ParseException e) {
            logger.warn((Object)e);
        }
        catch (IOException e) {
            logger.warn((Object)e);
        }
        catch (Exception e) {
            logger.warn((Object)e);
        }
        return ScreenModel.Show.SHOW_MAIN;
    }

    private ScreenModel.Show addFilters(DatabasePager<E> pager, Database db, MolgenisRequest request) throws DatabaseException, MolgenisModelException {
        ArrayList<QueryRule> userRules = new ArrayList<QueryRule>();
        for (int i = 0; i < 100; ++i) {
            QueryRule filterRule;
            String suffix = i > 0 ? i + "" : "";
            String filterAttr = request.getString("__filter_attribute" + suffix);
            if (filterAttr == null) break;
            String operatorStr = request.getString("__filter_operator" + suffix);
            QueryRule.Operator operator = QueryRule.Operator.valueOf(operatorStr);
            String filterValue = request.getString("__filter_value" + suffix);
            if (filterAttr.equals(FILTER_ATTRIBUTE_ALL)) {
                filterRule = this.createFilterRule(db, operator, filterValue);
            } else {
                String fieldName = this.toFieldName(filterAttr);
                filterRule = this.createFilterRule(db, fieldName, operator, filterValue);
            }
            userRules.add(filterRule);
        }
        FormModel model = (FormModel)this.getModel();
        model.getUserRules().addAll(userRules);
        ArrayList<QueryRule> rules = new ArrayList<QueryRule>();
        rules.addAll(model.getUserRules());
        rules.addAll(model.getSystemRules());
        pager.resetFilters(rules);
        pager.first(db);
        return ScreenModel.Show.SHOW_MAIN;
    }

    QueryRule createFilterRule(Database db, String fieldName, QueryRule.Operator operator, String value) throws DatabaseException, MolgenisModelException {
        if (StringUtils.isEmpty((CharSequence)fieldName) || operator == null || StringUtils.isEmpty((CharSequence)value)) {
            return null;
        }
        QueryRule queryRule = null;
        for (Field field : this.getAllFields(db)) {
            if (!field.getName().equals(fieldName)) continue;
            fieldName = this.getSearchField(fieldName);
            queryRule = new QueryRule(fieldName, operator, value);
            break;
        }
        return queryRule;
    }

    QueryRule createFilterRule(Database db, QueryRule.Operator operator, String value) throws DatabaseException, MolgenisModelException {
        if (operator == null || StringUtils.isEmpty((CharSequence)value)) {
            return null;
        }
        ArrayList<QueryRule> queryRules = new ArrayList<QueryRule>();
        for (Field field : this.getAllFields(db)) {
            String fieldName = this.getSearchField(field.getName());
            if (!queryRules.isEmpty()) {
                queryRules.add(new QueryRule(QueryRule.Operator.OR));
            }
            queryRules.add(new QueryRule(fieldName, operator, value));
        }
        return !queryRules.isEmpty() ? new QueryRule(queryRules) : null;
    }

    private Vector<Field> getAllFields(Database db) throws DatabaseException, MolgenisModelException {
        String simpleName = this.getEntityClass().getSimpleName();
        Entity entity = db.getMetaData().getEntity(simpleName);
        Vector<Field> allFields = entity.getAllFields();
        Iterator<Field> it = entity.getAllFields().iterator();
        while (it.hasNext()) {
            Field field = it.next();
            if (!field.isSystem() && !field.isHidden()) continue;
            it.remove();
        }
        return allFields;
    }

    private String toFieldName(String entityUnderscoreFieldName) {
        String simpleName = this.getEntityClass().getSimpleName();
        return entityUnderscoreFieldName.substring(simpleName.length() + 1);
    }

    @Override
    public void reload(Database db) {
        logger.info((Object)"reloading...");
        FormModel model = (FormModel)this.getModel();
        try {
            this.pager.setDirty(true);
            ArrayList<QueryRule> rules = new ArrayList<QueryRule>();
            rules.addAll(model.getUserRules());
            rules.addAll(model.getSystemRules());
            this.pager.resetFilters(rules);
            if (model.getMode().equals((Object)FormModel.Mode.EDIT_VIEW)) {
                this.pager.setLimit(1);
            } else {
                this.pager.setLimit(model.getLimit());
            }
            if (model.isReadonly()) {
                this.pager.refresh(db);
            }
            if (model.getMode().equals((Object)FormModel.Mode.EDIT_VIEW) && this.pager.getRecordId() > 0) {
                model.setRecordId(this.pager.getRecordId());
                ArrayList<E> entities = new ArrayList<E>();
                E entity = db.findById(this.getEntityClass(), this.pager.getRecordId());
                entities.add(entity);
                model.setRecords(entities);
            } else {
                model.setRecords(this.getData(db));
            }
            model.setCount(this.pager.getCount(db));
            model.setOffset(this.pager.getOffset());
            model.setSort(this.pager.getOrderByField());
            model.setSortMode(this.pager.getOrderByOperator());
            if (model.getMode().equals((Object)FormModel.Mode.EDIT_VIEW)) {
                for (ScreenController c : this.getChildren()) {
                    if (!(c instanceof SimpleScreenController)) continue;
                    c.reload(db);
                }
            }
            logger.debug((Object)"reload finished.");
        }
        catch (Exception e) {
            logger.error((Object)("reload() failed: " + e.getMessage()));
            e.printStackTrace();
        }
    }

    private List<E> getData(Database db) throws DatabaseException {
        FormModel model = (FormModel)this.getModel();
        boolean formReadonly = model.isReadonly() || !model.getLogin().canWrite(model.create().getClass());
        model.setReadonly(formReadonly);
        ArrayList<org.molgenis.util.Entity> visibleRecords = new ArrayList<org.molgenis.util.Entity>();
        List<E> allRecords = this.pager.getPage(db);
        for (org.molgenis.util.Entity record : allRecords) {
            boolean rowReadonly;
            boolean bl = rowReadonly = formReadonly || !model.getLogin().canWrite(record.getClass());
            if (rowReadonly) {
                record.setReadonly(true);
            }
            visibleRecords.add(record);
        }
        return visibleRecords;
    }

    public boolean doAdd(Database db, MolgenisRequest request) throws ParseException, DatabaseException, IOException {
        ScreenMessage msg = null;
        Object entity = ((FormModel)this.getModel()).create();
        boolean result = false;
        try {
            db.beginTx();
            entity.set(request, false);
            int updatedRows = 0;
            if (request.get("__batchadd") != null && request.getInt("__batchadd") > 1) {
                for (int i = 0; i < request.getInt("__batchadd"); ++i) {
                    updatedRows += db.add(entity);
                }
            } else {
                updatedRows = db.add(entity);
            }
            db.commitTx();
            msg = new ScreenMessage("ADD SUCCESS: affected " + updatedRows, null, true);
            result = true;
            this.pager.last(db);
        }
        catch (Exception e) {
            db.rollbackTx();
            msg = new ScreenMessage("ADD FAILED: " + e.getMessage(), null, false);
            result = false;
        }
        ((FormModel)this.getModel()).getMessages().add(msg);
        this.pager.resetOrderBy();
        this.pager.last(db);
        return result;
    }

    protected void doUpdate(Database db, MolgenisRequest request) throws DatabaseException, IOException, ParseException {
        Object entity = ((FormModel)this.getModel()).create();
        ScreenMessage msg = null;
        try {
            entity.set(request, false);
            int updatedRows = db.update(entity);
            msg = new ScreenMessage("UPDATE SUCCESS: affected " + updatedRows, null, true);
        }
        catch (Exception e) {
            logger.error((Object)("doUpdate(): " + e));
            e.printStackTrace();
            msg = new ScreenMessage("UPDATE FAILED: " + e.getMessage(), null, false);
        }
        ((FormModel)this.getModel()).getMessages().add(msg);
        if (msg.isSuccess()) {
            this.pager.setDirty(true);
        }
    }

    protected void doRemove(Database db, MolgenisRequest request) throws DatabaseException, ParseException, IOException {
        Object entity = ((FormModel)this.getModel()).create();
        ScreenMessage msg = null;
        try {
            entity.set(request);
            int updatedRows = db.remove(entity);
            msg = updatedRows > 0 ? new ScreenMessage("REMOVE SUCCESS: affected " + updatedRows, null, true) : new ScreenMessage("REMOVE FAILED: call system administrator", null, false);
        }
        catch (Exception e) {
            msg = new ScreenMessage("REMOVE FAILED: " + e.getMessage(), null, false);
        }
        ((FormModel)this.getModel()).getMessages().add(msg);
        if (msg.isSuccess()) {
            this.pager.prev(db);
        }
    }

    private void doXrefselect(Tuple request) throws DatabaseException {
        if (this.getParent() != null && this.getParent() instanceof MenuController) {
            this.pager.resetFilters();
            ((FormModel)this.getModel()).setUserRules(new ArrayList<QueryRule>());
            QueryRule rule = new QueryRule(request.getString("attribute"), QueryRule.Operator.valueOf(request.getString("operator")), request.getString("value"));
            this.pager.addFilter(rule);
            KeyValueTuple tuple = new KeyValueTuple();
            String aChildName = ((FormModel)this.getModel()).getName();
            for (ScreenController aParent = (ScreenController)this.getParent(); aParent != null; aParent = (ScreenController)aParent.getParent()) {
                if (aParent instanceof MenuController) {
                    tuple.set("select", aChildName);
                    MenuController c = (MenuController)aParent;
                    c.doSelect(tuple);
                }
                aChildName = aParent.getName();
            }
        }
    }

    public DatabasePager<E> getPager() {
        return this.pager;
    }

    public List<String> getVisibleColumnNames() {
        ArrayList<String> showColumns = new ArrayList<String>();
        try {
            HtmlForm f = this.getInputs((org.molgenis.util.Entity)this.getEntityClass().newInstance(), false);
            for (HtmlInput<?> i : f.getInputs()) {
                if (i.isHidden()) continue;
                String name = i.getName();
                name = name.substring(this.getEntityClass().getSimpleName().length() + 1);
                showColumns.add(this.getSearchField(name));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return showColumns;
    }

    @Override
    public String getCustomHtmlHeaders() {
        StringBuilder s = new StringBuilder();
        s.append("<link rel=\"stylesheet\" href=\"css/molgenis-dateinput.css\" type=\"text/css\" />");
        s.append("<link rel=\"stylesheet\" href=\"css/molgenis-jquery_icons.css\" type=\"text/css\" />");
        s.append("<link rel=\"stylesheet\" href=\"css/molgenis-xrefinput.css\" type=\"text/css\" />");
        s.append("<link rel=\"stylesheet\" href=\"css/jquery.bt.css\" type=\"text/css\" />");
        s.append("<link rel=\"stylesheet\" href=\"css/jquery.chosen.css\" type=\"text/css\" />");
        s.append("<script type=\"text/javascript\" src=\"js/molgenis-textinput.js\"></script>");
        s.append("<script type=\"text/javascript\" src=\"js/molgenis-datetimeinput.js\"></script>");
        s.append("<script type=\"text/javascript\" src=\"js/molgenis-xrefinput.js\"></script>");
        s.append("<script type=\"text/javascript\" src=\"js/molgenis-mrefinput.js\"></script>");
        s.append("<script type=\"text/javascript\" src=\"js/jquery.ajax-chosen.js\"></script>");
        s.append("<script type=\"text/javascript\" src=\"js/jquery.autogrowinput.js\"></script>");
        s.append("<script type=\"text/javascript\" src=\"js/jquery.bt.min.js\"></script>");
        s.append("<script type=\"text/javascript\" src=\"js/jquery.chosen.js\"></script>");
        s.append("<script type=\"text/javascript\" src=\"js/jquery.timepicker.js\"></script>");
        s.append("<script type=\"text/javascript\" src=\"js/jquery.validate.min.js\"></script>");
        return s.toString();
    }

    @Override
    public ScreenView getView() {
        return new FreemarkerView("FormView.ftl", (ScreenModel)this.getModel());
    }

    public abstract Class<E> getEntityClass();

    public abstract void resetSystemHiddenColumns();

    public abstract void resetCompactView();

    public abstract HtmlForm getInputs(E var1, boolean var2);

    public abstract Vector<String> getHeaders();

    public abstract String getSearchField(String var1);

    public abstract String getField(String var1);
}

