/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.framework.tupletable.view.renderers;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.molgenis.framework.tupletable.TableException;
import org.molgenis.framework.tupletable.TupleTable;
import org.molgenis.framework.tupletable.view.renderers.AbstractExporter;
import org.molgenis.io.csv.CsvWriter;
import org.molgenis.model.elements.Field;
import org.molgenis.util.tuple.AbstractTuple;
import org.molgenis.util.tuple.Tuple;

public class CsvExporter
extends AbstractExporter {
    public CsvExporter(TupleTable table) {
        super(table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void export(OutputStream os) throws IOException, TableException {
        CsvWriter csvWriter = new CsvWriter(os);
        int colOffset = this.tupleTable.getColOffset();
        int colLimit = this.tupleTable.getColLimit();
        int rowOffset = this.tupleTable.getOffset();
        int rowLimit = this.tupleTable.getLimit();
        this.tupleTable.setColOffset(0);
        this.tupleTable.setColLimit(0);
        this.tupleTable.setOffset(0);
        this.tupleTable.setLimit(0);
        try {
            csvWriter.writeColNames(new FieldHeaderTuple(this.tupleTable.getColumns()).getColNames());
            for (Tuple row : this.tupleTable) {
                csvWriter.write(row);
            }
        }
        finally {
            IOUtils.closeQuietly((Closeable)csvWriter);
            this.tupleTable.setColOffset(colOffset);
            this.tupleTable.setColLimit(colLimit);
            this.tupleTable.setOffset(rowOffset);
            this.tupleTable.setLimit(rowLimit);
        }
    }

    private static class FieldHeaderTuple
    extends AbstractTuple {
        private static final long serialVersionUID = 1L;
        private final List<Field> fields;

        public FieldHeaderTuple(List<Field> fields) {
            if (fields == null) {
                throw new IllegalArgumentException("fields is null");
            }
            this.fields = fields;
        }

        @Override
        public int getNrCols() {
            return this.fields.size();
        }

        @Override
        public Iterable<String> getColNames() {
            return Iterables.transform(this.fields, (Function)new Function<Field, String>(){

                @Nullable
                public String apply(@Nullable Field arg0) {
                    return arg0 != null ? arg0.getSqlName() : null;
                }
            });
        }

        @Override
        public Object get(String colName) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object get(int col) {
            throw new UnsupportedOperationException();
        }
    }
}

