/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.framework.server.services;

import java.io.File;
import java.util.Date;
import org.apache.commons.io.FileUtils;

class CleanTmpDirProcess
implements Runnable {
    private long mfa;
    private long hox;

    CleanTmpDirProcess(int howOftenExecutedInSeconds, long maxFileAgeInHours) {
        this.hox = howOftenExecutedInSeconds;
        this.mfa = maxFileAgeInHours;
        Thread t = new Thread(this);
        t.start();
    }

    @Override
    public void run() {
        boolean noExceptions = true;
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException e) {
            System.out.println("SEVERE: CleanTmpDirProcess thread failed to wait on startup");
            e.printStackTrace();
            noExceptions = false;
        }
        while (noExceptions) {
            try {
                System.out.println("MolgenisCleanTmpDirService: executing cleaning job!");
                String tmpDirLoc = System.getProperty("java.io.tmpdir");
                File tmpDir = new File(tmpDirLoc);
                long curDate = new Date().getTime();
                long maxAge = 3600000L * this.mfa;
                for (File f : tmpDir.listFiles()) {
                    long lastMod = f.lastModified();
                    long age = curDate - lastMod;
                    if (age <= maxAge) continue;
                    System.out.println("MolgenisCleanTmpDirService: tmp file " + f.getName() + " is older than " + this.mfa + " hours, deleting...");
                    FileUtils.deleteQuietly((File)f);
                }
            }
            catch (Exception e) {
                System.out.println("SEVERE: Breaking execution of CleanTmpDirProcess! InterruptedException on file delete");
                e.printStackTrace();
                noExceptions = false;
            }
            long sleepTime = 1000L * this.hox;
            System.out.println("MolgenisCleanTmpDirService: going to sleep for " + this.hox + " seconds..");
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException e) {
                System.out.println("SEVERE: Breaking execution of CleanTmpDirProcess! InterruptedException on thread sleep");
                e.printStackTrace();
                noExceptions = false;
            }
        }
    }
}

