/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.framework.server;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.RollingFileAppender;
import org.molgenis.MolgenisOptions;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.server.MolgenisContext;
import org.molgenis.framework.server.MolgenisRequest;
import org.molgenis.framework.server.MolgenisResponse;
import org.molgenis.framework.server.MolgenisService;
import org.molgenis.util.DatabaseUtil;

public abstract class MolgenisFrontController
extends HttpServlet
implements MolgenisService {
    private static final long serialVersionUID = -2141508157810793106L;
    protected Logger logger;
    private final DateFormat dateFormat = new SimpleDateFormat("HH:mm:ss 'on' dd MMMM yyyy");
    protected Map<String, MolgenisService> services;
    protected MolgenisOptions usedOptions = null;
    protected MolgenisContext context;

    public void service(HttpServletRequest request, HttpServletResponse response) {
        try {
            Enumeration attributeNames = request.getAttributeNames();
            while (attributeNames.hasMoreElements()) {
                String nextElement = (String)attributeNames.nextElement();
                System.out.println(String.format("---> %s: %s", nextElement, request.getAttribute(nextElement)));
            }
            MolgenisRequest req = new MolgenisRequest(request, response);
            req.setDatabase(DatabaseUtil.getDatabase());
            MolgenisResponse res = new MolgenisResponse(response);
            this.handleRequest(req, res);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage());
            e.printStackTrace();
        }
    }

    @Override
    public void handleRequest(MolgenisRequest request, MolgenisResponse response) throws ParseException, DatabaseException, IOException {
        HttpServletRequest req = request.getRequest();
        if (this.usedOptions.block_webspiders) {
            String userAgent = req.getHeader("User-Agent");
            for (String spider : new String[]{"Googlebot", "Yammybot", "Openbot", "Yahoo", "Slurp", "msnbot", "ia_archiver", "Lycos", "Scooter", "AltaVista", "Teoma", "Gigabot", "Googlebot-Mobile"}) {
                if (userAgent == null || !userAgent.contains(spider)) continue;
                response.response.sendError(403, "This page is forbidden for spiders.");
                return;
            }
        }
        String servletPath = req.getServletPath();
        String baseURL = req.getRequestURL().substring(0, req.getRequestURL().length() - servletPath.length());
        for (String servicePath : this.services.keySet()) {
            System.out.println("servicePath for service=" + servicePath);
            if (!servletPath.startsWith(servicePath)) continue;
            Date date = new Date();
            if (servicePath.equals("/")) {
                System.out.println("> serving file: " + servletPath);
                this.services.get(servicePath).handleRequest(request, response);
            } else {
                System.out.println("> new request \"" + servletPath + "\" from " + request.getRequest().getRemoteHost() + " at " + this.dateFormat.format(date) + " handled by " + this.services.get(servicePath).getClass().getSimpleName() + " mapped on path " + servicePath);
                System.out.println("request fields: " + request.toString());
                System.out.println("database status: " + (request.getDatabase().getLogin().isAuthenticated() ? "authenticated as " + request.getDatabase().getLogin().getUserName() : "not authenticated"));
                request.setAppLocation(baseURL);
                request.setServicePath(servicePath);
                request.setRequestPath(servletPath);
                this.services.get(servicePath).handleRequest(request, response);
            }
            return;
        }
    }

    protected void createLogger() throws ServletException {
        try {
            if (StringUtils.isEmpty((CharSequence)this.usedOptions.log4j_properties_uri)) {
                Logger rootLogger = Logger.getRootLogger();
                rootLogger.removeAllAppenders();
                PatternLayout pattern = new PatternLayout("%-4r %-5p [%c] %m%n");
                rootLogger.setLevel(this.usedOptions.log_level);
                if (this.usedOptions.log_target.equals((Object)MolgenisOptions.LogTarget.CONSOLE)) {
                    rootLogger.addAppender((Appender)new ConsoleAppender((Layout)pattern));
                    System.out.println("Log4j CONSOLE appender added log level " + this.usedOptions.log_level);
                }
                if (this.usedOptions.log_target.equals((Object)MolgenisOptions.LogTarget.FILE)) {
                    RollingFileAppender fa = new RollingFileAppender((Layout)pattern, "logger.out");
                    fa.setMaximumFileSize(100000000L);
                    rootLogger.addAppender((Appender)fa);
                    System.out.println("Log4j FILE appender added with level " + this.usedOptions.log_level + ", writing to: " + new File(fa.getFile()).getAbsolutePath());
                }
                if (this.usedOptions.log_target.equals((Object)MolgenisOptions.LogTarget.OFF)) {
                    System.out.println("Log4j logger turned off");
                }
            } else {
                ClassLoader loader = this.getClass().getClassLoader();
                URL urlLog4jProp = loader.getResource(this.usedOptions.log4j_properties_uri);
                if (urlLog4jProp == null) {
                    System.out.println(String.format("*** Incorrect log4j_properties_uri : '%s' in Molgenis properties file, so initializing log4j with BasicConfigurator", urlLog4jProp));
                    BasicConfigurator.configure();
                } else {
                    System.out.println(String.format("*** Log4j initializing with config file %s", urlLog4jProp));
                    PropertyConfigurator.configure((URL)urlLog4jProp);
                }
            }
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }
}

