/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.framework.db.jpa;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.molgenis.framework.db.AbstractDatabase;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.model.elements.Model;
import org.molgenis.util.tuple.KeyValueTuple;
import org.molgenis.util.tuple.Tuple;

public class JpaDatabase
extends AbstractDatabase {
    public static final String DEFAULT_PERSISTENCE_UNIT_NAME = "molgenis";
    private final EntityManager em;

    public JpaDatabase(EntityManager em) {
        this(em, null);
    }

    public JpaDatabase(EntityManager em, Model model) {
        if (em == null) {
            throw new IllegalArgumentException("entity manager is null");
        }
        this.em = em;
        this.model = model;
    }

    @Override
    public EntityManager getEntityManager() {
        return this.em;
    }

    @Override
    public void beginTx() throws DatabaseException {
        try {
            if (this.em.getTransaction() != null && !this.em.getTransaction().isActive()) {
                this.em.getTransaction().begin();
            }
        }
        catch (Exception e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public boolean inTx() {
        return this.em.getTransaction().isActive();
    }

    @Override
    public void commitTx() throws DatabaseException {
        try {
            if (this.em.getTransaction() != null && this.em.getTransaction().isActive()) {
                this.em.getTransaction().commit();
            }
        }
        catch (Exception e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public void rollbackTx() throws DatabaseException {
        try {
            if (this.em.getTransaction().isActive()) {
                this.em.getTransaction().rollback();
            }
        }
        catch (Exception e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.em.close();
        }
        catch (IllegalStateException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void flush() {
        this.em.flush();
    }

    public List executeSQLQuery(String sqlQuery) {
        return this.em.createNativeQuery(sqlQuery).getResultList();
    }

    public <T> List<T> executeSQLQuery(String sqlQuery, Class<T> resultClass) {
        return this.em.createNativeQuery(sqlQuery, resultClass).getResultList();
    }

    public String getPersistenceUnitName() {
        return DEFAULT_PERSISTENCE_UNIT_NAME;
    }

    public List<Tuple> sql(String sql, String ... columnNames) {
        Query q = this.em.createNativeQuery(sql);
        ArrayList<Tuple> result = new ArrayList<Tuple>();
        for (Object o : q.getResultList()) {
            KeyValueTuple row = new KeyValueTuple();
            if (columnNames.length == 1) {
                row.set(columnNames[0], o);
            } else {
                Object[] arr = (Object[])o;
                for (int i = 0; i < columnNames.length; ++i) {
                    row.set(columnNames[i], arr[i]);
                }
            }
            result.add(row);
        }
        return result;
    }
}

