/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.framework.db;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.molgenis.MolgenisOptions;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.Mapper;
import org.molgenis.framework.db.Query;
import org.molgenis.framework.db.QueryImp;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.framework.security.Login;
import org.molgenis.framework.security.SimpleLogin;
import org.molgenis.io.TupleReader;
import org.molgenis.io.TupleWriter;
import org.molgenis.model.elements.Model;
import org.molgenis.util.Entity;
import org.molgenis.util.tuple.EntityTuple;

public abstract class AbstractDatabase
implements Database {
    private static final Logger logger = Logger.getLogger(AbstractDatabase.class);
    protected static final int BATCH_SIZE = 500;
    protected Map<String, Mapper<? extends Entity>> mappers = new LinkedHashMap<String, Mapper<? extends Entity>>();
    public File fileSource;
    protected MolgenisOptions options;
    protected Model model;
    protected Login login = new SimpleLogin();

    @Override
    public Model getMetaData() throws DatabaseException {
        return this.model;
    }

    @Override
    public <E extends Entity> int count(Class<E> klazz, QueryRule ... rules) throws DatabaseException {
        return this.getMapperFor(klazz).count(rules);
    }

    @Override
    public <E extends Entity> List<E> find(Class<E> klazz, QueryRule ... rules) throws DatabaseException {
        return this.getMapperFor(klazz).find(rules);
    }

    @Override
    public <E extends Entity> void find(Class<E> entityClass, TupleWriter writer, QueryRule ... rules) throws DatabaseException {
        this.getMapperFor(entityClass).find(writer, rules);
    }

    @Override
    public <E extends Entity> void find(Class<E> entityClass, TupleWriter writer, List<String> fieldsToExport, QueryRule ... rules) throws DatabaseException {
        try {
            writer.writeColNames(fieldsToExport);
            int count = 0;
            for (Entity e : this.find(entityClass, rules)) {
                writer.write(new EntityTuple(e));
                ++count;
            }
            if (logger.isDebugEnabled() && logger.isDebugEnabled()) {
                logger.debug((Object)String.format("find(%s, writer) wrote %s lines", entityClass.getSimpleName(), count));
            }
            writer.close();
        }
        catch (Exception ex) {
            throw new DatabaseException(ex);
        }
    }

    @Override
    public <E extends Entity> E findById(Class<E> entityClass, Object id) throws DatabaseException {
        return this.getMapperFor(entityClass).findById(id);
    }

    @Override
    public <E extends Entity> Query<E> query(Class<E> entityClass) {
        return new QueryImp<E>(this, entityClass);
    }

    @Override
    public <E extends Entity> Query<E> queryByExample(E entity) {
        return new QueryImp<E>(this, this.getEntityClass(entity)).example(entity);
    }

    @Override
    public <E extends Entity> int update(List<E> entities, Database.DatabaseAction dbAction, String ... keyNames) throws DatabaseException {
        if (keyNames.length == 0) {
            throw new DatabaseException("At least one key must be provided, e.g. 'name'");
        }
        if (entities.size() == 0) {
            return 0;
        }
        Class<Entity> entityClass = this.getClassForEntity((Entity)entities.get(0));
        String entityName = entityClass.getSimpleName();
        LinkedHashMap<String, Entity> entityIndex = new LinkedHashMap<String, Entity>();
        ArrayList keyIndex = new ArrayList();
        boolean keysMissing = false;
        for (Entity entity : entities) {
            StringBuilder combinedKeyBuilder = new StringBuilder();
            LinkedHashMap<String, Object> keyValues = new LinkedHashMap<String, Object>();
            boolean bl = true;
            for (String key : keyNames) {
                combinedKeyBuilder.append(';');
                if (entity.get(key) == null) continue;
                combinedKeyBuilder.append(entity.get(key));
                bl = false;
                keyValues.put(key, entity.get(key));
            }
            if (bl) {
                keysMissing = true;
            }
            if (!keysMissing) {
                keyIndex.add(keyValues);
                entityIndex.put(combinedKeyBuilder.toString(), entity);
                continue;
            }
            if ((dbAction.equals((Object)Database.DatabaseAction.ADD) || dbAction.equals((Object)Database.DatabaseAction.ADD_IGNORE_EXISTING) || dbAction.equals((Object)Database.DatabaseAction.ADD_UPDATE_EXISTING)) && keyNames.length == 1 && keyNames[0].equals(entity.getIdField())) continue;
            throw new DatabaseException("keys are missing: " + entityClass.getSimpleName() + "." + Arrays.asList(keyNames));
        }
        List<E> newEntities = entities;
        ArrayList<Entity> existingEntities = new ArrayList<Entity>();
        if (!keysMissing && keyIndex.size() > 0) {
            newEntities = new ArrayList();
            Query<Entity> q = this.query(this.getClassForEntity((Entity)entities.get(0)));
            if (keyNames.length == 1) {
                ArrayList values = new ArrayList();
                for (Map map : keyIndex) {
                    values.add(map.get(keyNames[0]));
                }
                q.in(keyNames[0], values);
            } else {
                for (Map map : keyIndex) {
                    for (int i = 0; i < keyNames.length; ++i) {
                        if (i > 0) {
                            q.or();
                        }
                        q.equals(keyNames[i], map.get(keyNames[i]));
                    }
                }
            }
            List<Entity> selectForUpdate = q.find();
            for (Entity entity : selectForUpdate) {
                StringBuilder combinedKeyBuilder = new StringBuilder();
                for (String key : keyNames) {
                    combinedKeyBuilder.append(';').append(entity.get(key));
                }
                entityIndex.remove(combinedKeyBuilder.toString());
                existingEntities.add(entity);
            }
            newEntities = new ArrayList(entityIndex.values());
        }
        if (existingEntities.size() > 0 && (dbAction == Database.DatabaseAction.ADD_UPDATE_EXISTING || dbAction == Database.DatabaseAction.UPDATE || dbAction == Database.DatabaseAction.UPDATE_IGNORE_MISSING)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("existingEntities[0] before: " + ((Entity)existingEntities.get(0)).toString()));
            }
            this.matchByNameAndUpdateFields(existingEntities, entities);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("existingEntities[0] after: " + ((Entity)existingEntities.get(0)).toString()));
            }
        }
        switch (dbAction) {
            case ADD: {
                if (existingEntities.size() == 0) {
                    return this.add(newEntities);
                }
                throw new DatabaseException("Tried to add existing " + entityName + " elements as new insert: " + Arrays.asList(keyNames) + "=" + existingEntities.subList(0, Math.min(5, existingEntities.size())) + (existingEntities.size() > 5 ? " and " + (existingEntities.size() - 5) + "more" : "" + existingEntities));
            }
            case ADD_IGNORE_EXISTING: {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("updateByName(List<" + entityName + "," + (Object)((Object)dbAction) + ">) will skip " + existingEntities.size() + " existing entities"));
                }
                return this.add(newEntities);
            }
            case ADD_UPDATE_EXISTING: {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("updateByName(List<" + entityName + "," + (Object)((Object)dbAction) + ">)  will try to update " + existingEntities.size() + " existing entities and add " + newEntities.size() + " new entities"));
                }
                return this.add(newEntities) + this.update(existingEntities);
            }
            case UPDATE: {
                if (newEntities.size() == 0) {
                    return this.update(existingEntities);
                }
                throw new DatabaseException("Tried to update non-existing " + entityName + "elements " + Arrays.asList(keyNames) + "=" + entityIndex.values());
            }
            case UPDATE_IGNORE_MISSING: {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("updateByName(List<" + entityName + "," + (Object)((Object)dbAction) + ">) will try to update " + existingEntities.size() + " existing entities and skip " + newEntities.size() + " new entities"));
                }
                return this.update(existingEntities);
            }
            case REMOVE: {
                if (newEntities.size() == 0) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("updateByName(List<" + entityName + "," + (Object)((Object)dbAction) + ">) will try to remove " + existingEntities.size() + " existing entities"));
                    }
                    return this.remove(existingEntities);
                }
                throw new DatabaseException("Tried to remove non-existing " + entityName + " elements " + Arrays.asList(keyNames) + "=" + entityIndex.values());
            }
            case REMOVE_IGNORE_MISSING: {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("updateByName(List<" + entityName + "," + (Object)((Object)dbAction) + ">) will try to remove " + existingEntities.size() + " existing entities and skip " + newEntities.size() + " new entities"));
                }
                return this.remove(existingEntities);
            }
        }
        throw new DatabaseException("updateByName failed because of unknown dbAction " + (Object)((Object)dbAction));
    }

    public <E extends Entity> void matchByNameAndUpdateFields(List<E> existingEntities, List<E> entities) throws DatabaseException {
        for (Entity entityInDb : existingEntities) {
            for (Entity newEntity : entities) {
                boolean match = false;
                if (entityInDb.getLabelFields().size() > 0) {
                    match = true;
                }
                for (String labelField : entityInDb.getLabelFields()) {
                    Object x2;
                    Object x1 = entityInDb.get(labelField);
                    if (x1.equals(x2 = newEntity.get(labelField))) continue;
                    match = false;
                    break;
                }
                if (!match) continue;
                try {
                    entityInDb.set(new EntityTuple(newEntity), false);
                }
                catch (Exception ex) {
                    throw new DatabaseException(ex);
                }
            }
        }
    }

    @Override
    public <E extends Entity> int add(E entity) throws DatabaseException {
        List<E> entities = this.getMapperFor(this.getEntityClass(entity)).createList(1);
        entities.add(entity);
        return this.add(entities);
    }

    @Override
    public <E extends Entity> int add(List<E> entities) throws DatabaseException {
        if (entities.size() > 0) {
            Class<E> klass = this.getEntityClass(entities);
            return this.getMapperFor(klass).add(entities);
        }
        return 0;
    }

    @Override
    public <E extends Entity> int add(Class<E> klazz, TupleReader reader) throws DatabaseException {
        return this.add(klazz, reader, null);
    }

    @Override
    public <E extends Entity> int add(Class<E> klazz, TupleReader reader, TupleWriter writer) throws DatabaseException {
        return this.getMapperFor(klazz).add(reader, writer);
    }

    @Override
    public <E extends Entity> int update(E entity) throws DatabaseException {
        List<E> entities = this.getMapperFor(this.getEntityClass(entity)).createList(1);
        entities.add(entity);
        return this.update(entities);
    }

    @Override
    public <E extends Entity> int update(List<E> entities) throws DatabaseException {
        if (entities.size() > 0) {
            Class<E> klass = this.getEntityClass(entities);
            return this.getMapperFor(klass).update(entities);
        }
        return 0;
    }

    @Override
    public <E extends Entity> int update(Class<E> klazz, TupleReader reader) throws DatabaseException {
        return this.getMapperFor(klazz).update(reader);
    }

    @Override
    public <E extends Entity> int remove(E entity) throws DatabaseException {
        List<E> entities = this.getMapperFor(this.getEntityClass(entity)).createList(1);
        entities.add(entity);
        return this.remove(entities);
    }

    @Override
    public <E extends Entity> int remove(List<E> entities) throws DatabaseException {
        if (entities.size() > 0) {
            Class<E> klass = this.getEntityClass(entities);
            return this.getMapperFor(klass).remove(entities);
        }
        return 0;
    }

    @Override
    public <E extends Entity> int remove(Class<E> klazz, TupleReader reader) throws DatabaseException {
        return this.getMapperFor(klazz).remove(reader);
    }

    protected <E extends Entity> void putMapper(Class<E> klazz, Mapper<E> mapper) {
        this.mappers.put(klazz.getName(), mapper);
    }

    @Override
    public <E extends Entity> Mapper<E> getMapperFor(Class<E> klazz) throws DatabaseException {
        Mapper<? extends Entity> mapper = this.mappers.get(klazz.getName());
        if (mapper == null) {
            throw new DatabaseException("getMapperFor failed because no mapper available for " + klazz.getName());
        }
        return mapper;
    }

    @Override
    public <E extends Entity> Mapper<E> getMapper(String name) throws DatabaseException {
        Mapper<? extends Entity> mapper = this.mappers.get(name);
        if (mapper == null) {
            throw new DatabaseException("getMapperFor failed because no mapper available for " + name);
        }
        return mapper;
    }

    @Override
    public List<String> getEntityNames() {
        ArrayList<String> entities = new ArrayList<String>();
        entities.addAll(this.mappers.keySet());
        return entities;
    }

    @Override
    public <E extends Entity> List<E> toList(Class<E> klazz, TupleReader reader, int limit) throws DatabaseException {
        return this.getMapperFor(klazz).toList(reader, limit);
    }

    protected <E extends Entity> Class<E> getClassForEntity(E entity) {
        return entity.getClass();
    }

    @Override
    public <E extends Entity> String createFindSql(Class<E> entityClass, QueryRule ... rules) throws DatabaseException {
        return this.getMapperFor(entityClass).createFindSqlInclRules(rules);
    }

    @Override
    public File getFilesource() {
        return this.fileSource;
    }

    @Override
    public Login getLogin() {
        return this.login;
    }

    @Override
    public void setLogin(Login login) {
        this.login = login;
    }

    @Override
    public List<Class<? extends Entity>> getEntityClasses() {
        ArrayList<Class<? extends Entity>> classes = new ArrayList<Class<? extends Entity>>();
        try {
            for (String klazz : this.getEntityNames()) {
                classes.add(Class.forName(klazz));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return classes;
    }

    @Override
    public Class<? extends Entity> getClassForName(String simpleName) {
        for (Class<? extends Entity> c : this.getEntityClasses()) {
            if (!c.getSimpleName().equalsIgnoreCase(simpleName)) continue;
            return c;
        }
        return null;
    }

    @Override
    public <E extends Entity> List<E> search(Class<E> entityClass, String searchString) throws DatabaseException {
        return this.find(entityClass, new QueryRule(QueryRule.Operator.SEARCH, searchString));
    }

    @Override
    public <E extends Entity> List<? extends Entity> load(Class<E> superClass, List<E> entities) throws DatabaseException {
        ArrayList<Entity> result = new ArrayList<Entity>();
        for (Entity e : entities) {
            if (e.get("__Type").equals(superClass.getSimpleName())) {
                result.add(e);
                continue;
            }
            if (superClass.isInstance(e)) {
                Class<? extends Entity> klazz = this.getClassForName(e.get("__Type").toString());
                Entity r = this.findById(klazz, e.get(e.getIdField()));
                result.add(r);
                continue;
            }
            result.add(e);
        }
        return result;
    }

    @Override
    public <E extends Entity> Class<E> getEntityClass(E entity) {
        if (entity != null) {
            return entity.getClass();
        }
        return null;
    }

    @Override
    public <E extends Entity> Class<E> getEntityClass(List<E> entities) {
        for (Entity e : entities) {
            if (e == null) continue;
            return e.getClass();
        }
        return null;
    }
}

