/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.fieldtypes;

import java.text.ParseException;
import org.molgenis.MolgenisFieldTypes;
import org.molgenis.fieldtypes.FieldType;
import org.molgenis.framework.ui.html.HtmlInput;
import org.molgenis.framework.ui.html.HtmlInputException;
import org.molgenis.framework.ui.html.HyperlinkInput;
import org.molgenis.model.MolgenisModelException;

public class HyperlinkField
extends FieldType {
    private static final long serialVersionUID = 1L;

    @Override
    public String getJavaPropertyType() {
        return "String";
    }

    @Override
    public String getJavaAssignment(String value) {
        if (value == null || value.equals("")) {
            return "null";
        }
        return "\"" + value + "\"";
    }

    @Override
    public String getJavaPropertyDefault() {
        return this.getJavaAssignment(this.f.getDefaultValue());
    }

    @Override
    public String getMysqlType() throws MolgenisModelException {
        return "VARCHAR(255)";
    }

    @Override
    public String getOracleType() throws MolgenisModelException {
        return "VARCHAR2(255)";
    }

    @Override
    public String getHsqlType() {
        return "TEXT";
    }

    @Override
    public String getXsdType() {
        return "url";
    }

    @Override
    public String getFormatString() {
        return "%s";
    }

    @Override
    public HtmlInput<?> createInput(String name, String xrefEntityClassName) throws HtmlInputException {
        return new HyperlinkInput(name);
    }

    @Override
    public String getCppPropertyType() throws MolgenisModelException {
        return "string";
    }

    @Override
    public String getCppJavaPropertyType() {
        return "Ljava/lang/String;";
    }

    @Override
    public Class<?> getJavaType() {
        return String.class;
    }

    @Override
    public String getTypedValue(String value) throws ParseException {
        return value;
    }

    @Override
    public MolgenisFieldTypes.FieldTypeEnum getEnumType() {
        return MolgenisFieldTypes.FieldTypeEnum.HYPERLINK;
    }
}

