/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.variant.vcf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.broad.tribble.TribbleException;
import org.broad.tribble.readers.LineReader;
import org.broadinstitute.variant.vcf.AbstractVCFCodec;
import org.broadinstitute.variant.vcf.VCFHeaderVersion;

public class VCF3Codec
extends AbstractVCFCodec {
    public static final String VCF3_MAGIC_HEADER = "##fileformat=VCFv3";

    @Override
    public Object readHeader(LineReader lineReader) {
        ArrayList<String> arrayList = new ArrayList<String>();
        VCFHeaderVersion vCFHeaderVersion = null;
        try {
            String string;
            boolean bl = false;
            while ((string = lineReader.readLine()) != null) {
                ++this.lineNo;
                if (string.startsWith("##")) {
                    String[] stringArray = string.substring(2).split("=");
                    if (stringArray.length == 2 && VCFHeaderVersion.isFormatString(stringArray[0])) {
                        if (!VCFHeaderVersion.isVersionString(stringArray[1])) {
                            throw new TribbleException.InvalidHeader(stringArray[1] + " is not a supported version");
                        }
                        bl = true;
                        vCFHeaderVersion = VCFHeaderVersion.toHeaderVersion(stringArray[1]);
                        if (vCFHeaderVersion != VCFHeaderVersion.VCF3_3 && vCFHeaderVersion != VCFHeaderVersion.VCF3_2) {
                            throw new TribbleException.InvalidHeader("This codec is strictly for VCFv3 and does not support " + stringArray[1]);
                        }
                    }
                    arrayList.add(string);
                    continue;
                }
                if (string.startsWith("#")) {
                    if (!bl) {
                        throw new TribbleException.InvalidHeader("We never saw a header line specifying VCF version");
                    }
                    arrayList.add(string);
                    return super.parseHeaderFromLines(arrayList, vCFHeaderVersion);
                }
                throw new TribbleException.InvalidHeader("We never saw the required CHROM header line (starting with one #) for the input VCF file");
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException("IO Exception ", iOException);
        }
        throw new TribbleException.InvalidHeader("We never saw the required CHROM header line (starting with one #) for the input VCF file");
    }

    @Override
    protected List<String> parseFilters(String string) {
        if (string.equals(".")) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string.equals("0")) {
            return new ArrayList<String>(arrayList);
        }
        if (string.length() == 0) {
            this.generateException("The VCF specification requires a valid filter status");
        }
        if (this.filterHash.containsKey(string)) {
            return new ArrayList<String>((Collection)this.filterHash.get(string));
        }
        if (string.indexOf(";") == -1) {
            arrayList.add(string);
        } else {
            arrayList.addAll(Arrays.asList(string.split(";")));
        }
        this.filterHash.put(string, arrayList);
        return arrayList;
    }

    @Override
    public boolean canDecode(String string) {
        return VCF3Codec.canDecodeFile(string, VCF3_MAGIC_HEADER);
    }
}

