/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.variant.variantcontext.writer;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.sf.samtools.SAMSequenceDictionary;
import org.broad.tribble.TribbleException;
import org.broad.tribble.util.ParsingUtils;
import org.broadinstitute.variant.variantcontext.Allele;
import org.broadinstitute.variant.variantcontext.Genotype;
import org.broadinstitute.variant.variantcontext.GenotypeBuilder;
import org.broadinstitute.variant.variantcontext.GenotypesContext;
import org.broadinstitute.variant.variantcontext.LazyGenotypesContext;
import org.broadinstitute.variant.variantcontext.VariantContext;
import org.broadinstitute.variant.variantcontext.VariantContextBuilder;
import org.broadinstitute.variant.variantcontext.writer.IndexingVariantContextWriter;
import org.broadinstitute.variant.variantcontext.writer.IntGenotypeFieldAccessors;
import org.broadinstitute.variant.vcf.VCFCompoundHeaderLine;
import org.broadinstitute.variant.vcf.VCFHeader;
import org.broadinstitute.variant.vcf.VCFHeaderLine;
import org.broadinstitute.variant.vcf.VCFHeaderLineCount;
import org.broadinstitute.variant.vcf.VCFHeaderVersion;
import org.broadinstitute.variant.vcf.VCFInfoHeaderLine;

class VCFWriter
extends IndexingVariantContextWriter {
    private static final String VERSION_LINE = "##" + VCFHeaderVersion.VCF4_1.getFormatString() + "=" + VCFHeaderVersion.VCF4_1.getVersionString();
    protected final boolean doNotWriteGenotypes;
    protected VCFHeader mHeader = null;
    private final boolean allowMissingFieldsInHeader;
    private static final int INITIAL_BUFFER_SIZE = 16384;
    private final ByteArrayOutputStream lineBuffer = new ByteArrayOutputStream(16384);
    private final Writer writer;
    private final Charset charset;
    private IntGenotypeFieldAccessors intGenotypeFieldAccessors = new IntGenotypeFieldAccessors();
    private static final String QUAL_FORMAT_STRING = "%.2f";
    private static final String QUAL_FORMAT_EXTENSION_TO_TRIM = ".00";

    public VCFWriter(File file, OutputStream outputStream, SAMSequenceDictionary sAMSequenceDictionary, boolean bl, boolean bl2, boolean bl3) {
        super(VCFWriter.writerName(file, outputStream), file, outputStream, sAMSequenceDictionary, bl);
        this.doNotWriteGenotypes = bl2;
        this.allowMissingFieldsInHeader = bl3;
        this.charset = Charset.forName("ISO-8859-1");
        this.writer = new OutputStreamWriter((OutputStream)this.lineBuffer, this.charset);
    }

    private void write(String string) throws IOException {
        this.writer.write(string);
    }

    private void flushBuffer() throws IOException {
        this.writer.flush();
        this.getOutputStream().write(this.lineBuffer.toByteArray());
        this.lineBuffer.reset();
    }

    @Override
    public void writeHeader(VCFHeader vCFHeader) {
        try {
            this.mHeader = VCFWriter.writeHeader(vCFHeader, this.writer, this.doNotWriteGenotypes, VCFWriter.getVersionLine(), this.getStreamName());
            this.flushBuffer();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Couldn't write file " + this.getStreamName(), iOException);
        }
    }

    public static String getVersionLine() {
        return VERSION_LINE;
    }

    public static VCFHeader writeHeader(VCFHeader vCFHeader, Writer writer, boolean bl, String string, String string2) {
        vCFHeader = bl ? new VCFHeader(vCFHeader.getMetaDataInSortedOrder()) : vCFHeader;
        try {
            writer.write(string + "\n");
            for (VCFHeaderLine object : vCFHeader.getMetaDataInSortedOrder()) {
                if (VCFHeaderVersion.isFormatString(object.getKey())) continue;
                writer.write("##");
                writer.write(object.toString());
                writer.write("\n");
            }
            writer.write("#");
            boolean bl2 = true;
            for (VCFHeader.HEADER_FIELDS hEADER_FIELDS : vCFHeader.getHeaderFields()) {
                if (bl2) {
                    bl2 = false;
                } else {
                    writer.write("\t");
                }
                writer.write(hEADER_FIELDS.toString());
            }
            if (vCFHeader.hasGenotypingData()) {
                writer.write("\t");
                writer.write("FORMAT");
                for (String string3 : vCFHeader.getGenotypeSamples()) {
                    writer.write("\t");
                    writer.write(string3);
                }
            }
            writer.write("\n");
            writer.flush();
        }
        catch (IOException iOException) {
            throw new RuntimeException("IOException writing the VCF header to " + string2, iOException);
        }
        return vCFHeader;
    }

    @Override
    public void close() {
        try {
            this.writer.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unable to close " + this.getStreamName(), iOException);
        }
        super.close();
    }

    @Override
    public void add(VariantContext variantContext) {
        if (this.mHeader == null) {
            throw new IllegalStateException("The VCF Header must be written before records can be added: " + this.getStreamName());
        }
        if (this.doNotWriteGenotypes) {
            variantContext = new VariantContextBuilder(variantContext).noGenotypes().make();
        }
        try {
            Object object;
            Object object2;
            Object object3;
            super.add(variantContext);
            Map<Allele, String> map = VCFWriter.buildAlleleMap(variantContext);
            this.write(variantContext.getChr());
            this.write("\t");
            this.write(String.valueOf(variantContext.getStart()));
            this.write("\t");
            String string2 = variantContext.getID();
            this.write(string2);
            this.write("\t");
            String string3 = variantContext.getReference().getDisplayString();
            this.write(string3);
            this.write("\t");
            if (variantContext.isVariant()) {
                object3 = variantContext.getAlternateAllele(0);
                object2 = ((Allele)object3).getDisplayString();
                this.write((String)object2);
                for (int i = 1; i < variantContext.getAlternateAlleles().size(); ++i) {
                    object3 = variantContext.getAlternateAllele(i);
                    object2 = ((Allele)object3).getDisplayString();
                    this.write(",");
                    this.write((String)object2);
                }
            } else {
                this.write(".");
            }
            this.write("\t");
            if (!variantContext.hasLog10PError()) {
                this.write(".");
            } else {
                this.write(this.formatQualValue(variantContext.getPhredScaledQual()));
            }
            this.write("\t");
            object3 = this.getFilterString(variantContext);
            this.write((String)object3);
            this.write("\t");
            object2 = new TreeMap();
            for (Map.Entry<String, Object> object4 : variantContext.getAttributes().entrySet()) {
                String string;
                object = object4.getKey();
                if (!this.mHeader.hasInfoLine((String)object)) {
                    this.fieldIsMissingFromHeaderError(variantContext, (String)object, "INFO");
                }
                if ((string = VCFWriter.formatVCFField(object4.getValue())) == null) continue;
                object2.put(object, string);
            }
            this.writeInfoString((Map<String, String>)object2);
            GenotypesContext genotypesContext = variantContext.getGenotypes();
            if (genotypesContext.isLazyWithData() && ((LazyGenotypesContext)genotypesContext).getUnparsedGenotypeData() instanceof String) {
                this.write("\t");
                this.write(((LazyGenotypesContext)genotypesContext).getUnparsedGenotypeData().toString());
            } else {
                List<String> list = VCFWriter.calcVCFGenotypeKeys(variantContext, this.mHeader);
                if (!list.isEmpty()) {
                    for (String string : list) {
                        if (this.mHeader.hasFormatLine(string)) continue;
                        this.fieldIsMissingFromHeaderError(variantContext, string, "FORMAT");
                    }
                    object = ParsingUtils.join(":", list);
                    this.write("\t");
                    this.write((String)object);
                    this.addGenotypeData(variantContext, map, list);
                }
            }
            this.write("\n");
            this.flushBuffer();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unable to write the VCF object to " + this.getStreamName(), iOException);
        }
    }

    private static Map<Allele, String> buildAlleleMap(VariantContext variantContext) {
        HashMap<Allele, String> hashMap = new HashMap<Allele, String>(variantContext.getAlleles().size() + 1);
        hashMap.put(Allele.NO_CALL, ".");
        List<Allele> list = variantContext.getAlleles();
        for (int i = 0; i < list.size(); ++i) {
            hashMap.put(list.get(i), String.valueOf(i));
        }
        return hashMap;
    }

    private final String getFilterString(VariantContext variantContext) {
        if (variantContext.isFiltered()) {
            for (String string : variantContext.getFilters()) {
                if (this.mHeader.hasFilterLine(string)) continue;
                this.fieldIsMissingFromHeaderError(variantContext, string, "FILTER");
            }
            return ParsingUtils.join(";", ParsingUtils.sortList(variantContext.getFilters()));
        }
        if (variantContext.filtersWereApplied()) {
            return "PASS";
        }
        return ".";
    }

    private String formatQualValue(double d) {
        String string = String.format(QUAL_FORMAT_STRING, d);
        if (string.endsWith(QUAL_FORMAT_EXTENSION_TO_TRIM)) {
            string = string.substring(0, string.length() - QUAL_FORMAT_EXTENSION_TO_TRIM.length());
        }
        return string;
    }

    private void writeInfoString(Map<String, String> map) throws IOException {
        if (map.isEmpty()) {
            this.write(".");
            return;
        }
        boolean bl = true;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            VCFInfoHeaderLine vCFInfoHeaderLine;
            if (bl) {
                bl = false;
            } else {
                this.write(";");
            }
            String string = entry.getKey();
            this.write(string);
            if (entry.getValue().equals("") || (vCFInfoHeaderLine = this.mHeader.getInfoHeaderLine(string)) != null && vCFInfoHeaderLine.getCountType() == VCFHeaderLineCount.INTEGER && vCFInfoHeaderLine.getCount() == 0) continue;
            this.write("=");
            this.write(entry.getValue());
        }
    }

    private void addGenotypeData(VariantContext variantContext, Map<Allele, String> map, List<String> list) throws IOException {
        int n = variantContext.getMaxPloidy(2);
        for (String string : this.mHeader.getGenotypeSamples()) {
            int n2;
            this.write("\t");
            Genotype genotype = variantContext.getGenotype(string);
            if (genotype == null) {
                genotype = GenotypeBuilder.createMissing(string, n);
            }
            ArrayList<String> arrayList = new ArrayList<String>(list.size());
            for (String string2 : list) {
                String string3;
                if (string2.equals("GT")) {
                    if (!genotype.isAvailable()) {
                        throw new IllegalStateException("GTs cannot be missing for some samples if they are available for others in the record");
                    }
                    this.writeAllele(genotype.getAllele(0), map);
                    for (int i = 1; i < genotype.getPloidy(); ++i) {
                        this.write(genotype.isPhased() ? "|" : "/");
                        this.writeAllele(genotype.getAllele(i), map);
                    }
                    continue;
                }
                if (string2.equals("FT")) {
                    string3 = genotype.isFiltered() ? genotype.getFilters() : "PASS";
                } else {
                    int n3;
                    Comparable comparable;
                    Object object;
                    IntGenotypeFieldAccessors.Accessor accessor = this.intGenotypeFieldAccessors.getAccessor(string2);
                    if (accessor != null) {
                        object = accessor.getValues(genotype);
                        if (object == null) {
                            string3 = ".";
                        } else if (((int[])object).length == 1) {
                            string3 = Integer.toString(object[0]);
                        } else {
                            comparable = new StringBuilder();
                            ((StringBuilder)comparable).append(object[0]);
                            for (n3 = 1; n3 < ((Object)object).length; ++n3) {
                                ((StringBuilder)comparable).append(",");
                                ((StringBuilder)comparable).append((int)object[n3]);
                            }
                            string3 = ((StringBuilder)comparable).toString();
                        }
                    } else {
                        object = genotype.hasExtendedAttribute(string2) ? genotype.getExtendedAttribute(string2) : ".";
                        comparable = this.mHeader.getFormatHeaderLine(string2);
                        if (comparable != null && (n3 = ((VCFCompoundHeaderLine)comparable).getCount(variantContext)) > 1 && object.equals(".")) {
                            StringBuilder stringBuilder = new StringBuilder(".");
                            for (int i = 1; i < n3; ++i) {
                                stringBuilder.append(",");
                                stringBuilder.append(".");
                            }
                            object = stringBuilder.toString();
                        }
                        string3 = VCFWriter.formatVCFField(object);
                    }
                }
                if (string3 == null) continue;
                arrayList.add(string3);
            }
            for (n2 = arrayList.size() - 1; n2 >= 0 && this.isMissingValue((String)arrayList.get(n2)); --n2) {
                arrayList.remove(n2);
            }
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                if (n2 > 0 || list.contains("GT")) {
                    this.write(":");
                }
                this.write((String)arrayList.get(n2));
            }
        }
    }

    private boolean isMissingValue(String string) {
        return VCFWriter.countOccurrences(".".charAt(0), string) + VCFWriter.countOccurrences(',', string) == string.length();
    }

    private void writeAllele(Allele allele, Map<Allele, String> map) throws IOException {
        String string = map.get(allele);
        if (string == null) {
            throw new TribbleException.InternalCodecException("Allele " + allele + " is not an allele in the variant context");
        }
        this.write(string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final String formatVCFDouble(double d) {
        String string;
        if (d < 1.0) {
            if (d < 0.01) {
                if (!(Math.abs(d) >= 1.0E-20)) return "0.00";
                string = "%.3e";
                return String.format(string, d);
            } else {
                string = "%.3f";
            }
            return String.format(string, d);
        } else {
            string = QUAL_FORMAT_STRING;
        }
        return String.format(string, d);
    }

    public static String formatVCFField(Object object) {
        String string;
        if (object == null) {
            string = ".";
        } else if (object instanceof Double) {
            string = VCFWriter.formatVCFDouble((Double)object);
        } else if (object instanceof Boolean) {
            string = (Boolean)object != false ? "" : null;
        } else if (object instanceof List) {
            string = VCFWriter.formatVCFField(((List)object).toArray());
        } else if (object.getClass().isArray()) {
            int n = Array.getLength(object);
            if (n == 0) {
                return VCFWriter.formatVCFField(null);
            }
            StringBuilder stringBuilder = new StringBuilder(VCFWriter.formatVCFField(Array.get(object, 0)));
            for (int i = 1; i < n; ++i) {
                stringBuilder.append(",");
                stringBuilder.append(VCFWriter.formatVCFField(Array.get(object, i)));
            }
            string = stringBuilder.toString();
        } else {
            string = object.toString();
        }
        return string;
    }

    public static List<String> calcVCFGenotypeKeys(VariantContext variantContext, VCFHeader vCFHeader) {
        HashSet<String> hashSet = new HashSet<String>();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        for (Object object2 : variantContext.getGenotypes()) {
            hashSet.addAll(((Genotype)object2).getExtendedAttributes().keySet());
            if (((Genotype)object2).isAvailable()) {
                bl = true;
            }
            if (((Genotype)object2).hasGQ()) {
                bl2 = true;
            }
            if (((Genotype)object2).hasDP()) {
                bl4 = true;
            }
            if (((Genotype)object2).hasAD()) {
                bl5 = true;
            }
            if (((Genotype)object2).hasPL()) {
                bl6 = true;
            }
            if (!((Genotype)object2).isFiltered()) continue;
            bl3 = true;
        }
        if (bl2) {
            hashSet.add("GQ");
        }
        if (bl4) {
            hashSet.add("DP");
        }
        if (bl5) {
            hashSet.add("AD");
        }
        if (bl6) {
            hashSet.add("PL");
        }
        if (bl3) {
            hashSet.add("FT");
        }
        Object object = ParsingUtils.sortList(new ArrayList(hashSet));
        if (bl) {
            Object object2;
            object2 = new ArrayList(object.size() + 1);
            object2.add("GT");
            object2.addAll(object);
            object = object2;
        }
        if (object.isEmpty() && vCFHeader.hasGenotypingData()) {
            return Collections.singletonList("GT");
        }
        return object;
    }

    private static int countOccurrences(char c, String string) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            n += string.charAt(i) == c ? 1 : 0;
        }
        return n;
    }

    private final void fieldIsMissingFromHeaderError(VariantContext variantContext, String string, String string2) {
        if (!this.allowMissingFieldsInHeader) {
            throw new IllegalStateException("Key " + string + " found in VariantContext field " + string2 + " at " + variantContext.getChr() + ":" + variantContext.getStart() + " but this key isn't defined in the VCFHeader.  We require all VCFs to have" + " complete VCF headers by default.");
        }
    }
}

