/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.util;

import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class AbstractIterator<E>
implements Iterator<E> {
    private E next;
    private boolean iterating = false;

    @Override
    public boolean hasNext() {
        if (!this.iterating) {
            this.next = this.advance();
            this.iterating = true;
        }
        return this.next != null;
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        E e = this.next;
        this.next = this.advance();
        return e;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove() not supported.");
    }

    protected abstract E advance();

    protected boolean isIterating() {
        return this.iterating;
    }
}

