/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.sam;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.picard.cmdline.CommandLineProgram;
import net.sf.picard.cmdline.PositionalArguments;
import net.sf.picard.cmdline.Usage;
import net.sf.samtools.NotPrimarySkippingIterator;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMProgramRecord;
import net.sf.samtools.SAMReadGroupRecord;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMSequenceRecord;

public class CompareSAMs
extends CommandLineProgram {
    @Usage
    public final String USAGE = "USAGE: CompareSAMS <SAMFile1> <SAMFile2>\nCompares the headers of the two input SAM or BAM files, and, if possible, the SAMRecords. For SAMRecords, compares only the readUnmapped flag, reference name, start position and strand. Reports the number of SAMRecords that match, differ in alignment, are mapped in only one input, or are missing in one of the files";
    @PositionalArguments(minElements=2, maxElements=2)
    public List<File> samFiles;
    private final SAMFileReader[] samReaders = new SAMFileReader[2];
    private boolean sequenceDictionariesDiffer;
    private int mappingsMatch = 0;
    private int unmappedBoth = 0;
    private int unmappedLeft = 0;
    private int unmappedRight = 0;
    private int mappingsDiffer = 0;
    private int missingLeft = 0;
    private int missingRight = 0;
    private boolean areEqual;

    public static void main(String[] stringArray) {
        new CompareSAMs().instanceMainWithExit(stringArray);
    }

    @Override
    protected int doWork() {
        for (int i = 0; i < this.samFiles.size(); ++i) {
            this.samReaders[i] = new SAMFileReader(this.samFiles.get(i));
        }
        this.areEqual = this.compareHeaders();
        this.areEqual = this.compareAlignments() && this.areEqual;
        this.printReport();
        if (!this.areEqual) {
            System.out.println("SAM files differ.");
        } else {
            System.out.println("SAM files match.");
        }
        return 0;
    }

    private void printReport() {
        System.out.println("Match\t" + this.mappingsMatch);
        System.out.println("Differ\t" + this.mappingsDiffer);
        System.out.println("Unmapped_both\t" + this.unmappedBoth);
        System.out.println("Unmapped_left\t" + this.unmappedLeft);
        System.out.println("Unmapped_right\t" + this.unmappedRight);
        System.out.println("Missing_left\t" + this.missingLeft);
        System.out.println("Missing_right\t" + this.missingRight);
    }

    private boolean compareAlignments() {
        if (!this.compareValues(this.samReaders[0].getFileHeader().getSortOrder(), this.samReaders[1].getFileHeader().getSortOrder(), "Sort Order")) {
            System.out.println("Cannot compare alignments if sort orders differ.");
            return false;
        }
        switch (this.samReaders[0].getFileHeader().getSortOrder()) {
            case coordinate: {
                if (this.sequenceDictionariesDiffer) {
                    System.out.println("Cannot compare coordinate-sorted SAM files because sequence dictionaries differ.");
                    return false;
                }
                return this.compareCoordinateSortedAlignments();
            }
            case queryname: {
                return this.compareQueryNameSortedAlignments();
            }
            case unsorted: {
                return this.compareUnsortedAlignments();
            }
        }
        assert (false);
        return false;
    }

    private boolean compareCoordinateSortedAlignments() {
        SAMRecord sAMRecord;
        Object object;
        Object object3;
        NotPrimarySkippingIterator notPrimarySkippingIterator = new NotPrimarySkippingIterator(this.samReaders[0].iterator());
        NotPrimarySkippingIterator notPrimarySkippingIterator2 = new NotPrimarySkippingIterator(this.samReaders[1].iterator());
        HashMap<String, SAMRecord> hashMap = new HashMap<String, SAMRecord>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        boolean bl = true;
        while (notPrimarySkippingIterator.hasCurrent()) {
            if (!notPrimarySkippingIterator2.hasCurrent()) {
                while (notPrimarySkippingIterator.hasCurrent()) {
                    object3 = notPrimarySkippingIterator.getCurrent();
                    SAMRecord sAMRecord2 = (SAMRecord)hashMap2.remove(((SAMRecord)object3).getReadName());
                    if (sAMRecord2 == null) {
                        ++this.missingRight;
                    } else {
                        this.tallyAlignmentRecords((SAMRecord)object3, sAMRecord2);
                    }
                    notPrimarySkippingIterator.advance();
                }
                break;
            }
            object3 = notPrimarySkippingIterator.getCurrent();
            HashMap<String, Object> object22 = new HashMap<String, Object>();
            object22.put(((SAMRecord)object3).getReadName(), object3);
            while (notPrimarySkippingIterator.advance() && this.compareAlignmentCoordinates((SAMRecord)object3, (SAMRecord)(object = notPrimarySkippingIterator.getCurrent())) == 0) {
                object22.put(((SAMRecord)object).getReadName(), object);
            }
            while (notPrimarySkippingIterator2.hasCurrent() && this.compareAlignmentCoordinates((SAMRecord)object3, notPrimarySkippingIterator2.getCurrent()) > 0) {
                object = notPrimarySkippingIterator2.getCurrent();
                hashMap2.put(((SAMRecord)object).getReadName(), object);
                notPrimarySkippingIterator2.advance();
            }
            while (notPrimarySkippingIterator2.hasCurrent() && this.compareAlignmentCoordinates((SAMRecord)object3, notPrimarySkippingIterator2.getCurrent()) == 0) {
                object = notPrimarySkippingIterator2.getCurrent();
                sAMRecord = (SAMRecord)object22.remove(((SAMRecord)object).getReadName());
                if (sAMRecord != null) {
                    bl = this.tallyAlignmentRecords(sAMRecord, (SAMRecord)object) && bl;
                } else {
                    hashMap2.put(((SAMRecord)object).getReadName(), object);
                }
                notPrimarySkippingIterator2.advance();
            }
            object = object22.values().iterator();
            while (object.hasNext()) {
                sAMRecord = (SAMRecord)object.next();
                hashMap.put(sAMRecord.getReadName(), sAMRecord);
            }
        }
        while (notPrimarySkippingIterator2.hasCurrent()) {
            object3 = notPrimarySkippingIterator2.getCurrent();
            SAMRecord sAMRecord3 = (SAMRecord)hashMap.remove(((SAMRecord)object3).getReadName());
            if (sAMRecord3 != null) {
                this.tallyAlignmentRecords(sAMRecord3, (SAMRecord)object3);
            } else {
                ++this.missingLeft;
            }
            notPrimarySkippingIterator2.advance();
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            object = (String)entry.getKey();
            sAMRecord = (SAMRecord)entry.getValue();
            SAMRecord sAMRecord4 = (SAMRecord)hashMap2.remove(object);
            if (sAMRecord4 == null) {
                ++this.missingRight;
                continue;
            }
            this.tallyAlignmentRecords(sAMRecord, sAMRecord4);
        }
        this.missingLeft += hashMap2.size();
        if (bl && (this.missingLeft > 0 || this.missingRight > 0 || this.mappingsDiffer > 0 || this.unmappedLeft > 0 || this.unmappedRight > 0)) {
            bl = false;
        }
        return bl;
    }

    private int compareAlignmentCoordinates(SAMRecord sAMRecord, SAMRecord sAMRecord2) {
        String string = sAMRecord.getReferenceName();
        String string2 = sAMRecord2.getReferenceName();
        if (string == null && string2 == null) {
            return 0;
        }
        if (string == null) {
            return 1;
        }
        if (string2 == null) {
            return -1;
        }
        int n = this.samReaders[0].getFileHeader().getSequenceIndex(string);
        int n2 = this.samReaders[0].getFileHeader().getSequenceIndex(string2);
        assert (n >= 0);
        assert (n2 >= 0);
        if (n != n2) {
            return n - n2;
        }
        return sAMRecord.getAlignmentStart() - sAMRecord2.getAlignmentStart();
    }

    private boolean compareQueryNameSortedAlignments() {
        NotPrimarySkippingIterator notPrimarySkippingIterator = new NotPrimarySkippingIterator(this.samReaders[0].iterator());
        NotPrimarySkippingIterator notPrimarySkippingIterator2 = new NotPrimarySkippingIterator(this.samReaders[1].iterator());
        boolean bl = true;
        while (notPrimarySkippingIterator.hasCurrent()) {
            if (!notPrimarySkippingIterator2.hasCurrent()) {
                this.missingRight += this.countRemaining(notPrimarySkippingIterator);
                return false;
            }
            int n = notPrimarySkippingIterator.getCurrent().getReadName().compareTo(notPrimarySkippingIterator2.getCurrent().getReadName());
            if (n < 0) {
                ++this.missingRight;
                notPrimarySkippingIterator.advance();
                bl = false;
                continue;
            }
            if (n > 0) {
                ++this.missingLeft;
                notPrimarySkippingIterator2.advance();
                bl = false;
                continue;
            }
            if (!this.tallyAlignmentRecords(notPrimarySkippingIterator.getCurrent(), notPrimarySkippingIterator2.getCurrent())) {
                bl = false;
            }
            notPrimarySkippingIterator.advance();
            notPrimarySkippingIterator2.advance();
        }
        if (notPrimarySkippingIterator2.hasCurrent()) {
            this.missingLeft += this.countRemaining(notPrimarySkippingIterator2);
            return false;
        }
        return bl;
    }

    private boolean compareUnsortedAlignments() {
        NotPrimarySkippingIterator notPrimarySkippingIterator = new NotPrimarySkippingIterator(this.samReaders[0].iterator());
        NotPrimarySkippingIterator notPrimarySkippingIterator2 = new NotPrimarySkippingIterator(this.samReaders[1].iterator());
        boolean bl = true;
        while (notPrimarySkippingIterator.hasCurrent()) {
            if (!notPrimarySkippingIterator2.hasCurrent()) {
                this.missingRight += this.countRemaining(notPrimarySkippingIterator);
                return false;
            }
            SAMRecord sAMRecord = notPrimarySkippingIterator.getCurrent();
            SAMRecord sAMRecord2 = notPrimarySkippingIterator2.getCurrent();
            if (!this.compareValues(sAMRecord.getReadName(), sAMRecord2.getReadName(), "Read names")) {
                System.out.println("Read names cease agreeing in unsorted SAM files .  Comparison aborting.");
            }
            bl = this.tallyAlignmentRecords(sAMRecord, sAMRecord2) && bl;
            notPrimarySkippingIterator.advance();
            notPrimarySkippingIterator2.advance();
        }
        if (notPrimarySkippingIterator2.hasCurrent()) {
            this.missingLeft += this.countRemaining(notPrimarySkippingIterator2);
            return false;
        }
        return bl;
    }

    private int countRemaining(NotPrimarySkippingIterator notPrimarySkippingIterator) {
        int n = 0;
        while (notPrimarySkippingIterator.hasCurrent()) {
            notPrimarySkippingIterator.advance();
            ++n;
        }
        return n;
    }

    private boolean tallyAlignmentRecords(SAMRecord sAMRecord, SAMRecord sAMRecord2) {
        boolean bl;
        assert (sAMRecord.getReadName().equals(sAMRecord2.getReadName()));
        if (sAMRecord.getReadUnmappedFlag() && sAMRecord2.getReadUnmappedFlag()) {
            ++this.unmappedBoth;
            return true;
        }
        if (sAMRecord.getReadUnmappedFlag()) {
            ++this.unmappedLeft;
            return false;
        }
        if (sAMRecord2.getReadUnmappedFlag()) {
            ++this.unmappedRight;
            return false;
        }
        boolean bl2 = bl = sAMRecord.getReferenceName().equals(sAMRecord2.getReferenceName()) && sAMRecord.getAlignmentStart() == sAMRecord2.getAlignmentStart() && sAMRecord.getReadNegativeStrandFlag() == sAMRecord.getReadNegativeStrandFlag();
        if (!bl) {
            ++this.mappingsDiffer;
        } else {
            ++this.mappingsMatch;
        }
        return bl;
    }

    private boolean compareHeaders() {
        SAMFileHeader sAMFileHeader = this.samReaders[0].getFileHeader();
        SAMFileHeader sAMFileHeader2 = this.samReaders[1].getFileHeader();
        boolean bl = this.compareValues(sAMFileHeader.getVersion(), sAMFileHeader2.getVersion(), "File format version");
        bl = this.compareValues(sAMFileHeader.getCreator(), sAMFileHeader2.getCreator(), "File creator") && bl;
        boolean bl2 = bl = this.compareValues(sAMFileHeader.getAttribute("SO"), sAMFileHeader2.getAttribute("SO"), "Sort order") && bl;
        if (!this.compareSequenceDictionaries(sAMFileHeader, sAMFileHeader2)) {
            bl = false;
            this.sequenceDictionariesDiffer = true;
        }
        bl = this.compareReadGroups(sAMFileHeader, sAMFileHeader2) && bl;
        bl = this.compareProgramRecords(sAMFileHeader, sAMFileHeader2) && bl;
        return bl;
    }

    private boolean compareProgramRecords(SAMFileHeader sAMFileHeader, SAMFileHeader sAMFileHeader2) {
        List<SAMProgramRecord> list = sAMFileHeader.getProgramRecords();
        List<SAMProgramRecord> list2 = sAMFileHeader2.getProgramRecords();
        if (!this.compareValues(list.size(), list2.size(), "Number of program records")) {
            return false;
        }
        boolean bl = true;
        for (int i = 0; i < list.size(); ++i) {
            bl = this.compareProgramRecord(list.get(i), list2.get(i)) && bl;
        }
        return bl;
    }

    private boolean compareProgramRecord(SAMProgramRecord sAMProgramRecord, SAMProgramRecord sAMProgramRecord2) {
        String[] stringArray;
        if (sAMProgramRecord == null && sAMProgramRecord2 == null) {
            return true;
        }
        if (sAMProgramRecord == null) {
            this.reportDifference("null", sAMProgramRecord2.getProgramGroupId(), "Program Record");
            return false;
        }
        if (sAMProgramRecord2 == null) {
            this.reportDifference(sAMProgramRecord.getProgramGroupId(), "null", "Program Record");
            return false;
        }
        boolean bl = this.compareValues(sAMProgramRecord.getProgramGroupId(), sAMProgramRecord2.getProgramGroupId(), "Program Name");
        for (String string : stringArray = new String[]{"VN", "CL"}) {
            bl = this.compareValues(sAMProgramRecord.getAttribute(string), sAMProgramRecord2.getAttribute(string), string + " Program Record attribute") && bl;
        }
        return bl;
    }

    private boolean compareReadGroups(SAMFileHeader sAMFileHeader, SAMFileHeader sAMFileHeader2) {
        List<SAMReadGroupRecord> list = sAMFileHeader.getReadGroups();
        List<SAMReadGroupRecord> list2 = sAMFileHeader2.getReadGroups();
        if (!this.compareValues(list.size(), list2.size(), "Number of read groups")) {
            return false;
        }
        boolean bl = true;
        for (int i = 0; i < list.size(); ++i) {
            bl = this.compareReadGroup(list.get(i), list2.get(i)) && bl;
        }
        return bl;
    }

    private boolean compareReadGroup(SAMReadGroupRecord sAMReadGroupRecord, SAMReadGroupRecord sAMReadGroupRecord2) {
        String[] stringArray;
        boolean bl = this.compareValues(sAMReadGroupRecord.getReadGroupId(), sAMReadGroupRecord2.getReadGroupId(), "Read Group ID");
        bl = this.compareValues(sAMReadGroupRecord.getSample(), sAMReadGroupRecord2.getSample(), "Sample for read group " + sAMReadGroupRecord.getReadGroupId()) && bl;
        bl = this.compareValues(sAMReadGroupRecord.getLibrary(), sAMReadGroupRecord2.getLibrary(), "Library for read group " + sAMReadGroupRecord.getReadGroupId()) && bl;
        for (String string : stringArray = new String[]{"DS", "PU", "PI", "CN", "DT", "PL"}) {
            bl = this.compareValues(sAMReadGroupRecord.getAttribute(string), sAMReadGroupRecord2.getAttribute(string), string + " for read group " + sAMReadGroupRecord.getReadGroupId()) && bl;
        }
        return bl;
    }

    private boolean compareSequenceDictionaries(SAMFileHeader sAMFileHeader, SAMFileHeader sAMFileHeader2) {
        List<SAMSequenceRecord> list = sAMFileHeader.getSequenceDictionary().getSequences();
        List<SAMSequenceRecord> list2 = sAMFileHeader2.getSequenceDictionary().getSequences();
        if (list.size() != list2.size()) {
            this.reportDifference(list.size(), list2.size(), "Length of sequence dictionaries");
            return false;
        }
        boolean bl = true;
        for (int i = 0; i < list.size(); ++i) {
            bl = this.compareSequenceRecord(list.get(i), list2.get(i), i + 1) && bl;
        }
        return bl;
    }

    private boolean compareSequenceRecord(SAMSequenceRecord sAMSequenceRecord, SAMSequenceRecord sAMSequenceRecord2, int n) {
        if (!sAMSequenceRecord.getSequenceName().equals(sAMSequenceRecord2.getSequenceName())) {
            this.reportDifference(sAMSequenceRecord.getSequenceName(), sAMSequenceRecord2.getSequenceName(), "Name of sequence record " + n);
            return false;
        }
        boolean bl = this.compareValues(sAMSequenceRecord.getSequenceLength(), sAMSequenceRecord2.getSequenceLength(), "Length of sequence " + sAMSequenceRecord.getSequenceName());
        bl = this.compareValues(sAMSequenceRecord.getSpecies(), sAMSequenceRecord2.getSpecies(), "Species of sequence " + sAMSequenceRecord.getSequenceName()) && bl;
        bl = this.compareValues(sAMSequenceRecord.getAssembly(), sAMSequenceRecord2.getAssembly(), "Assembly of sequence " + sAMSequenceRecord.getSequenceName()) && bl;
        bl = this.compareValues(sAMSequenceRecord.getAttribute("M5"), sAMSequenceRecord2.getAttribute("M5"), "MD5 of sequence " + sAMSequenceRecord.getSequenceName()) && bl;
        bl = this.compareValues(sAMSequenceRecord.getAttribute("UR"), sAMSequenceRecord2.getAttribute("UR"), "URI of sequence " + sAMSequenceRecord.getSequenceName()) && bl;
        return bl;
    }

    private <T> boolean compareValues(T t, T t2, String string) {
        if (t == null) {
            if (t2 == null) {
                return true;
            }
            this.reportDifference(t, t2, string);
            return false;
        }
        if (t2 == null) {
            this.reportDifference(t, t2, string);
            return false;
        }
        if (!t.equals(t2)) {
            this.reportDifference(t, t2, string);
            return false;
        }
        return true;
    }

    private void reportDifference(String string, String string2, String string3) {
        System.out.println(string3 + " differs.");
        System.out.println(this.samFiles.get(0) + ": " + string);
        System.out.println(this.samFiles.get(1) + ": " + string2);
    }

    private void reportDifference(Object object, Object object2, String string) {
        if (object == null) {
            object = "null";
        }
        if (object2 == null) {
            object2 = "null";
        }
        this.reportDifference(object.toString(), object2.toString(), string);
    }

    public int getMappingsMatch() {
        return this.mappingsMatch;
    }

    public int getUnmappedBoth() {
        return this.unmappedBoth;
    }

    public int getUnmappedLeft() {
        return this.unmappedLeft;
    }

    public int getUnmappedRight() {
        return this.unmappedRight;
    }

    public int getMappingsDiffer() {
        return this.mappingsDiffer;
    }

    public int getMissingLeft() {
        return this.missingLeft;
    }

    public int getMissingRight() {
        return this.missingRight;
    }

    public boolean areEqual() {
        return this.areEqual;
    }
}

