/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import net.sf.picard.PicardException;
import net.sf.picard.cmdline.CommandLineProgram;
import net.sf.picard.cmdline.Option;
import net.sf.picard.cmdline.Usage;
import net.sf.picard.illumina.IlluminaBasecallsToSamConverter;
import net.sf.picard.illumina.parser.ClusterData;
import net.sf.picard.illumina.parser.IlluminaDataProvider;
import net.sf.picard.illumina.parser.IlluminaDataProviderFactory;
import net.sf.picard.illumina.parser.IlluminaDataType;
import net.sf.picard.illumina.parser.ReadStructure;
import net.sf.picard.io.IoUtil;
import net.sf.picard.util.CollectionUtil;
import net.sf.picard.util.FileChannelJDKBugWorkAround;
import net.sf.picard.util.IlluminaUtil;
import net.sf.picard.util.Log;
import net.sf.picard.util.ProgressLogger;
import net.sf.picard.util.TabbedTextFileWithHeaderParser;
import net.sf.samtools.BAMRecordCodec;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileWriter;
import net.sf.samtools.SAMFileWriterFactory;
import net.sf.samtools.SAMReadGroupRecord;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMRecordQueryNameComparator;
import net.sf.samtools.util.Iso8601Date;
import net.sf.samtools.util.PeekIterator;
import net.sf.samtools.util.SortingCollection;
import net.sf.samtools.util.StringUtil;

public class IlluminaBasecallsToSam
extends CommandLineProgram {
    @Usage
    public String USAGE = this.getStandardUsagePreamble() + "Generate a SAM or BAM file from data in an Illumina basecalls output directory.\n";
    @Option(doc="The basecalls directory. ", shortName="B")
    public File BASECALLS_DIR;
    @Option(doc="Lane number. ", shortName="L")
    public Integer LANE;
    @Option(doc="Deprecated (use LIBRARY_PARAMS).  The output SAM or BAM file. Format is determined by extension.", shortName="O", mutex={"BARCODE_PARAMS", "LIBRARY_PARAMS"})
    public File OUTPUT;
    @Option(doc="The barcode of the run.  Prefixed to read names.")
    public String RUN_BARCODE;
    @Option(doc="Deprecated (use LIBRARY_PARAMS).  The name of the sequenced sample", shortName="ALIAS", mutex={"BARCODE_PARAMS", "LIBRARY_PARAMS"})
    public String SAMPLE_ALIAS;
    @Option(doc="ID used to link RG header record with RG tag in SAM record.  If these are unique in SAM files that get merged, merge performance is better.  If not specified, READ_GROUP_ID will be set to <first 5 chars of RUN_BARCODE>.<LANE> .", shortName="RG", optional=true)
    public String READ_GROUP_ID;
    @Option(doc="Deprecated (use LIBRARY_PARAMS).  The name of the sequenced library", shortName="LIB", optional=true, mutex={"BARCODE_PARAMS", "LIBRARY_PARAMS"})
    public String LIBRARY_NAME;
    @Option(doc="The name of the sequencing center that produced the reads.  Used to set the RG.CN tag.", optional=true)
    public String SEQUENCING_CENTER = "BI";
    @Option(doc="The start date of the run.", optional=true)
    public Date RUN_START_DATE;
    @Option(doc="The name of the sequencing technology that produced the read.", optional=true)
    public String PLATFORM = "illumina";
    @Option(doc="A description of the logical structure of clusters in an Illumina Run, i.e. a description of the structure IlluminaBasecallsToSam assumes the  data to be in. It should consist of integer/character pairs describing the number of cycles and the type of those cycles (B for Barcode, T for Template, and S for skip).  E.g. If the input data consists of 80 base clusters and we provide a read structure of \"36T8B8S28T\" then, before being converted to SAM records those bases will be split into 4 reads where read one consists of 36 cycles of template, read two consists of 8 cycles of barcode, read three will be an 8 base read of skipped cycles and read four is another 28 cycle template read.  The read consisting of skipped cycles would NOT be included in output SAM/BAM file read groups.", shortName="RS")
    public String READ_STRUCTURE;
    @Option(doc="Deprecated (use LIBRARY_PARAMS).  Tab-separated file for creating all output BAMs for barcoded run with single IlluminaBasecallsToSam invocation.  Columns are BARCODE, OUTPUT, SAMPLE_ALIAS, and LIBRARY_NAME.  Row with BARCODE=N is used to specify a file for no barcode match", mutex={"OUTPUT", "SAMPLE_ALIAS", "LIBRARY_NAME", "LIBRARY_PARAMS"})
    public File BARCODE_PARAMS;
    @Option(doc="Tab-separated file for creating all output BAMs for a lane with single IlluminaBasecallsToSam invocation.  The columns are OUTPUT, SAMPLE_ALIAS, and LIBRARY_NAME, BARCODE_1, BARCODE_2 ... BARCODE_X where X = number of barcodes per cluster (optional).  Row with BARCODE_1 set to 'N' is used to specify a file for no barcode match.  You may also provide any 2 letter RG header attributes (excluding PU, CN, PL, and DT)  as columns in this file and the values for those columns will be inserted into the RG tag for the BAM file created for a given row.", mutex={"OUTPUT", "SAMPLE_ALIAS", "LIBRARY_NAME", "BARCODE_PARAMS"})
    public File LIBRARY_PARAMS;
    @Option(doc="Which adapters to look for in the read.")
    public List<IlluminaUtil.IlluminaAdapterPair> ADAPTERS_TO_CHECK = new ArrayList<IlluminaUtil.IlluminaAdapterPair>(Arrays.asList(IlluminaUtil.IlluminaAdapterPair.INDEXED, IlluminaUtil.IlluminaAdapterPair.DUAL_INDEXED, IlluminaUtil.IlluminaAdapterPair.NEXTERA_V2, IlluminaUtil.IlluminaAdapterPair.FLUIDIGM));
    @Option(doc="The number of threads to run in parallel. If NUM_PROCESSORS = 0, number of cores is automatically set to the number of cores available on the machine. If NUM_PROCESSORS < 0, then the number of cores used will be the number available on the machine less NUM_PROCESSORS.")
    public Integer NUM_PROCESSORS = 0;
    @Option(doc="If set, this is the first tile to be processed (used for debugging).  Note that tiles are not processed in numerical order.", optional=true)
    public Integer FIRST_TILE;
    @Option(doc="If set, process no more than this many tiles (used for debugging).", optional=true)
    public Integer TILE_LIMIT;
    @Option(doc="If true, call System.gc() periodically.  This is useful in cases in which the -Xmx value passed is larger than the available memory.")
    public Boolean FORCE_GC = true;
    @Option(doc="Configure SortingCollections to store this many records before spilling to disk. For an indexed run, each SortingCollection gets this value/number of indices.")
    public int MAX_READS_IN_RAM_PER_TILE = 1200000;
    private final Map<String, SAMFileWriter> barcodeSamWriterMap = new HashMap<String, SAMFileWriter>();
    private IlluminaBasecallsToSamConverter converter;
    private IlluminaDataProviderFactory factory;
    private ReadStructure readStructure;
    private int numThreads;
    private final Comparator<SAMRecord> samRecordQueryNameComparator = new SAMRecordQueryNameComparator();
    private List<Integer> tiles;
    public static final IlluminaDataType[] DATA_TYPES_NO_BARCODE = new IlluminaDataType[]{IlluminaDataType.BaseCalls, IlluminaDataType.QualityScores, IlluminaDataType.Position, IlluminaDataType.PF};
    private static final IlluminaDataType[] DATA_TYPES_WITH_BARCODE = Arrays.copyOf(DATA_TYPES_NO_BARCODE, DATA_TYPES_NO_BARCODE.length + 1);
    private static final Log log = Log.getInstance(IlluminaBasecallsToSam.class);
    private final ProgressLogger readProgressLogger = new ProgressLogger(log, 1000000, "Read");
    private final ProgressLogger writeProgressLogger = new ProgressLogger(log, 1000000, "Write");
    private TimerTask gcTimerTask;
    public static final Comparator<Integer> TILE_NUMBER_COMPARATOR = new Comparator<Integer>(){

        @Override
        public int compare(Integer n, Integer n2) {
            String string = n.toString();
            String string2 = n2.toString();
            if (string.length() < string2.length()) {
                if (string2.startsWith(string)) {
                    return 1;
                }
            } else if (string2.length() < string.length() && string.startsWith(string2)) {
                return -1;
            }
            return string.compareTo(string2);
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int doWork() {
        this.initialize();
        try {
            this.doTileProcessing();
        }
        finally {
            this.finalise();
        }
        return 0;
    }

    private void finalise() {
        for (Map.Entry<String, SAMFileWriter> entry : this.barcodeSamWriterMap.entrySet()) {
            SAMFileWriter sAMFileWriter = entry.getValue();
            log.debug(String.format("Closing file for barcode %s.", entry.getKey()));
            sAMFileWriter.close();
        }
        try {
            this.gcTimerTask.cancel();
        }
        catch (Throwable throwable) {
            log.warn(throwable, "Ignoring exception stopping background GC thread.");
        }
    }

    private void initialize() {
        if (this.OUTPUT != null) {
            IoUtil.assertFileIsWritable(this.OUTPUT);
        }
        if (this.LIBRARY_PARAMS != null) {
            IoUtil.assertFileIsReadable(this.LIBRARY_PARAMS);
        }
        if (this.FORCE_GC.booleanValue()) {
            Timer timer = new Timer(true);
            this.gcTimerTask = new TimerTask(){

                @Override
                public void run() {
                    System.out.println("Before explicit GC, Runtime.totalMemory()=" + Runtime.getRuntime().totalMemory());
                    System.gc();
                    System.runFinalization();
                    System.out.println("After explicit GC, Runtime.totalMemory()=" + Runtime.getRuntime().totalMemory());
                }
            };
            timer.scheduleAtFixedRate(this.gcTimerTask, 300000L, 300000L);
        }
        this.readStructure = new ReadStructure(this.READ_STRUCTURE);
        this.factory = new IlluminaDataProviderFactory(this.BASECALLS_DIR, this.LANE, this.readStructure, IlluminaBasecallsToSam.getDataTypesFromReadStructure(this.readStructure));
        log.info("DONE_READING STRUCTURE IS " + this.readStructure.toString());
        this.tiles = new ArrayList<Integer>(this.factory.getAvailableTiles());
        Collections.sort(this.tiles, TILE_NUMBER_COMPARATOR);
        if (this.FIRST_TILE != null) {
            for (int i = 0; i < this.tiles.size(); ++i) {
                if (this.tiles.get(i).intValue() != this.FIRST_TILE.intValue()) continue;
                this.tiles = this.tiles.subList(i, this.tiles.size());
                break;
            }
            if (this.tiles.get(0).intValue() != this.FIRST_TILE.intValue()) {
                throw new PicardException("FIRST_TILE=" + this.FIRST_TILE + ", but that tile was not found.");
            }
        }
        if (this.TILE_LIMIT != null && this.tiles.size() > this.TILE_LIMIT) {
            this.tiles = this.tiles.subList(0, this.TILE_LIMIT);
        }
        if (this.OUTPUT != null) {
            this.barcodeSamWriterMap.put(null, this.buildSamFileWriter(this.OUTPUT, this.SAMPLE_ALIAS, this.LIBRARY_NAME, this.buildSamHeaderParameters(null)));
        } else {
            this.populateWritersFromLibraryParams();
        }
        this.converter = new IlluminaBasecallsToSamConverter(this.RUN_BARCODE, this.READ_GROUP_ID, this.factory.getOutputReadStructure(), this.ADAPTERS_TO_CHECK);
        this.numThreads = this.NUM_PROCESSORS == 0 ? Runtime.getRuntime().availableProcessors() : (this.NUM_PROCESSORS < 0 ? Runtime.getRuntime().availableProcessors() + this.NUM_PROCESSORS : this.NUM_PROCESSORS);
        this.numThreads = Math.max(1, Math.min(this.numThreads, this.tiles.size()));
    }

    private void doTileProcessing() {
        FileChannelJDKBugWorkAround.doBugWorkAround();
        ArrayList<Tile> arrayList = new ArrayList<Tile>();
        for (Integer n : this.tiles) {
            arrayList.add(new Tile(n));
        }
        TileReadAggregator tileReadAggregator = new TileReadAggregator(arrayList);
        tileReadAggregator.submit();
        try {
            tileReadAggregator.awaitWorkComplete();
        }
        catch (InterruptedException interruptedException) {
            log.error(interruptedException, "Failure encountered in worker thread; attempting to shut down remaining worker threads and terminate ...");
            tileReadAggregator.shutdown();
            throw new PicardException("Failure encountered in worker thread; see log for details.");
        }
    }

    private Set<String> findAndFilterExpectedColumns(Set<String> set, Set<String> set2) {
        HashSet<String> hashSet = new HashSet<String>(set2);
        hashSet.removeAll(set);
        if (hashSet.size() > 0) {
            throw new PicardException(String.format("LIBRARY_PARAMS file %s is missing the following columns: %s.", this.LIBRARY_PARAMS.getAbsolutePath(), StringUtil.join(", ", hashSet)));
        }
        HashSet<String> hashSet2 = new HashSet<String>(set);
        hashSet2.removeAll(set2);
        return hashSet2;
    }

    private void checkRgTagColumns(Set<String> set) {
        Set<String> set2 = this.buildSamHeaderParameters(null).keySet();
        set2.retainAll(set);
        if (set2.size() > 0) {
            throw new PicardException("Illegal ReadGroup tags in library params(barcode params) file(" + this.LIBRARY_PARAMS.getAbsolutePath() + ") Offending headers = " + StringUtil.join(", ", set2));
        }
        for (String string : set) {
            if (string.length() <= 2) continue;
            throw new PicardException("Column label (" + string + ") unrecognized.  Library params(barcode params) can only contain the columns " + "(OUTPUT, LIBRARY_NAME, SAMPLE_ALIAS, BARCODE, BARCODE_<X> where X is a positive integer) OR two letter RG tags!");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void populateWritersFromLibraryParams() {
        TabbedTextFileWithHeaderParser tabbedTextFileWithHeaderParser = new TabbedTextFileWithHeaderParser(this.LIBRARY_PARAMS);
        Set<String> set = CollectionUtil.makeSet("OUTPUT", "SAMPLE_ALIAS", "LIBRARY_NAME");
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.readStructure.barcodes.length() == 1) {
            if (tabbedTextFileWithHeaderParser.hasColumn("BARCODE")) {
                arrayList.add("BARCODE");
            } else {
                if (!tabbedTextFileWithHeaderParser.hasColumn("BARCODE_1")) throw new PicardException("LIBRARY_PARAMS(BARCODE_PARAMS) file " + this.LIBRARY_PARAMS + " does not have column BARCODE or BARCODE_1.");
                arrayList.add("BARCODE_1");
            }
        } else {
            for (int i = 1; i <= this.readStructure.barcodes.length(); ++i) {
                arrayList.add("BARCODE_" + i);
            }
        }
        set.addAll(arrayList);
        Set<String> set2 = this.findAndFilterExpectedColumns(tabbedTextFileWithHeaderParser.columnLabels(), set);
        this.checkRgTagColumns(set2);
        for (TabbedTextFileWithHeaderParser.Row row : tabbedTextFileWithHeaderParser) {
            Object object;
            Iterator iterator;
            ArrayList<String> arrayList2 = null;
            if (arrayList.size() > 0) {
                arrayList2 = new ArrayList<String>();
                iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    object = (String)iterator.next();
                    arrayList2.add(row.getField((String)object));
                }
            }
            Iterator iterator2 = iterator = arrayList2 == null || arrayList2.contains("N") ? null : StringUtil.join("", arrayList2);
            if (this.barcodeSamWriterMap.containsKey(iterator)) {
                throw new PicardException("Row for barcode " + iterator + " appears more than once in LIBRARY_PARAMS or BARCODE_PARAMS file " + this.LIBRARY_PARAMS);
            }
            object = this.buildSamHeaderParameters(arrayList2);
            for (String string : set2) {
                object.put(string, row.getField(string));
            }
            SAMFileWriter sAMFileWriter = this.buildSamFileWriter(new File(row.getField("OUTPUT")), row.getField("SAMPLE_ALIAS"), row.getField("LIBRARY_NAME"), (Map<String, String>)object);
            this.barcodeSamWriterMap.put((String)((Object)iterator), sAMFileWriter);
        }
        if (!this.barcodeSamWriterMap.isEmpty()) return;
        throw new PicardException("LIBRARY_PARAMS(BARCODE_PARAMS) file " + this.LIBRARY_PARAMS + " does have any data rows.");
    }

    private Map<String, String> buildSamHeaderParameters(List<String> list) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = this.RUN_BARCODE + "." + this.LANE;
        if (list != null) {
            string = string + "." + IlluminaUtil.barcodeSeqsToString(list);
        }
        hashMap.put("PU", string);
        hashMap.put("CN", this.SEQUENCING_CENTER);
        hashMap.put("PL", this.PLATFORM);
        if (this.RUN_START_DATE != null) {
            Iso8601Date iso8601Date = new Iso8601Date(this.RUN_START_DATE);
            hashMap.put("DT", iso8601Date.toString());
        } else {
            hashMap.put("DT", null);
        }
        return hashMap;
    }

    private SAMFileWriter buildSamFileWriter(File file, String string, String string2, Map<String, String> map) {
        IoUtil.assertFileIsWritable(file);
        SAMReadGroupRecord sAMReadGroupRecord = new SAMReadGroupRecord(this.READ_GROUP_ID);
        sAMReadGroupRecord.setSample(string);
        if (string2 != null) {
            sAMReadGroupRecord.setLibrary(string2);
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (entry.getValue() == null) continue;
            sAMReadGroupRecord.setAttribute(entry.getKey(), entry.getValue());
        }
        SAMFileHeader sAMFileHeader = new SAMFileHeader();
        sAMFileHeader.setSortOrder(SAMFileHeader.SortOrder.queryname);
        sAMFileHeader.addReadGroup(sAMReadGroupRecord);
        return new SAMFileWriterFactory().makeSAMOrBAMWriter(sAMFileHeader, true, file);
    }

    public static void main(String[] stringArray) {
        System.exit(new IlluminaBasecallsToSam().instanceMain(stringArray));
    }

    @Override
    protected String[] customCommandLineValidation() {
        if (this.BARCODE_PARAMS != null) {
            this.LIBRARY_PARAMS = this.BARCODE_PARAMS;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        this.readStructure = new ReadStructure(this.READ_STRUCTURE);
        if (!this.readStructure.barcodes.isEmpty() && this.LIBRARY_PARAMS == null) {
            arrayList.add("BARCODE_PARAMS or LIBRARY_PARAMS is missing.  If READ_STRUCTURE contains a B (barcode) then either LIBRARY_PARAMS or BARCODE_PARAMS(deprecated) must be provided!");
        }
        if (this.READ_GROUP_ID == null) {
            this.READ_GROUP_ID = this.RUN_BARCODE.substring(0, 5) + "." + this.LANE;
        }
        if (arrayList.size() == 0) {
            return null;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private static IlluminaDataType[] getDataTypesFromReadStructure(ReadStructure readStructure) {
        if (readStructure.barcodes.isEmpty()) {
            return DATA_TYPES_NO_BARCODE;
        }
        return DATA_TYPES_WITH_BARCODE;
    }

    static /* synthetic */ int access$600(IlluminaBasecallsToSam illuminaBasecallsToSam) {
        return illuminaBasecallsToSam.numThreads;
    }

    static {
        IlluminaBasecallsToSam.DATA_TYPES_WITH_BARCODE[IlluminaBasecallsToSam.DATA_TYPES_WITH_BARCODE.length - 1] = IlluminaDataType.Barcodes;
    }

    private abstract class PriorityRunnable
    implements Runnable {
        private final int priority;

        public PriorityRunnable() {
            this(1);
        }

        public PriorityRunnable(int n) {
            this.priority = n;
        }

        int getPriority() {
            return this.priority;
        }
    }

    private class TileReadAggregator {
        private final Map<Tile, TileProcessingRecord> tileRecords = new TreeMap<Tile, TileProcessingRecord>();
        private final ExecutorService prioritizingThreadPool = new ThreadPoolExecutor(IlluminaBasecallsToSam.access$600(IlluminaBasecallsToSam.this), IlluminaBasecallsToSam.access$600(IlluminaBasecallsToSam.this), 0L, TimeUnit.MILLISECONDS, new PriorityBlockingQueue<Runnable>(5, new Comparator<Runnable>(){

            @Override
            public int compare(Runnable runnable, Runnable runnable2) {
                return ((PriorityRunnable)runnable2).getPriority() - ((PriorityRunnable)runnable).getPriority();
            }
        }));
        private final Object completionLatch = new Object();
        private Thread parentThread;
        private final Object workEnqueueMonitor = new Object();
        private final AtomicBoolean submitted = new AtomicBoolean(false);

        public TileReadAggregator(Collection<Tile> collection) {
            for (Tile tile : collection) {
                this.tileRecords.put(tile, new TileProcessingRecord());
            }
        }

        public void submit() {
            if (!this.submitted.compareAndSet(false, true)) {
                throw new IllegalStateException("The submit() method may not be called more than once.");
            }
            this.parentThread = Thread.currentThread();
            int n = 0;
            for (Tile tile : this.tileRecords.keySet()) {
                final TileReader tileReader = new TileReader(tile, this, this.tileRecords.get(tile));
                this.prioritizingThreadPool.execute(new PriorityRunnable(--n){

                    @Override
                    public void run() {
                        try {
                            tileReader.process();
                        }
                        catch (RuntimeException runtimeException) {
                            TileReadAggregator.this.parentThread.interrupt();
                            throw runtimeException;
                        }
                        catch (Error error) {
                            TileReadAggregator.this.parentThread.interrupt();
                            throw error;
                        }
                    }
                });
            }
        }

        private void completeTile(Tile tile) {
            TileProcessingRecord tileProcessingRecord = this.tileRecords.get(tile);
            if (tileProcessingRecord.getState() == TileProcessingState.DONE_READING) {
                throw new IllegalStateException("This tile is already in the completed state.");
            }
            for (String string : tileProcessingRecord.getBarcodes()) {
                tileProcessingRecord.setBarcodeState(string, TileBarcodeProcessingState.READ);
            }
            tileProcessingRecord.setState(TileProcessingState.DONE_READING);
            log.debug(String.format("Completed reading tile %s; collected %s reads spanning %s barcodes.", tile.getNumber(), tileProcessingRecord.getRecordCount(), tileProcessingRecord.getBarcodeCount()));
            this.findAndEnqueueWorkOrSignalCompletion();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void awaitWorkComplete() throws InterruptedException {
            Object object = this.completionLatch;
            synchronized (object) {
                this.completionLatch.wait();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void signalWorkComplete() {
            Object object = this.completionLatch;
            synchronized (object) {
                this.completionLatch.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void findAndEnqueueWorkOrSignalCompletion() {
            Object object = this.workEnqueueMonitor;
            synchronized (object) {
                if (this.isWorkCompleted()) {
                    this.signalWorkComplete();
                } else {
                    LinkedList<PriorityRunnable> linkedList = new LinkedList<PriorityRunnable>();
                    block8: for (String object2 : IlluminaBasecallsToSam.this.barcodeSamWriterMap.keySet()) {
                        block9: for (Map.Entry<Tile, TileProcessingRecord> entry : this.tileRecords.entrySet()) {
                            Tile tile = entry.getKey();
                            TileProcessingRecord tileProcessingRecord = entry.getValue();
                            if (tileProcessingRecord.getState() != TileProcessingState.DONE_READING) continue block8;
                            switch (tileProcessingRecord.getBarcodeState(object2)) {
                                case NA: 
                                case WRITTEN: {
                                    continue block9;
                                }
                                case QUEUED_FOR_WRITE: {
                                    continue block8;
                                }
                                case READ: {
                                    tileProcessingRecord.setBarcodeState(object2, TileBarcodeProcessingState.QUEUED_FOR_WRITE);
                                    log.debug(String.format("Enqueuing work for tile %s and barcode %s.", tile.getNumber(), object2));
                                    linkedList.add(this.newBarcodeWorkInstance(tile, tileProcessingRecord, object2));
                                    continue block8;
                                }
                            }
                        }
                    }
                    for (Runnable runnable : linkedList) {
                        this.prioritizingThreadPool.execute(runnable);
                    }
                }
            }
        }

        private PriorityRunnable newBarcodeWorkInstance(final Tile tile, final TileProcessingRecord tileProcessingRecord, final String string) {
            return new PriorityRunnable(){

                @Override
                public void run() {
                    try {
                        SortingCollection<SAMRecord> sortingCollection = tileProcessingRecord.getBarcodeRecords().get(string);
                        SAMFileWriter sAMFileWriter = (SAMFileWriter)IlluminaBasecallsToSam.this.barcodeSamWriterMap.get(string);
                        log.debug(String.format("Writing records from tile %s with barcode %s ...", tile.getNumber(), string));
                        PeekIterator peekIterator = new PeekIterator(sortingCollection.iterator());
                        while (peekIterator.hasNext()) {
                            SAMRecord sAMRecord = (SAMRecord)peekIterator.next();
                            if (peekIterator.hasNext()) {
                                SAMRecord sAMRecord2 = (SAMRecord)peekIterator.peek();
                                if (!sAMRecord.getReadUnmappedFlag() || !sAMRecord2.getReadUnmappedFlag()) {
                                    throw new IllegalStateException("Should not have mapped reads.");
                                }
                                if (IlluminaBasecallsToSam.this.samRecordQueryNameComparator.compare(sAMRecord, sAMRecord2) == 0) {
                                    peekIterator.next();
                                    log.info("Skipping reads with identical read names: " + sAMRecord.getReadName());
                                    continue;
                                }
                            }
                            sAMFileWriter.addAlignment(sAMRecord);
                            IlluminaBasecallsToSam.this.writeProgressLogger.record(sAMRecord);
                        }
                        tileProcessingRecord.setBarcodeState(string, TileBarcodeProcessingState.WRITTEN);
                        TileReadAggregator.this.findAndEnqueueWorkOrSignalCompletion();
                    }
                    catch (RuntimeException runtimeException) {
                        TileReadAggregator.this.parentThread.interrupt();
                        throw runtimeException;
                    }
                    catch (Error error) {
                        TileReadAggregator.this.parentThread.interrupt();
                        throw error;
                    }
                }
            };
        }

        public boolean isWorkCompleted() {
            for (Map.Entry<Tile, TileProcessingRecord> entry : this.tileRecords.entrySet()) {
                TileProcessingRecord tileProcessingRecord = entry.getValue();
                if (tileProcessingRecord.getState() != TileProcessingState.DONE_READING) {
                    log.debug(String.format("Work is not completed because a tile isn't done being read: %s.", entry.getKey().getNumber()));
                    return false;
                }
                for (Map.Entry<String, TileBarcodeProcessingState> entry2 : tileProcessingRecord.getBarcodeProcessingStates().entrySet()) {
                    TileBarcodeProcessingState tileBarcodeProcessingState = entry2.getValue();
                    if (tileBarcodeProcessingState == TileBarcodeProcessingState.WRITTEN) continue;
                    log.debug(String.format("Work is not completed because a tile isn't done being read: Tile %s, Barcode %s, Processing State %s.", new Object[]{entry.getKey().getNumber(), entry2.getKey(), tileBarcodeProcessingState}));
                    return false;
                }
            }
            log.info("All work is complete.");
            return true;
        }

        public void shutdown() {
            this.prioritizingThreadPool.shutdownNow();
        }
    }

    private class TileProcessingRecord {
        private final Map<String, SortingCollection<SAMRecord>> barcodeToRecordCollection = new HashMap<String, SortingCollection<SAMRecord>>();
        private final Map<String, TileBarcodeProcessingState> barcodeToProcessingState = new HashMap<String, TileBarcodeProcessingState>();
        private TileProcessingState state = TileProcessingState.NOT_DONE_READING;
        private long recordCount = 0L;

        private TileProcessingRecord() {
        }

        public synchronized TileProcessingState getState() {
            return this.state;
        }

        public synchronized void setState(TileProcessingState tileProcessingState) {
            this.state = tileProcessingState;
        }

        public synchronized void addRecord(String string, SAMRecord ... sAMRecordArray) {
            this.recordCount += (long)sAMRecordArray.length;
            SortingCollection<SAMRecord> sortingCollection = this.barcodeToRecordCollection.get(string);
            if (sortingCollection == null) {
                if (!IlluminaBasecallsToSam.this.barcodeSamWriterMap.containsKey(string)) {
                    throw new PicardException(String.format("Read records with barcode %s, but this barcode was not expected.  (Is it referenced in the parameters file?)", string));
                }
                sortingCollection = this.newSortingCollection();
                this.barcodeToRecordCollection.put(string, sortingCollection);
                this.barcodeToProcessingState.put(string, null);
            }
            for (SAMRecord sAMRecord : sAMRecordArray) {
                sortingCollection.add(sAMRecord);
            }
        }

        private synchronized SortingCollection<SAMRecord> newSortingCollection() {
            int n = IlluminaBasecallsToSam.this.MAX_READS_IN_RAM_PER_TILE / IlluminaBasecallsToSam.this.barcodeSamWriterMap.size();
            return SortingCollection.newInstance(SAMRecord.class, new BAMRecordCodec(null), new SAMRecordQueryNameComparator(), n, IlluminaBasecallsToSam.this.TMP_DIR);
        }

        public synchronized long getBarcodeCount() {
            return this.barcodeToRecordCollection.size();
        }

        public synchronized long getRecordCount() {
            return this.recordCount;
        }

        public synchronized Map<String, SortingCollection<SAMRecord>> getBarcodeRecords() {
            return this.barcodeToRecordCollection;
        }

        public synchronized TileBarcodeProcessingState getBarcodeState(String string) {
            if (this.getState() == TileProcessingState.NOT_DONE_READING) {
                throw new IllegalStateException("A tile's barcode data's state cannot be queried until the tile has been completely read.");
            }
            if (this.barcodeToProcessingState.containsKey(string)) {
                return this.barcodeToProcessingState.get(string);
            }
            return TileBarcodeProcessingState.NA;
        }

        public synchronized Map<String, TileBarcodeProcessingState> getBarcodeProcessingStates() {
            return this.barcodeToProcessingState;
        }

        public synchronized void setBarcodeState(String string, TileBarcodeProcessingState tileBarcodeProcessingState) {
            if (!this.barcodeToProcessingState.containsKey(string)) {
                throw new NoSuchElementException(String.format("No record of the provided barcode, %s.", string));
            }
            this.barcodeToProcessingState.put(string, tileBarcodeProcessingState);
        }

        public synchronized Set<String> getBarcodes() {
            return this.getBarcodeRecords().keySet();
        }
    }

    private class TileReader {
        private final Tile tile;
        private final TileReadAggregator handler;
        private final TileProcessingRecord processingRecord;

        public TileReader(Tile tile, TileReadAggregator tileReadAggregator, TileProcessingRecord tileProcessingRecord) {
            this.tile = tile;
            this.handler = tileReadAggregator;
            this.processingRecord = tileProcessingRecord;
        }

        public void process() {
            IlluminaDataProvider illuminaDataProvider = IlluminaBasecallsToSam.this.factory.makeDataProvider(Arrays.asList(this.tile.getNumber()));
            SAMRecord[] sAMRecordArray = new SAMRecord[IlluminaBasecallsToSam.this.converter.getNumRecordsPerCluster()];
            log.debug(String.format("Reading data from tile %s ...", this.tile.getNumber()));
            while (illuminaDataProvider.hasNext()) {
                ClusterData clusterData = illuminaDataProvider.next();
                String string = clusterData.getMatchedBarcode();
                IlluminaBasecallsToSam.this.converter.createSamRecords(clusterData, null, sAMRecordArray);
                IlluminaBasecallsToSam.this.readProgressLogger.record(sAMRecordArray);
                this.processingRecord.addRecord(string, sAMRecordArray);
            }
            this.handler.completeTile(this.tile);
        }
    }

    private class Tile
    implements Comparable<Tile> {
        private final int tileNumber;

        public Tile(int n) {
            this.tileNumber = n;
        }

        public int getNumber() {
            return this.tileNumber;
        }

        public boolean equals(Object object) {
            return object instanceof Tile && this.getNumber() == ((Tile)object).getNumber();
        }

        @Override
        public int compareTo(Tile tile) {
            return TILE_NUMBER_COMPARATOR.compare(this.getNumber(), tile.getNumber());
        }
    }

    private static enum TileProcessingState {
        NOT_DONE_READING,
        DONE_READING;

    }

    private static enum TileBarcodeProcessingState {
        NA,
        READ,
        QUEUED_FOR_WRITE,
        WRITTEN;

    }
}

