/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.analysis.directed;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.picard.analysis.InsertSizeMetrics;
import net.sf.picard.analysis.MetricAccumulationLevel;
import net.sf.picard.analysis.directed.InsertSizeCollectorArgs;
import net.sf.picard.metrics.MetricsFile;
import net.sf.picard.metrics.MultiLevelCollector;
import net.sf.picard.metrics.PerUnitMetricCollector;
import net.sf.picard.reference.ReferenceSequence;
import net.sf.picard.sam.SamPairUtil;
import net.sf.picard.util.Histogram;
import net.sf.samtools.SAMReadGroupRecord;
import net.sf.samtools.SAMRecord;

public class InsertSizeMetricsCollector
extends MultiLevelCollector<InsertSizeMetrics, Integer, InsertSizeCollectorArgs> {
    private final double minimumPct;
    private final double deviations;
    private Integer histogramWidth;

    public InsertSizeMetricsCollector(Set<MetricAccumulationLevel> set, List<SAMReadGroupRecord> list, double d, Integer n, double d2) {
        this.minimumPct = d;
        this.histogramWidth = n;
        this.deviations = d2;
        this.setup(set, list);
    }

    @Override
    protected InsertSizeCollectorArgs makeArg(SAMRecord sAMRecord, ReferenceSequence referenceSequence) {
        int n = Math.abs(sAMRecord.getInferredInsertSize());
        SamPairUtil.PairOrientation pairOrientation = SamPairUtil.getPairOrientation(sAMRecord);
        return new InsertSizeCollectorArgs(n, pairOrientation);
    }

    @Override
    protected PerUnitMetricCollector<InsertSizeMetrics, Integer, InsertSizeCollectorArgs> makeChildCollector(String string, String string2, String string3) {
        return new PerUnitInsertSizeMetricsCollector(string, string2, string3);
    }

    @Override
    public void acceptRecord(SAMRecord sAMRecord, ReferenceSequence referenceSequence) {
        if (!sAMRecord.getReadPairedFlag() || sAMRecord.getReadUnmappedFlag() || sAMRecord.getMateUnmappedFlag() || sAMRecord.getFirstOfPairFlag() || sAMRecord.getNotPrimaryAlignmentFlag() || sAMRecord.getDuplicateReadFlag() || sAMRecord.getInferredInsertSize() == 0) {
            return;
        }
        super.acceptRecord(sAMRecord, referenceSequence);
    }

    public class PerUnitInsertSizeMetricsCollector
    implements PerUnitMetricCollector<InsertSizeMetrics, Integer, InsertSizeCollectorArgs> {
        final EnumMap<SamPairUtil.PairOrientation, Histogram<Integer>> histograms = new EnumMap(SamPairUtil.PairOrientation.class);
        final String sample;
        final String library;
        final String readGroup;
        private double totalInserts = 0.0;

        public PerUnitInsertSizeMetricsCollector(String string, String string2, String string3) {
            this.sample = string;
            this.library = string2;
            this.readGroup = string3;
            String string4 = null;
            string4 = this.readGroup != null ? this.readGroup + "." : (this.library != null ? this.library + "." : (this.sample != null ? this.sample + "." : "All_Reads."));
            this.histograms.put(SamPairUtil.PairOrientation.FR, new Histogram("insert_size", string4 + "fr_count"));
            this.histograms.put(SamPairUtil.PairOrientation.TANDEM, new Histogram("insert_size", string4 + "tandem_count"));
            this.histograms.put(SamPairUtil.PairOrientation.RF, new Histogram("insert_size", string4 + "rf_count"));
        }

        @Override
        public void acceptRecord(InsertSizeCollectorArgs insertSizeCollectorArgs) {
            this.histograms.get((Object)insertSizeCollectorArgs.getPairOrientation()).increment(insertSizeCollectorArgs.getInsertSize());
        }

        @Override
        public void finish() {
        }

        public double getTotalInserts() {
            return this.totalInserts;
        }

        @Override
        public void addMetricsToFile(MetricsFile<InsertSizeMetrics, Integer> metricsFile) {
            for (Histogram<Integer> object : this.histograms.values()) {
                this.totalInserts += object.getCount();
            }
            for (Map.Entry entry : this.histograms.entrySet()) {
                Object object;
                SamPairUtil.PairOrientation pairOrientation = (SamPairUtil.PairOrientation)((Object)entry.getKey());
                Histogram histogram = (Histogram)entry.getValue();
                double d = histogram.getCount();
                if (!(d > this.totalInserts * InsertSizeMetricsCollector.this.minimumPct)) continue;
                InsertSizeMetrics insertSizeMetrics = new InsertSizeMetrics();
                insertSizeMetrics.SAMPLE = this.sample;
                insertSizeMetrics.LIBRARY = this.library;
                insertSizeMetrics.READ_GROUP = this.readGroup;
                insertSizeMetrics.PAIR_ORIENTATION = pairOrientation;
                insertSizeMetrics.READ_PAIRS = (long)d;
                insertSizeMetrics.MAX_INSERT_SIZE = (int)histogram.getMax();
                insertSizeMetrics.MIN_INSERT_SIZE = (int)histogram.getMin();
                insertSizeMetrics.MEDIAN_INSERT_SIZE = histogram.getMedian();
                insertSizeMetrics.MEDIAN_ABSOLUTE_DEVIATION = histogram.getMedianAbsoluteDeviation();
                double d2 = histogram.getMedian();
                double d3 = 0.0;
                double d4 = d2;
                for (double d5 = d2; d4 >= histogram.getMin() || d5 <= histogram.getMax(); d4 -= 1.0, d5 += 1.0) {
                    Histogram.Bin bin;
                    object = (Histogram.Bin)histogram.get((int)d4);
                    if (object != null) {
                        d3 += ((Histogram.Bin)object).getValue();
                    }
                    if (d4 != d5 && (bin = (Histogram.Bin)histogram.get((int)d5)) != null) {
                        d3 += bin.getValue();
                    }
                    double d6 = d3 / d;
                    int n = (int)(d5 - d4) + 1;
                    if (d6 >= 0.1 && insertSizeMetrics.WIDTH_OF_10_PERCENT == 0) {
                        insertSizeMetrics.WIDTH_OF_10_PERCENT = n;
                    }
                    if (d6 >= 0.2 && insertSizeMetrics.WIDTH_OF_20_PERCENT == 0) {
                        insertSizeMetrics.WIDTH_OF_20_PERCENT = n;
                    }
                    if (d6 >= 0.3 && insertSizeMetrics.WIDTH_OF_30_PERCENT == 0) {
                        insertSizeMetrics.WIDTH_OF_30_PERCENT = n;
                    }
                    if (d6 >= 0.4 && insertSizeMetrics.WIDTH_OF_40_PERCENT == 0) {
                        insertSizeMetrics.WIDTH_OF_40_PERCENT = n;
                    }
                    if (d6 >= 0.5 && insertSizeMetrics.WIDTH_OF_50_PERCENT == 0) {
                        insertSizeMetrics.WIDTH_OF_50_PERCENT = n;
                    }
                    if (d6 >= 0.6 && insertSizeMetrics.WIDTH_OF_60_PERCENT == 0) {
                        insertSizeMetrics.WIDTH_OF_60_PERCENT = n;
                    }
                    if (d6 >= 0.7 && insertSizeMetrics.WIDTH_OF_70_PERCENT == 0) {
                        insertSizeMetrics.WIDTH_OF_70_PERCENT = n;
                    }
                    if (d6 >= 0.8 && insertSizeMetrics.WIDTH_OF_80_PERCENT == 0) {
                        insertSizeMetrics.WIDTH_OF_80_PERCENT = n;
                    }
                    if (d6 >= 0.9 && insertSizeMetrics.WIDTH_OF_90_PERCENT == 0) {
                        insertSizeMetrics.WIDTH_OF_90_PERCENT = n;
                    }
                    if (!(d6 >= 0.99) || insertSizeMetrics.WIDTH_OF_99_PERCENT != 0) continue;
                    insertSizeMetrics.WIDTH_OF_99_PERCENT = n;
                }
                object = histogram;
                if (InsertSizeMetricsCollector.this.histogramWidth == null) {
                    InsertSizeMetricsCollector.this.histogramWidth = (int)(insertSizeMetrics.MEDIAN_INSERT_SIZE + InsertSizeMetricsCollector.this.deviations * insertSizeMetrics.MEDIAN_ABSOLUTE_DEVIATION);
                }
                ((Histogram)object).trimByWidth(InsertSizeMetricsCollector.this.histogramWidth);
                insertSizeMetrics.MEAN_INSERT_SIZE = ((Histogram)object).getMean();
                insertSizeMetrics.STANDARD_DEVIATION = ((Histogram)object).getStandardDeviation();
                metricsFile.addHistogram((Histogram<Integer>)object);
                metricsFile.addMetric(insertSizeMetrics);
            }
        }
    }
}

