/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.analysis;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import net.sf.picard.PicardException;
import net.sf.picard.analysis.SinglePassSamProgram;
import net.sf.picard.cmdline.Option;
import net.sf.picard.io.IoUtil;
import net.sf.picard.metrics.MetricsFile;
import net.sf.picard.reference.ReferenceSequence;
import net.sf.picard.util.Histogram;
import net.sf.picard.util.Log;
import net.sf.picard.util.RExecutor;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMReadGroupRecord;
import net.sf.samtools.SAMRecord;

public class MeanQualityByCycle
extends SinglePassSamProgram {
    @Option(shortName="CHART", doc="A file (with .pdf extension) to write the chart to")
    public File CHART_OUTPUT;
    @Option(doc="If set to true calculate mean quality over aligned reads only")
    public boolean ALIGNED_READS_ONLY = false;
    @Option(doc="If set to true calculate mean quality over PF reads only")
    public boolean PF_READS_ONLY = false;
    private HistogramGenerator q = new HistogramGenerator(false);
    private HistogramGenerator oq = new HistogramGenerator(true);
    private String plotSubtitle = "";
    private final Log log = Log.getInstance(MeanQualityByCycle.class);

    public static void main(String[] stringArray) {
        System.exit(new MeanQualityByCycle().instanceMain(stringArray));
    }

    @Override
    protected void setup(SAMFileHeader sAMFileHeader, File file) {
        IoUtil.assertFileIsWritable(this.CHART_OUTPUT);
        List<SAMReadGroupRecord> list = sAMFileHeader.getReadGroups();
        if (list.size() == 1) {
            this.plotSubtitle = list.get(0).getLibrary();
        }
    }

    @Override
    protected void acceptRead(SAMRecord sAMRecord, ReferenceSequence referenceSequence) {
        if (this.PF_READS_ONLY && sAMRecord.getReadFailsVendorQualityCheckFlag()) {
            return;
        }
        if (this.ALIGNED_READS_ONLY && sAMRecord.getReadUnmappedFlag()) {
            return;
        }
        if (sAMRecord.getNotPrimaryAlignmentFlag()) {
            return;
        }
        this.q.addRecord(sAMRecord);
        this.oq.addRecord(sAMRecord);
    }

    @Override
    protected void finish() {
        MetricsFile metricsFile = this.getMetricsFile();
        metricsFile.addHistogram(this.q.getMeanQualityHistogram());
        if (!this.oq.isEmpty()) {
            metricsFile.addHistogram(this.oq.getMeanQualityHistogram());
        }
        metricsFile.write(this.OUTPUT);
        if (this.q.isEmpty() && this.oq.isEmpty()) {
            this.log.warn("No valid bases found in input file. No plot will be produced.");
        } else {
            int n = RExecutor.executeFromClasspath("net/sf/picard/analysis/meanQualityByCycle.R", this.OUTPUT.getAbsolutePath(), this.CHART_OUTPUT.getAbsolutePath(), this.INPUT.getName(), this.plotSubtitle);
            if (n != 0) {
                throw new PicardException("R script meanQualityByCycle.R failed with return code " + n);
            }
        }
    }

    private static class HistogramGenerator {
        final boolean useOriginalQualities;
        int maxLengthSoFar = 0;
        double[] firstReadTotalsByCycle = new double[this.maxLengthSoFar];
        long[] firstReadCountsByCycle = new long[this.maxLengthSoFar];
        double[] secondReadTotalsByCycle = new double[this.maxLengthSoFar];
        long[] secondReadCountsByCycle = new long[this.maxLengthSoFar];

        private HistogramGenerator(boolean bl) {
            this.useOriginalQualities = bl;
        }

        void addRecord(SAMRecord sAMRecord) {
            byte[] byArray;
            byte[] byArray2 = byArray = this.useOriginalQualities ? sAMRecord.getOriginalBaseQualities() : sAMRecord.getBaseQualities();
            if (byArray == null) {
                return;
            }
            int n = byArray.length;
            boolean bl = sAMRecord.getReadNegativeStrandFlag();
            this.ensureArraysBigEnough(n + 1);
            for (int i = 0; i < n; ++i) {
                int n2;
                int n3 = n2 = bl ? n - i : i + 1;
                if (sAMRecord.getReadPairedFlag() && sAMRecord.getSecondOfPairFlag()) {
                    int n4 = n2;
                    this.secondReadTotalsByCycle[n4] = this.secondReadTotalsByCycle[n4] + (double)byArray[i];
                    int n5 = n2;
                    this.secondReadCountsByCycle[n5] = this.secondReadCountsByCycle[n5] + 1L;
                    continue;
                }
                int n6 = n2;
                this.firstReadTotalsByCycle[n6] = this.firstReadTotalsByCycle[n6] + (double)byArray[i];
                int n7 = n2;
                this.firstReadCountsByCycle[n7] = this.firstReadCountsByCycle[n7] + 1L;
            }
        }

        private void ensureArraysBigEnough(int n) {
            if (n > this.maxLengthSoFar) {
                this.firstReadTotalsByCycle = Arrays.copyOf(this.firstReadTotalsByCycle, n);
                this.firstReadCountsByCycle = Arrays.copyOf(this.firstReadCountsByCycle, n);
                this.secondReadTotalsByCycle = Arrays.copyOf(this.secondReadTotalsByCycle, n);
                this.secondReadCountsByCycle = Arrays.copyOf(this.secondReadCountsByCycle, n);
                this.maxLengthSoFar = n;
            }
        }

        Histogram<Integer> getMeanQualityHistogram() {
            int n;
            String string = this.useOriginalQualities ? "MEAN_ORIGINAL_QUALITY" : "MEAN_QUALITY";
            Histogram<Integer> histogram = new Histogram<Integer>("CYCLE", string);
            int n2 = 0;
            for (n = 0; n < this.firstReadTotalsByCycle.length; ++n) {
                if (!(this.firstReadTotalsByCycle[n] > 0.0)) continue;
                histogram.increment(n, this.firstReadTotalsByCycle[n] / (double)this.firstReadCountsByCycle[n]);
                n2 = n;
            }
            for (n = 0; n < this.secondReadTotalsByCycle.length; ++n) {
                int n3 = n2 + n;
                if (this.secondReadCountsByCycle[n] <= 0L) continue;
                histogram.increment(n3, this.secondReadTotalsByCycle[n] / (double)this.firstReadCountsByCycle[n]);
            }
            return histogram;
        }

        boolean isEmpty() {
            return this.maxLengthSoFar == 0;
        }
    }
}

