/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.math.stats;

import java.util.ArrayList;
import umcg.genetica.math.interpolation.CubicSpline;
import umcg.genetica.util.Primitives;
import umcg.genetica.util.RankDoubleArray;

public class QValues {
    public static double[] qvalue(double[] pvals, Double fdr) {
        double[] lambda = QValues.initlambda();
        return QValues.qvalue(pvals, lambda, fdr, false, 3, SMOOTHER.SMOOTHER, false);
    }

    public static double[] qvalue(double[] pvals, double[] lambda, Double fdr, boolean robust, Integer smootfhDf, SMOOTHER smoother, boolean smoothLog) {
        if (pvals == null || pvals.length == 0) {
            throw new IllegalArgumentException("Qvalue - Error: list of p-values is null or length equals zero");
        }
        double maxp = Primitives.max(pvals);
        double minp = Primitives.min(pvals);
        if (maxp > 1.0 || minp < 0.0) {
            throw new IllegalArgumentException("Qvalue - Error: pvals should be between 0 and 1. Max: " + maxp + "\tMin: " + minp);
        }
        if (lambda == null) {
            lambda = QValues.initlambda();
        } else {
            if (lambda.length > 1 && lambda.length < 4) {
                throw new IllegalArgumentException("Qvalue - Error: if length of lambda > 1, lambda should have at least 4 values");
            }
            if (lambda.length > 1 && (Primitives.max(lambda) > 1.0 || Primitives.min(lambda) < 0.0)) {
                throw new IllegalArgumentException("Qvalue - Error: lambda should be between [0,1)");
            }
            if (lambda.length == 1 && (lambda[0] < 0.0 || lambda[0] > 1.0)) {
                throw new IllegalArgumentException("Qvalue - Error: lambda should be between [0,1)");
            }
        }
        int m = pvals.length;
        double pi0 = 0.0;
        if (lambda.length == 1) {
            double lval = lambda[0];
            double nrvalsltlambda = 0.0;
            for (double p : pvals) {
                if (!(p >= lval)) continue;
                nrvalsltlambda += 1.0;
            }
            pi0 = (nrvalsltlambda /= (double)pvals.length) / (1.0 - lval);
            pi0 = Primitives.min(new double[]{pi0, 1.0});
        } else {
            int i;
            double[] pi0Intermediate = new double[lambda.length];
            for (i = 0; i < pi0Intermediate.length; ++i) {
                double lval = lambda[i];
                double nrvalsltlambda = 0.0;
                for (double p : pvals) {
                    if (!(p >= lval)) continue;
                    nrvalsltlambda += 1.0;
                }
                pi0Intermediate[i] = nrvalsltlambda / (double)lambda.length / (1.0 - lval);
            }
            if (smoother == SMOOTHER.SMOOTHER) {
                if (smoothLog) {
                    for (i = 0; i < pi0Intermediate.length; ++i) {
                        pi0Intermediate[i] = Math.log(pi0Intermediate[i]);
                    }
                }
                CubicSpline spline = new CubicSpline(lambda, pi0Intermediate);
                pi0 = spline.interpolate(Primitives.max(lambda));
                if (smoothLog) {
                    pi0 = Math.exp(pi0);
                }
                pi0 = Primitives.min(new double[]{pi0, 1.0});
            } else if (smoother == SMOOTHER.BOOTSTRAP) {
                double minpi0 = Primitives.min(pi0Intermediate);
                double[] mse = new double[lambda.length];
                double[] piboot = new double[lambda.length];
                for (int i2 = 0; i2 < 100; ++i2) {
                    int j;
                    double[] pboot = QValues.sampleWithReplacement(pvals, pvals.length);
                    for (j = 0; j < lambda.length; ++j) {
                        double lval = lambda[i2];
                        double nrvalsltlambda = 0.0;
                        for (double p : pboot) {
                            if (!(p > lval)) continue;
                            nrvalsltlambda += 1.0;
                        }
                        piboot[i2] = (nrvalsltlambda /= (double)pboot.length) / (1.0 - lval);
                    }
                    j = 0;
                    while (j < mse.length) {
                        double d = piboot[j] - minpi0;
                        int n = j++;
                        mse[n] = mse[n] + d * d;
                    }
                }
                double minmse = Primitives.min(mse);
                ArrayList<Integer> minMSEIndices = new ArrayList<Integer>();
                for (int j = 0; j < mse.length; ++j) {
                    if (mse[j] != minmse) continue;
                    minMSEIndices.add(j);
                }
                double[] minpi0s = new double[minMSEIndices.size()];
                for (int j = 0; j < minpi0s.length; ++j) {
                    minpi0s[j] = pi0Intermediate[(Integer)minMSEIndices.get(j)];
                }
                pi0 = Primitives.min(minpi0s);
                pi0 = Primitives.min(new double[]{pi0, 1.0});
            } else {
                throw new IllegalArgumentException("SMOOTHER argument must be either be BOOTSTRAP or SMOOTHER");
            }
        }
        if (pi0 <= 0.0) {
            System.err.println("ERROR: The estimated pi0 <= 0. Check that you have valid p-values or use another lambda estimator");
        }
        if (fdr != null && (fdr <= 0.0 || fdr > 1.0)) {
            throw new IllegalArgumentException("ERROR: FDR level should be between 0 and 1");
        }
        RankDoubleArray rda = new RankDoubleArray();
        double[] rankedpvals = rda.rank(pvals);
        double[] v = QValues.specialQValueRank(pvals);
        return null;
    }

    private static double[] initlambda() {
        double[] lambda = new double[18];
        for (int i = 0; i < lambda.length; ++i) {
            lambda[i] = (double)i * 0.05;
        }
        return lambda;
    }

    private static double[] sampleWithReplacement(double[] vals, int numToSample) {
        double[] output = new double[numToSample];
        for (int i = 0; i < numToSample; ++i) {
            int randomPos = (int)Math.floor(Math.random() * (double)vals.length);
            output[i] = vals[randomPos];
        }
        return output;
    }

    private static double[] specialQValueRank(double[] pvals) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public static enum SMOOTHER {
        BOOTSTRAP,
        SMOOTHER;

    }
}

