/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.math.matrix2;

import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.DenseLargeDoubleMatrix2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import umcg.genetica.io.text.TextFile;

public class DoubleMatrixDataset<R extends Comparable, C extends Comparable> {
    static final IOException doubleMatrixDatasetNonUniqueHeaderException = new IOException("Tried to use a non-unique header set in an identifier HashMap");
    static final Logger LOGGER = Logger.getLogger(DoubleMatrixDataset.class.getName());
    protected DoubleMatrix2D matrix;
    protected LinkedHashMap<R, Integer> hashRows;
    protected LinkedHashMap<C, Integer> hashCols;

    public DoubleMatrixDataset() {
        this.hashRows = new LinkedHashMap();
        this.hashCols = new LinkedHashMap();
    }

    public DoubleMatrixDataset(int rows, int columns) {
        this.hashRows = new LinkedHashMap((int)Math.ceil((double)rows / 0.75));
        this.hashCols = new LinkedHashMap((int)Math.ceil((double)columns / 0.75));
        this.matrix = (long)rows * (long)columns < 0x7FFFFFFDL ? new DenseDoubleMatrix2D(rows, columns) : new DenseLargeDoubleMatrix2D(rows, columns);
    }

    public DoubleMatrixDataset(LinkedHashMap<R, Integer> hashRows, LinkedHashMap<C, Integer> hashCols) {
        this.hashRows = hashRows;
        this.hashCols = hashCols;
        this.matrix = (long)hashRows.size() * (long)hashCols.size() < 0x7FFFFFFDL ? new DenseDoubleMatrix2D(hashRows.size(), hashCols.size()) : new DenseLargeDoubleMatrix2D(hashRows.size(), hashCols.size());
    }

    public DoubleMatrixDataset(DoubleMatrix2D matrix, LinkedHashMap<R, Integer> hashRows, LinkedHashMap<C, Integer> hashCols) {
        this.hashRows = hashRows;
        this.hashCols = hashCols;
        this.matrix = matrix;
    }

    public static DoubleMatrixDataset<String, String> loadDoubleData(String fileName) throws IOException {
        return DoubleMatrixDataset.loadDoubleData(fileName, "\t");
    }

    public static DoubleMatrixDataset<String, String> loadDoubleData(String fileName, String delimiter) throws IOException {
        DoubleMatrixDataset<String, String> dataset;
        Pattern splitPatern = Pattern.compile(delimiter);
        int columnOffset = 1;
        TextFile in = new TextFile(fileName, false);
        String str = in.readLine();
        String[] data = splitPatern.split(str);
        int tmpCols = data.length - columnOffset;
        LinkedHashMap<String, Integer> colMap = new LinkedHashMap<String, Integer>((int)Math.ceil((double)tmpCols / 0.75));
        for (int s = 0; s < tmpCols; ++s) {
            String colName = data[s + columnOffset];
            if (colMap.containsKey(colName)) {
                LOGGER.warning("Duplicated column name!");
                throw doubleMatrixDatasetNonUniqueHeaderException;
            }
            colMap.put(colName, s);
        }
        int tmpRows = 0;
        while (in.readLine() != null) {
            ++tmpRows;
        }
        in.close();
        if ((long)tmpRows * (long)tmpCols < 0x7FFFFFFDL) {
            LinkedHashMap<String, Integer> rowMap = new LinkedHashMap<String, Integer>((int)Math.ceil((double)tmpRows / 0.75));
            DenseDoubleMatrix2D tmpMatrix = new DenseDoubleMatrix2D(tmpRows, tmpCols);
            in.open();
            in.readLine();
            int row = 0;
            boolean correctData = true;
            while ((str = in.readLine()) != null) {
                data = splitPatern.split(str);
                if (!rowMap.containsKey(data[0])) {
                    rowMap.put(data[0], row);
                    for (int s = 0; s < tmpCols; ++s) {
                        double d;
                        try {
                            d = Double.parseDouble(data[s + columnOffset]);
                        }
                        catch (NumberFormatException e) {
                            correctData = false;
                            d = Double.NaN;
                        }
                        tmpMatrix.setQuick(row, s, d);
                    }
                    ++row;
                    continue;
                }
                LOGGER.warning("Duplicated row name!");
                throw doubleMatrixDatasetNonUniqueHeaderException;
            }
            if (!correctData) {
                LOGGER.warning("Your data contains NaN/unparseable values!");
            }
            in.close();
            dataset = new DoubleMatrixDataset<String, String>((DoubleMatrix2D)tmpMatrix, rowMap, colMap);
        } else {
            LinkedHashMap<String, Integer> rowMap = new LinkedHashMap<String, Integer>((int)Math.ceil((double)tmpRows / 0.75));
            DenseLargeDoubleMatrix2D tmpMatrix = new DenseLargeDoubleMatrix2D(tmpRows, tmpCols);
            in.open();
            in.readLine();
            int row = 0;
            boolean correctData = true;
            while ((str = in.readLine()) != null) {
                data = splitPatern.split(str);
                if (!rowMap.containsKey(data[0])) {
                    rowMap.put(data[0], row);
                    for (int s = 0; s < tmpCols; ++s) {
                        double d;
                        try {
                            d = Double.parseDouble(data[s + columnOffset]);
                        }
                        catch (NumberFormatException e) {
                            correctData = false;
                            d = Double.NaN;
                        }
                        tmpMatrix.setQuick(row, s, d);
                    }
                    ++row;
                    continue;
                }
                LOGGER.warning("Duplicated row name!");
                throw doubleMatrixDatasetNonUniqueHeaderException;
            }
            if (!correctData) {
                LOGGER.warning("Your data contains NaN/unparseable values!");
            }
            in.close();
            dataset = new DoubleMatrixDataset((DoubleMatrix2D)tmpMatrix, rowMap, colMap);
        }
        LOGGER.log(Level.INFO, "''{0}'' has been loaded, nrRows: {1} nrCols: {2}", new Object[]{fileName, dataset.matrix.rows(), dataset.matrix.columns()});
        return dataset;
    }

    public static DoubleMatrixDataset<String, String> loadSubsetOfDoubleData(String fileName, String delimiter, HashSet<String> desiredRows, HashSet<String> desiredCols) throws IOException {
        DoubleMatrixDataset<String, String> dataset;
        LinkedHashSet<Integer> desiredColPos = new LinkedHashSet<Integer>();
        Pattern splitPatern = Pattern.compile(delimiter);
        int columnOffset = 1;
        TextFile in = new TextFile(fileName, false);
        String str = in.readLine();
        String[] data = splitPatern.split(str);
        int tmpCols = data.length - columnOffset;
        LinkedHashMap<String, Integer> colMap = new LinkedHashMap<String, Integer>((int)Math.ceil((double)tmpCols / 0.75));
        int storedCols = 0;
        for (int s = 0; s < tmpCols; ++s) {
            String colName = data[s + columnOffset];
            if (!colMap.containsKey(colName) && (desiredCols == null || desiredCols.contains(colName) || desiredCols.isEmpty())) {
                colMap.put(colName, storedCols);
                desiredColPos.add(storedCols);
                ++storedCols;
                continue;
            }
            if (!colMap.containsKey(colName)) continue;
            LOGGER.warning("Duplicated column name!");
            System.out.println("Tried to add: " + colName);
            throw doubleMatrixDatasetNonUniqueHeaderException;
        }
        LinkedHashSet<Integer> desiredRowPos = new LinkedHashSet<Integer>();
        int rowsToStore = 0;
        int totalRows = 0;
        while ((str = in.readLine()) != null) {
            String[] info = splitPatern.split(str);
            if (desiredRows == null || desiredRows.contains(info[0]) || desiredRows.isEmpty()) {
                ++rowsToStore;
                desiredRowPos.add(totalRows);
            }
            ++totalRows;
        }
        in.close();
        if ((long)rowsToStore * (long)tmpCols < 0x7FFFFFFDL) {
            DenseDoubleMatrix2D matrix = new DenseDoubleMatrix2D(rowsToStore, storedCols);
            in.open();
            in.readLine();
            int storingRow = 0;
            totalRows = 0;
            LinkedHashMap<String, Integer> rowMap = new LinkedHashMap<String, Integer>((int)Math.ceil((double)rowsToStore / 0.75));
            boolean correctData = true;
            while ((str = in.readLine()) != null) {
                if (desiredRowPos.contains(totalRows)) {
                    data = splitPatern.split(str);
                    if (!rowMap.containsKey(data[0])) {
                        rowMap.put(data[0], storingRow);
                        Iterator i$ = desiredColPos.iterator();
                        while (i$.hasNext()) {
                            double d;
                            int s = (Integer)i$.next();
                            try {
                                d = Double.parseDouble(data[s + columnOffset]);
                            }
                            catch (NumberFormatException e) {
                                correctData = false;
                                d = Double.NaN;
                            }
                            matrix.setQuick(storingRow, s, d);
                        }
                        ++storingRow;
                    } else if (rowMap.containsKey(data[0])) {
                        LOGGER.warning("Duplicated row name!");
                        System.out.println("Tried to add: " + data[0]);
                        throw doubleMatrixDatasetNonUniqueHeaderException;
                    }
                }
                ++totalRows;
            }
            if (!correctData) {
                LOGGER.warning("Your data contains NaN/unparseable values!");
            }
            in.close();
            dataset = new DoubleMatrixDataset<String, String>((DoubleMatrix2D)matrix, rowMap, colMap);
        } else {
            DenseLargeDoubleMatrix2D matrix = new DenseLargeDoubleMatrix2D(rowsToStore, storedCols);
            in.open();
            in.readLine();
            int storingRow = 0;
            totalRows = 0;
            LinkedHashMap<String, Integer> rowMap = new LinkedHashMap<String, Integer>((int)Math.ceil((double)rowsToStore / 0.75));
            boolean correctData = true;
            while ((str = in.readLine()) != null) {
                if (desiredRowPos.contains(totalRows)) {
                    data = splitPatern.split(str);
                    if (!rowMap.containsKey(data[0])) {
                        rowMap.put(data[0], storingRow);
                        Iterator i$ = desiredColPos.iterator();
                        while (i$.hasNext()) {
                            double d;
                            int s = (Integer)i$.next();
                            try {
                                d = Double.parseDouble(data[s + columnOffset]);
                            }
                            catch (NumberFormatException e) {
                                correctData = false;
                                d = Double.NaN;
                            }
                            matrix.setQuick(storingRow, s, d);
                        }
                        ++storingRow;
                    } else if (rowMap.containsKey(data[0])) {
                        LOGGER.warning("Duplicated row name!");
                        System.out.println("Tried to add: " + data[0]);
                        throw doubleMatrixDatasetNonUniqueHeaderException;
                    }
                }
                ++totalRows;
            }
            if (!correctData) {
                LOGGER.warning("Your data contains NaN/unparseable values!");
            }
            in.close();
            dataset = new DoubleMatrixDataset((DoubleMatrix2D)matrix, rowMap, colMap);
        }
        LOGGER.log(Level.INFO, "''{0}'' has been loaded, nrRows: {1} nrCols: {2}", new Object[]{fileName, dataset.matrix.rows(), dataset.matrix.columns()});
        return dataset;
    }

    public void saveLowMemory(String fileName) throws IOException {
        TextFile out = new TextFile(fileName, true);
        ArrayList<C> colObjects = new ArrayList<C>(this.hashCols.keySet());
        ArrayList<R> rowObjects = new ArrayList<R>(this.hashRows.keySet());
        out.append('-');
        for (int s = 0; s < this.matrix.columns(); ++s) {
            out.append('\t');
            out.append(((Comparable)colObjects.get(s)).toString());
        }
        out.append('\n');
        for (int r = 0; r < this.matrix.rows(); ++r) {
            out.append(((Comparable)rowObjects.get(r)).toString());
            DoubleMatrix1D rowInfo = this.getMatrix().viewRow(r);
            int s = 0;
            while ((long)s < rowInfo.size()) {
                out.append('\t');
                out.append(String.valueOf(rowInfo.get(s)));
                ++s;
            }
            out.append('\n');
        }
        out.close();
    }

    public void save(String fileName) throws IOException {
        TextFile out = new TextFile(fileName, true);
        ArrayList<C> colObjects = new ArrayList<C>(this.hashCols.keySet());
        ArrayList<R> rowObjects = new ArrayList<R>(this.hashRows.keySet());
        out.append('-');
        for (int s = 0; s < this.getMatrix().columns(); ++s) {
            out.append('\t');
            out.append(((Comparable)colObjects.get(s)).toString());
        }
        out.append('\n');
        double[][] rawData = this.getMatrix().toArray();
        for (int p = 0; p < rawData.length; ++p) {
            out.append(((Comparable)rowObjects.get(p)).toString());
            for (int s = 0; s < rawData[p].length; ++s) {
                out.append('\t');
                out.append(String.valueOf(rawData[p][s]));
            }
            out.append('\n');
        }
        out.close();
    }

    public int rows() {
        return this.matrix.rows();
    }

    public int columns() {
        return this.matrix.columns();
    }

    public LinkedHashMap<R, Integer> getHashRows() {
        return this.hashRows;
    }

    public void setHashRows(LinkedHashMap<R, Integer> hashRows) {
        this.hashRows = hashRows;
    }

    public LinkedHashMap<C, Integer> getHashCols() {
        return this.hashCols;
    }

    public void setHashCols(LinkedHashMap<C, Integer> hashCols) {
        this.hashCols = hashCols;
    }

    public ArrayList<R> getRowObjects() {
        return new ArrayList<R>(this.hashRows.keySet());
    }

    public void setRowObjects(ArrayList<R> arrayList) throws Exception {
        LinkedHashMap<Comparable, Integer> newHashRows = new LinkedHashMap<Comparable, Integer>((int)Math.ceil((double)arrayList.size() / 0.75));
        int i = 0;
        for (Comparable s : arrayList) {
            if (newHashRows.containsKey(s)) {
                System.out.println("Error, new row names contains dupilcates.");
                throw doubleMatrixDatasetNonUniqueHeaderException;
            }
            newHashRows.put(s, i);
            ++i;
        }
        this.hashRows = newHashRows;
    }

    public ArrayList<C> getColObjects() {
        return new ArrayList<C>(this.hashCols.keySet());
    }

    public void setColObjects(ArrayList<C> arrayList) throws Exception {
        LinkedHashMap<Comparable, Integer> newHashCols = new LinkedHashMap<Comparable, Integer>((int)Math.ceil((double)arrayList.size() / 0.75));
        int i = 0;
        for (Comparable s : arrayList) {
            if (newHashCols.containsKey(s)) {
                System.out.println("Error, new column names contains dupilcates.");
                throw doubleMatrixDatasetNonUniqueHeaderException;
            }
            newHashCols.put(s, i);
            ++i;
        }
        this.hashCols = newHashCols;
    }

    public DoubleMatrix2D getMatrix() {
        return this.matrix;
    }

    public void setMatrix(DoubleMatrix2D matrix) {
        this.matrix = matrix;
    }

    public void setMatrix(double[][] matrix) {
        if ((long)matrix.length * (long)matrix[0].length < 0x7FFFFFFDL) {
            this.matrix = new DenseDoubleMatrix2D(matrix);
        } else {
            this.matrix = new DenseLargeDoubleMatrix2D(matrix.length, matrix[0].length);
            this.matrix.assign(matrix);
        }
    }

    public void OrderOnColumns() {
        LinkedHashMap<Comparable, Integer> newColHash = new LinkedHashMap<Comparable, Integer>((int)Math.ceil((double)this.matrix.columns() / 0.75));
        ArrayList<C> names = this.getColObjects();
        Collections.sort(names);
        int pos = 0;
        for (Comparable name : names) {
            newColHash.put(name, pos);
            ++pos;
        }
        this.reorderCols(newColHash);
    }

    public void OrderOnRows() {
        LinkedHashMap<Comparable, Integer> newRowHash = new LinkedHashMap<Comparable, Integer>((int)Math.ceil((double)this.matrix.rows() / 0.75));
        ArrayList<R> names = this.getRowObjects();
        Collections.sort(names);
        int pos = -1;
        for (Comparable name : names) {
            newRowHash.put(name, ++pos);
        }
        this.reorderRows(newRowHash);
    }

    public void reorderRows(LinkedHashMap<R, Integer> mappingIndex) {
        Object newRawData = (long)this.rows() * (long)this.columns() < 0x7FFFFFFDL ? new DenseDoubleMatrix2D(this.rows(), this.columns()) : new DenseLargeDoubleMatrix2D(this.rows(), this.columns());
        for (Map.Entry<R, Integer> ent : mappingIndex.entrySet()) {
            int pos = this.getHashRows().get(ent.getKey());
            for (int s = 0; s < this.columns(); ++s) {
                newRawData.set(ent.getValue().intValue(), s, this.getMatrix().get(pos, s));
            }
        }
        this.setHashRows(mappingIndex);
        this.setMatrix((DoubleMatrix2D)newRawData);
    }

    public void reorderCols(LinkedHashMap<C, Integer> mappingIndex) {
        Object newRawData = (long)this.rows() * (long)this.columns() < 0x7FFFFFFDL ? new DenseDoubleMatrix2D(this.rows(), this.columns()) : new DenseLargeDoubleMatrix2D(this.rows(), this.columns());
        for (Map.Entry<C, Integer> ent : mappingIndex.entrySet()) {
            int pos = this.getHashCols().get(ent.getKey());
            for (int p = 0; p < this.rows(); ++p) {
                newRawData.set(p, ent.getValue().intValue(), this.getMatrix().get(p, pos));
            }
        }
        this.setHashCols(mappingIndex);
        this.setMatrix((DoubleMatrix2D)newRawData);
    }

    public DoubleMatrixDataset<C, R> viewDice() {
        return new DoubleMatrixDataset<C, R>(this.matrix.viewDice(), this.hashCols, this.hashRows);
    }
}

