/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.math.matrix;

import JSci.maths.ArrayMath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.primitives.ArrayDoubleList;
import org.apache.commons.collections.primitives.ArrayIntList;
import umcg.genetica.math.matrix.DoubleMatrixDataset;
import umcg.genetica.methylation.CheckMatrixForValidBetaValues;

public class MatrixHandling {
    public static void RemoveColumnsWithToManyMissingValues(DoubleMatrixDataset<String, String> dataset, int maxMissingValuesPerColumn) {
        ArrayList columnsToInclude = new ArrayList();
        for (int c = 0; c < dataset.nrCols; ++c) {
            int nrMissing = 0;
            for (int r = 0; r < dataset.nrRows; ++r) {
                if (dataset.rawData[r][c] != -999.0) continue;
                ++nrMissing;
            }
            if (nrMissing >= maxMissingValuesPerColumn) {
                System.out.println("Excluding:\t" + c + "\t" + (String)dataset.colObjects.get(c) + "\t" + nrMissing);
                continue;
            }
            if (nrMissing > 0) {
                columnsToInclude.add(dataset.colObjects.get(c));
                continue;
            }
            columnsToInclude.add(dataset.colObjects.get(c));
        }
        System.out.println(columnsToInclude.size() + "\t" + dataset.nrCols + "\t" + dataset.colObjects.size());
        double[][] newRawData = new double[dataset.nrRows][columnsToInclude.size()];
        String[] newColumnNames = new String[columnsToInclude.size()];
        int sampleId = -1;
        for (int s = 0; s < dataset.nrCols; ++s) {
            if (!columnsToInclude.contains(dataset.colObjects.get(s))) continue;
            newColumnNames[++sampleId] = (String)dataset.colObjects.get(s);
            for (int p = 0; p < dataset.nrRows; ++p) {
                newRawData[p][sampleId] = dataset.rawData[p][s];
            }
        }
        dataset.colObjects = Arrays.asList(newColumnNames);
        dataset.nrCols = columnsToInclude.size();
        dataset.rawData = newRawData;
    }

    public static void RemoveRowsWithToManyMissingValues(DoubleMatrixDataset<String, String> dataset, int maxMissingValuesPerRow) {
        String[] rowNames = dataset.rowObjects.toArray(new String[0]);
        HashMap hashRowsToInclude = new HashMap();
        for (int r = 0; r < dataset.nrRows; ++r) {
            int nrMissing = 0;
            for (int c = 0; c < dataset.nrCols; ++c) {
                if (dataset.rawData[r][c] != -999.0) continue;
                ++nrMissing;
            }
            if (nrMissing >= maxMissingValuesPerRow) {
                System.out.println("Excluding:\t" + r + "\t" + rowNames[r] + "\t" + nrMissing);
                continue;
            }
            if (nrMissing > 0) {
                hashRowsToInclude.put(rowNames[r], null);
                continue;
            }
            hashRowsToInclude.put(rowNames[r], null);
        }
        double[][] newRawData = new double[hashRowsToInclude.size()][dataset.nrCols];
        String[] newRowNames = new String[hashRowsToInclude.size()];
        int probeId = -1;
        for (int p = 0; p < dataset.nrRows; ++p) {
            if (!hashRowsToInclude.containsKey(rowNames[p])) continue;
            newRowNames[++probeId] = rowNames[p];
            for (int s = 0; s < dataset.nrCols; ++s) {
                newRawData[probeId][s] = dataset.rawData[p][s];
            }
        }
        dataset.rowObjects = Arrays.asList(newRowNames);
        dataset.nrRows = hashRowsToInclude.size();
        dataset.rawData = newRawData;
        dataset.recalculateHashMaps();
    }

    public static void RemoveDuplicatesSamples(DoubleMatrixDataset<String, String> dataset, boolean advanced) {
        if (advanced) {
            throw new UnsupportedOperationException("Not yet implemented");
        }
        ArrayList<Integer> removeEntry = new ArrayList<Integer>();
        for (int i = 0; i < dataset.nrCols; ++i) {
            if (dataset.colObjects.get(i) == null) {
                removeEntry.add(i);
                continue;
            }
            List tmp = dataset.colObjects.subList(i + 1, dataset.nrCols);
            if (!tmp.contains(dataset.colObjects.get(i))) continue;
            removeEntry.add(i);
        }
        if (removeEntry.size() > 0) {
            int newSize = dataset.nrCols - removeEntry.size();
            double[][] newRawData = new double[dataset.nrRows][newSize];
            String[] newColumnNames = new String[newSize];
            int sampleId = -1;
            for (int s = 0; s < dataset.nrCols; ++s) {
                if (removeEntry.contains(s)) continue;
                newColumnNames[++sampleId] = (String)dataset.colObjects.get(s);
                for (int p = 0; p < dataset.nrRows; ++p) {
                    newRawData[p][sampleId] = dataset.rawData[p][s];
                }
            }
            dataset.colObjects = Arrays.asList(newColumnNames);
            dataset.nrCols = newSize;
            dataset.rawData = newRawData;
            dataset.recalculateHashMaps();
        }
    }

    public static void RemoveRows(DoubleMatrixDataset<String, String> dataset, HashSet<String> probesToBeRemoved) {
        int newSize = 0;
        for (String t : dataset.rowObjects) {
            if (probesToBeRemoved.contains(t)) continue;
            ++newSize;
        }
        double[][] newRawData = new double[newSize][dataset.nrCols];
        String[] newRowNames = new String[newSize];
        int probeId = -1;
        for (int p = 0; p < dataset.nrRows; ++p) {
            if (probesToBeRemoved.contains(dataset.rowObjects.get(p))) continue;
            newRowNames[++probeId] = (String)dataset.rowObjects.get(p);
            newRawData[probeId] = dataset.rawData[p];
        }
        dataset.rowObjects = Arrays.asList(newRowNames);
        dataset.nrRows = newSize;
        dataset.rawData = newRawData;
        dataset.recalculateHashMaps();
    }

    public static void FilterRows(DoubleMatrixDataset<String, String> dataset, HashSet<String> probesToKeep) {
        int newSize = 0;
        for (String t : dataset.rowObjects) {
            if (!probesToKeep.contains(t)) continue;
            ++newSize;
        }
        double[][] newRawData = new double[newSize][dataset.nrCols];
        String[] newRowNames = new String[newSize];
        int probeId = -1;
        for (int p = 0; p < dataset.nrRows; ++p) {
            if (!probesToKeep.contains(dataset.rowObjects.get(p))) continue;
            newRowNames[++probeId] = (String)dataset.rowObjects.get(p);
            newRawData[probeId] = dataset.rawData[p];
        }
        dataset.rowObjects = Arrays.asList(newRowNames);
        dataset.nrRows = newSize;
        dataset.rawData = newRawData;
        dataset.recalculateHashMaps();
    }

    public static void RemoveProbes(DoubleMatrixDataset<String, String> dataset, HashSet<String> probesToBeRemoved) {
        MatrixHandling.RemoveRows(dataset, probesToBeRemoved);
    }

    public static void RemoveColumns(DoubleMatrixDataset<String, String> dataset, HashSet<String> samplesToBeRemoved) {
        int newSize = 0;
        for (String t : dataset.colObjects) {
            if (samplesToBeRemoved.contains(t)) continue;
            ++newSize;
        }
        double[][] newRawData = new double[dataset.nrRows][newSize];
        String[] newColNames = new String[newSize];
        int sampleId = -1;
        for (int s = 0; s < dataset.nrCols; ++s) {
            if (samplesToBeRemoved.contains(dataset.colObjects.get(s))) continue;
            newColNames[++sampleId] = (String)dataset.colObjects.get(s);
            for (int p = 0; p < dataset.nrRows; ++p) {
                newRawData[p][sampleId] = dataset.rawData[p][s];
            }
        }
        dataset.colObjects = Arrays.asList(newColNames);
        dataset.nrCols = newSize;
        dataset.rawData = newRawData;
        dataset.recalculateHashMaps();
    }

    public static void RemoveSamples(DoubleMatrixDataset<String, String> dataset, HashSet<String> samplesToBeRemoved) {
        MatrixHandling.RemoveColumns(dataset, samplesToBeRemoved);
    }

    public static void OrderOnRows(DoubleMatrixDataset doubleMatrixDataset) {
        HashMap originalRowMap = (HashMap)doubleMatrixDataset.hashRows;
        ArrayList rowNames = new ArrayList(doubleMatrixDataset.rowObjects);
        HashMap newRowMap = new HashMap();
        Collections.sort(rowNames);
        for (int i = 0; i < rowNames.size(); ++i) {
            newRowMap.put(rowNames.get(i), i);
        }
        double[][] newRawData = new double[doubleMatrixDataset.nrRows][doubleMatrixDataset.nrCols];
        for (String rName : rowNames) {
            int originalprobeId = (Integer)originalRowMap.get(rName);
            int newprobeId = (Integer)newRowMap.get(rName);
            newRawData[newprobeId] = doubleMatrixDataset.rawData[originalprobeId];
        }
        doubleMatrixDataset.rowObjects = rowNames;
        doubleMatrixDataset.rawData = newRawData;
        doubleMatrixDataset.recalculateHashMaps();
    }

    public static void OrderOnColumns(DoubleMatrixDataset doubleMatrixDataset) {
        HashMap originalColMap = (HashMap)doubleMatrixDataset.hashCols;
        ArrayList colNames = new ArrayList(doubleMatrixDataset.colObjects);
        HashMap newColMap = new HashMap();
        Collections.sort(colNames);
        for (int i = 0; i < colNames.size(); ++i) {
            newColMap.put(colNames.get(i), i);
        }
        double[][] newRawData = new double[doubleMatrixDataset.nrRows][doubleMatrixDataset.nrCols];
        for (String cName : colNames) {
            int originalSampleId = (Integer)originalColMap.get(cName);
            int newSampleId = (Integer)newColMap.get(cName);
            for (int r = 0; r < doubleMatrixDataset.nrRows; ++r) {
                newRawData[r][newSampleId] = doubleMatrixDataset.rawData[r][originalSampleId];
            }
        }
        doubleMatrixDataset.colObjects = colNames;
        doubleMatrixDataset.rawData = newRawData;
        doubleMatrixDataset.recalculateHashMaps();
    }

    public static void ReorderRows(DoubleMatrixDataset<String, String> dataset, HashMap<String, Integer> mappingIndex) {
        double[][] newRawData = new double[mappingIndex.size()][dataset.nrCols];
        String[] newRowNames = new String[mappingIndex.size()];
        for (Map.Entry<String, Integer> instance : mappingIndex.entrySet()) {
            newRowNames[instance.getValue().intValue()] = instance.getKey();
            for (int s = 0; s < dataset.nrCols; ++s) {
                newRawData[instance.getValue().intValue()][s] = dataset.rawData[(Integer)dataset.hashRows.get(instance.getKey())][s];
            }
        }
        dataset.rowObjects = Arrays.asList(newRowNames);
        dataset.nrRows = mappingIndex.size();
        dataset.rawData = newRawData;
        dataset.recalculateHashMaps();
    }

    public static void ReplaceMissingValues(double[][] rawData, boolean useMedian) {
        for (int s = 0; s < rawData[1].length; ++s) {
            System.out.println("Processing sample: " + s);
            boolean needsReplacement = false;
            ArrayDoubleList nonNAvalues = new ArrayDoubleList();
            for (int p = 0; p < rawData.length; ++p) {
                if (rawData[p][s] == -999.0) {
                    needsReplacement = true;
                    continue;
                }
                nonNAvalues.add(rawData[p][s]);
            }
            if (!needsReplacement) continue;
            double replacementValue = useMedian ? ArrayMath.median((double[])nonNAvalues.toArray(new double[0])) : ArrayMath.mean((double[])nonNAvalues.toArray(new double[0]));
            for (int p = 0; p < rawData.length; ++p) {
                if (rawData[p][s] != -999.0) continue;
                rawData[p][s] = replacementValue;
            }
        }
    }

    public static void performQC(DoubleMatrixDataset<String, String> dataset, ArrayList<String> probesToBeRemoved, ArrayList<String> samplesToBeRemoved, boolean replaceKnownOutOfRangeValues, int maxMissingSamplesMissingAProbe, int maxMissingProbesMissingPerSample) {
        int originalNumberSamples = dataset.nrCols;
        int originalNumberProbes = dataset.nrRows;
        MatrixHandling.RemoveDuplicatesSamples(dataset, false);
        System.out.println(dataset.nrCols);
        System.out.println(originalNumberSamples);
        MatrixHandling.RemoveProbes(dataset, new HashSet<String>(probesToBeRemoved));
        System.out.println(originalNumberProbes - dataset.nrRows);
        MatrixHandling.RemoveSamples(dataset, new HashSet<String>(probesToBeRemoved));
        ArrayList<String> extraSamplesToBeRemoved = CheckMatrixForValidBetaValues.checkMinAndMaxPerSample(dataset, replaceKnownOutOfRangeValues);
        MatrixHandling.RemoveSamples(dataset, new HashSet<String>(probesToBeRemoved));
        MatrixHandling.RemoveColumnsWithToManyMissingValues(dataset, maxMissingProbesMissingPerSample);
        System.out.println("Number of samples removed: " + (originalNumberSamples - dataset.rawData[1].length));
        MatrixHandling.RemoveRowsWithToManyMissingValues(dataset, maxMissingSamplesMissingAProbe);
        System.out.println("Number of probes removed: " + (originalNumberProbes - dataset.rawData.length));
    }

    public static void FilterCols(DoubleMatrixDataset<String, String> dataset, HashSet<String> keepCols) {
        int newSize = 0;
        for (String t : dataset.colObjects) {
            if (!keepCols.contains(t)) continue;
            ++newSize;
        }
        double[][] newRawData = new double[dataset.nrRows][newSize];
        String[] newColNames = new String[newSize];
        int sampleId = -1;
        for (int s = 0; s < dataset.nrCols; ++s) {
            if (!keepCols.contains(dataset.colObjects.get(s))) continue;
            newColNames[++sampleId] = (String)dataset.colObjects.get(s);
            for (int p = 0; p < dataset.nrRows; ++p) {
                newRawData[p][sampleId] = dataset.rawData[p][s];
            }
        }
        dataset.colObjects = Arrays.asList(newColNames);
        dataset.nrCols = newSize;
        System.out.println(newSize);
        dataset.rawData = newRawData;
        dataset.recalculateHashMaps();
    }

    public static void RenameCols(DoubleMatrixDataset<String, String> dataset, HashMap<String, String> newNames) {
        String[] newColNames = new String[dataset.nrCols];
        for (int s = 0; s < dataset.nrCols; ++s) {
            newColNames[s] = newNames.containsKey(dataset.colObjects.get(s)) ? newNames.get(dataset.colObjects.get(s)) : (String)dataset.colObjects.get(s);
        }
        dataset.colObjects = Arrays.asList(newColNames);
        dataset.recalculateHashMaps();
    }

    public static void appendStringToColnames(DoubleMatrixDataset<String, String> in, String tissueSource) {
        ArrayList<String> newColObjects = new ArrayList<String>();
        for (String t : in.colObjects) {
            StringBuilder colName = new StringBuilder();
            colName.append(tissueSource);
            colName.append("_");
            colName.append(t);
            newColObjects.add(colName.toString());
        }
        in.colObjects = newColObjects;
        in.recalculateHashMaps();
    }

    public static void RemoveDuplicateRowNames(DoubleMatrixDataset<String, String> dataset) {
        int newSize = 0;
        HashSet<String> entries = new HashSet<String>();
        ArrayIntList listRemoveRows = new ArrayIntList();
        int i = 0;
        for (String t : dataset.rowObjects) {
            if (!entries.contains(t)) {
                ++newSize;
                entries.add(t);
            } else {
                listRemoveRows.add(i);
            }
            ++i;
        }
        double[][] newRawData = new double[newSize][dataset.nrCols];
        String[] newRowNames = new String[newSize];
        int probeId = -1;
        for (int p = 0; p < dataset.nrRows; ++p) {
            if (listRemoveRows.contains(p)) continue;
            newRowNames[++probeId] = (String)dataset.rowObjects.get(p);
            newRawData[probeId] = dataset.rawData[p];
        }
        dataset.rowObjects = Arrays.asList(newRowNames);
        dataset.nrRows = newSize;
        dataset.rawData = newRawData;
        dataset.recalculateHashMaps();
    }
}

