/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.io.ucsc;

public class UCSCDataObject
implements Comparable<UCSCDataObject> {
    private byte chr;
    private int positionStart;
    private int positionEnd;
    private double value;
    private SORTBY s = SORTBY.CHRPOS;

    public UCSCDataObject(byte chr, int posStart, int posEnd, double v, SORTBY sort) {
        this.chr = chr;
        this.positionStart = posStart;
        this.positionEnd = posEnd;
        this.value = v;
        this.s = sort;
    }

    @Override
    public int compareTo(UCSCDataObject o) {
        if (o == null) {
            throw new IllegalArgumentException("Error comparing UCSC data objects: including NULL objects in sort!");
        }
        if (this.s == SORTBY.CHRPOS) {
            if (this.equals(o)) {
                return 0;
            }
            if (this.chr > o.chr) {
                return 1;
            }
            if (this.chr < o.chr) {
                return -1;
            }
            if (this.positionStart > o.positionStart) {
                return 1;
            }
            return -1;
        }
        if (this.equals(o)) {
            return 0;
        }
        if (this.value > o.value) {
            return 1;
        }
        return -1;
    }

    public boolean equals(UCSCDataObject o) {
        if (o == null) {
            return false;
        }
        if (o.s != this.s) {
            throw new IllegalArgumentException("Error: sort types are not identical!");
        }
        if (this.s == SORTBY.CHRPOS) {
            return o.chr == this.chr && o.positionStart == this.positionStart && o.positionEnd == this.positionEnd;
        }
        return o.value == this.value;
    }

    public String toString() {
        return "chr: " + this.chr + "\tstart: " + this.positionStart + "\tend: " + this.positionEnd + "\tvalue: " + this.value;
    }

    public byte getChr() {
        return this.chr;
    }

    public int getPositionEnd() {
        return this.positionEnd;
    }

    public int getPositionStart() {
        return this.positionStart;
    }

    public double getValue() {
        return this.value;
    }

    public static enum SORTBY {
        CHRPOS,
        VALUE;

    }
}

