/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.io.trityper.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import umcg.genetica.io.Gpio;
import umcg.genetica.io.bin.BinaryFile;
import umcg.genetica.io.text.TextFile;

public class TriTyperConcatDatasets {
    private final ArrayList<String> datasetsToConcatFolders;
    private final String outputFolder;
    private final HashSet<String> totalSnps;

    public TriTyperConcatDatasets(String outputFolderPath) throws IOException {
        this.outputFolder = outputFolderPath;
        this.datasetsToConcatFolders = new ArrayList();
        this.totalSnps = new HashSet();
        Gpio.createDir(outputFolderPath);
    }

    public void addDatasetToConcat(String datasetFolderPath) throws IOException {
        if (!Gpio.exists(datasetFolderPath)) {
            throw new FileNotFoundException("Folder with dataset to concat does not exists: " + datasetFolderPath);
        }
        if (!Gpio.isDir(datasetFolderPath)) {
            throw new IOException("Path to folder with dataset to concat is not a folder: " + datasetFolderPath);
        }
        if (!Gpio.canRead(datasetFolderPath)) {
            throw new IOException("Can not read folder of dataset to concat: " + datasetFolderPath);
        }
        if (!datasetFolderPath.endsWith(Gpio.getFileSeparator())) {
            datasetFolderPath = datasetFolderPath + Gpio.getFileSeparator();
        }
        this.datasetsToConcatFolders.add(datasetFolderPath);
    }

    public void writeConcatedDataset() throws FileNotFoundException, IOException, Exception {
        if (this.datasetsToConcatFolders.isEmpty()) {
            System.out.println("No data to concatenate");
            return;
        }
        System.out.println("Concatenating data to: " + this.outputFolder);
        TextFile outputSnps = new TextFile(this.outputFolder + "SNPs.txt", true);
        BinaryFile outputGenotypeMatrix = new BinaryFile(this.outputFolder + "GenotypeMatrix.dat", true, 8192);
        BinaryFile outputImputedDosageMatrix = null;
        TextFile outputMappings = null;
        boolean concatImputedDosageMatrix = this.hasDatasetFolderImputedDosageMatrix(this.datasetsToConcatFolders.get(0));
        boolean concatSnpMappings = this.hasDatasetFolderSnpMapping(this.datasetsToConcatFolders.get(0));
        List<String> individuals = null;
        if (concatImputedDosageMatrix) {
            outputImputedDosageMatrix = new BinaryFile(this.outputFolder + "ImputedDosageMatrix.dat", true, 8192);
        }
        if (concatSnpMappings) {
            System.out.println("SNP mappigns detected and will be concatted");
            outputMappings = new TextFile(this.outputFolder + "SNPMappings.txt", true);
        }
        for (String datasetToConcatFolder : this.datasetsToConcatFolders) {
            System.out.println("Adding data from: " + datasetToConcatFolder);
            if (individuals == null) {
                individuals = this.readIndividuals(datasetToConcatFolder);
            } else if (!((Object)individuals).equals(this.readIndividuals(datasetToConcatFolder))) {
                throw new Exception("Individuals.txt does not match for dataset (check whether the order, number and identifiers of samples are identical): " + datasetToConcatFolder);
            }
            TextFile intputSnps = new TextFile(datasetToConcatFolder + "SNPs.txt", false);
            this.addSnpsToTotalList(intputSnps, outputSnps);
            intputSnps.close();
            BinaryFile intputGenotypeMatrix = new BinaryFile(datasetToConcatFolder + "GenotypeMatrix.dat", false, 8192);
            this.addInputStreamToOutputStream(intputGenotypeMatrix, outputGenotypeMatrix);
            intputGenotypeMatrix.close();
            if (concatImputedDosageMatrix) {
                BinaryFile intputImputedDosageMatrix = new BinaryFile(datasetToConcatFolder + "ImputedDosageMatrix.dat", false, 8192);
                this.addInputStreamToOutputStream(intputImputedDosageMatrix, outputImputedDosageMatrix);
                intputImputedDosageMatrix.close();
            }
            if (!concatSnpMappings) continue;
            TextFile inputSnpMappings = new TextFile(datasetToConcatFolder + "SNPMappings.txt", false);
            this.copyContent(inputSnpMappings, outputMappings);
            inputSnpMappings.close();
        }
        outputSnps.close();
        outputGenotypeMatrix.close();
        if (concatImputedDosageMatrix) {
            outputImputedDosageMatrix.close();
        }
        this.writeIndividuals(this.outputFolder, individuals);
        if (this.hasDatasetFolderPhenoInfo(this.datasetsToConcatFolders.get(0))) {
            System.out.println("Detected pheno information this is copied");
            TextFile outputPheno = new TextFile(this.outputFolder + "PhenotypeInformation.txt", true);
            TextFile inputPheno = new TextFile(this.datasetsToConcatFolders.get(0) + "PhenotypeInformation.txt", false);
            this.copyContent(inputPheno, outputPheno);
            outputPheno.close();
            inputPheno.close();
        }
        System.out.println("Concatenated data written");
    }

    private void addInputStreamToOutputStream(BinaryFile input, BinaryFile output) throws IOException {
        int i;
        while ((i = input.read()) != -1) {
            output.write(i);
        }
    }

    private void addSnpsToTotalList(TextFile snpFileReader, TextFile snpFileWriter) throws IOException, Exception {
        String line;
        while ((line = snpFileReader.readLine()) != null) {
            if (this.totalSnps.contains(line)) {
                throw new Exception("Snp: " + line + " is present twice");
            }
            this.totalSnps.add(line);
            snpFileWriter.writeln(line);
        }
    }

    private void copyContent(TextFile source, TextFile target) throws IOException, Exception {
        String line;
        while ((line = source.readLine()) != null) {
            target.writeln(line);
        }
    }

    private boolean hasDatasetFolderImputedDosageMatrix(String trityperDatasetFolder) {
        return Gpio.exists(trityperDatasetFolder + "ImputedDosageMatrix.dat");
    }

    private boolean hasDatasetFolderSnpMapping(String trityperDatasetFolder) {
        return Gpio.exists(trityperDatasetFolder + "SNPMappings.txt");
    }

    private boolean hasDatasetFolderPhenoInfo(String trityperDatasetFolder) {
        return Gpio.exists(trityperDatasetFolder + "PhenotypeInformation.txt");
    }

    private List<String> readIndividuals(String trityperDatasetFolder) throws FileNotFoundException, IOException {
        ArrayList<String> individuals = null;
        TextFile sampleFile = new TextFile(trityperDatasetFolder + "Individuals.txt", false);
        individuals = sampleFile.readAsArrayList();
        sampleFile.close();
        return Collections.unmodifiableList(individuals);
    }

    private void writeIndividuals(String targetFolder, List<String> individuals) throws IOException {
        TextFile individualsWriter = new TextFile(targetFolder + "Individuals.txt", true);
        individualsWriter.writeList(individuals);
        individualsWriter.close();
    }
}

