/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.io.trityper.util;

import umcg.genetica.text.Strings;

public class BaseAnnot {
    public static final byte A = 65;
    public static final byte C = 67;
    public static final byte T = 84;
    public static final byte G = 71;
    public static final byte U = 85;
    public static final byte I = 73;
    public static final byte N = 78;

    public static byte[] convertToComplementaryAlleles(byte[] allelesToCompare) {
        byte[] allelesComplementary = new byte[2];
        for (int a = 0; a < 2; ++a) {
            allelesComplementary[a] = BaseAnnot.getComplement(allelesToCompare[a]);
        }
        return allelesComplementary;
    }

    public static Boolean flipalleles(String allelesSNP1, String alleleAssessedSNP1, String allelesSNP2, String alleleAssessedSNP2) {
        int j;
        byte allele1;
        int i;
        String[] allelesSNP1Arr = allelesSNP1.split("/");
        byte[] allelesfirst = new byte[2];
        String[] allelesSNP2Arr = allelesSNP2.split("/");
        byte[] allelessecond = new byte[2];
        for (int i2 = 0; i2 < 2; ++i2) {
            allelesfirst[i2] = BaseAnnot.toByte(allelesSNP1Arr[i2]);
            allelessecond[i2] = BaseAnnot.toByte(allelesSNP2Arr[i2]);
        }
        byte allelefirstassessed = BaseAnnot.toByte(alleleAssessedSNP1);
        byte allelesecondassessed = BaseAnnot.toByte(alleleAssessedSNP2);
        int nridenticalalleles = 0;
        for (i = 0; i < allelesfirst.length; ++i) {
            allele1 = allelesfirst[i];
            for (j = 0; j < allelessecond.length; ++j) {
                if (allelessecond[j] != allele1) continue;
                ++nridenticalalleles;
            }
        }
        if (nridenticalalleles == 2) {
            if (allelefirstassessed == allelesecondassessed) {
                return false;
            }
            return true;
        }
        allelessecond = BaseAnnot.convertToComplementaryAlleles(allelessecond);
        allelesecondassessed = BaseAnnot.getComplement(allelesecondassessed);
        nridenticalalleles = 0;
        for (i = 0; i < allelesfirst.length; ++i) {
            allele1 = allelesfirst[i];
            for (j = 0; j < allelessecond.length; ++j) {
                if (allelessecond[j] != allele1) continue;
                ++nridenticalalleles;
            }
        }
        if (nridenticalalleles == 2) {
            if (allelefirstassessed == allelesecondassessed) {
                return false;
            }
            return true;
        }
        return null;
    }

    public static String toString(byte x) {
        if (x == 65) {
            return "A";
        }
        if (x == 84) {
            return "T";
        }
        if (x == 85) {
            return "U";
        }
        if (x == 67) {
            return "C";
        }
        if (x == 71) {
            return "G";
        }
        if (x == 78) {
            return "N";
        }
        if (x == 73) {
            return "I";
        }
        return "0";
    }

    public static byte getComplement(byte x) {
        if (x == 65) {
            return 84;
        }
        if (x == 84) {
            return 65;
        }
        if (x == 85) {
            return 65;
        }
        if (x == 67) {
            return 71;
        }
        if (x == 71) {
            return 67;
        }
        if (x == 73) {
            return 73;
        }
        if (x == 78) {
            return 78;
        }
        return 0;
    }

    public static String getReverseComplement(String str) {
        String reverse = Strings.reverse(str);
        String reversecomplement = BaseAnnot.getFullComplement(reverse);
        return reversecomplement;
    }

    public static String getFullComplement(String longstr) {
        StringBuilder buffer = new StringBuilder(longstr.length());
        for (int i = 0; i < longstr.length(); ++i) {
            buffer.append(BaseAnnot.getComplement("" + longstr.charAt(i)));
        }
        return null;
    }

    public static String getComplement(String x) {
        if (x.equals("A")) {
            return "T";
        }
        if (x.equals("T")) {
            return "A";
        }
        if (x.equals("U")) {
            return "A";
        }
        if (x.equals("C")) {
            return "G";
        }
        if (x.equals("G")) {
            return "C";
        }
        if (x.equals("N")) {
            return "N";
        }
        if (x.equals("I")) {
            return "I";
        }
        return "0";
    }

    public static byte toByte(String x) {
        if (x.equals("A")) {
            return 65;
        }
        if (x.equals("C")) {
            return 67;
        }
        if (x.equals("T")) {
            return 84;
        }
        if (x.equals("G")) {
            return 71;
        }
        if (x.equals("N")) {
            return 78;
        }
        if (x.equals("U")) {
            return 85;
        }
        if (x.equals("N")) {
            return 78;
        }
        if (x.equals("I")) {
            return 73;
        }
        return 0;
    }

    public static String getAllelesDescription(byte[] alleles) {
        return BaseAnnot.toString(alleles[0]) + "/" + BaseAnnot.toString(alleles[1]);
    }
}

